/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.network.message;

import li.cil.oc2r.common.bus.CommonDeviceBusController;
import li.cil.oc2r.common.entity.Robot;
import li.cil.oc2r.common.network.MessageUtils;
import li.cil.oc2r.common.network.message.AbstractMessage;
import li.cil.oc2r.common.serialization.NBTSerialization;
import li.cil.oc2r.common.vm.VMRunState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public final class RobotInitializationMessage
extends AbstractMessage {
    private int entityId;
    private CommonDeviceBusController.BusState busState;
    private VMRunState runState;
    private Component bootError;
    private CompoundTag terminal;

    public RobotInitializationMessage(Robot robot) {
        this.entityId = robot.m_19879_();
        this.busState = robot.getVirtualMachine().getBusState();
        this.runState = robot.getVirtualMachine().getRunState();
        this.bootError = robot.getVirtualMachine().getBootError();
        this.terminal = NBTSerialization.serialize(robot.getTerminal());
    }

    public RobotInitializationMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.entityId = buffer.m_130242_();
        this.busState = (CommonDeviceBusController.BusState)buffer.m_130066_(CommonDeviceBusController.BusState.class);
        this.runState = (VMRunState)buffer.m_130066_(VMRunState.class);
        this.bootError = buffer.m_130238_();
        this.terminal = buffer.m_130260_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130068_((Enum)this.busState);
        buffer.m_130068_((Enum)this.runState);
        buffer.m_130083_(this.bootError);
        buffer.m_130079_(this.terminal);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withClientEntity(this.entityId, Robot.class, robot -> {
            robot.getVirtualMachine().setBusStateClient(this.busState);
            robot.getVirtualMachine().setRunStateClient(this.runState);
            robot.getVirtualMachine().setBootErrorClient(this.bootError);
            NBTSerialization.deserialize(this.terminal, robot.getTerminal());
        });
    }
}

