/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;

public record ChunkLocation(WeakReference<LevelAccessor> level, ChunkPos position) {
    public static ChunkLocation of(LevelAccessor level, BlockPos position) {
        return new ChunkLocation(new WeakReference<LevelAccessor>(level), new ChunkPos(position));
    }

    public static ChunkLocation of(LevelAccessor level, ChunkPos position) {
        return new ChunkLocation(new WeakReference<LevelAccessor>(level), position);
    }

    public Optional<LevelAccessor> tryGetLevel() {
        return Optional.ofNullable((LevelAccessor)this.level.get());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ChunkLocation) {
            LevelAccessor thatLevel;
            ChunkLocation that = (ChunkLocation)obj;
            LevelAccessor thisLevel = (LevelAccessor)this.level.get();
            return Objects.equals(thisLevel, thatLevel = (LevelAccessor)that.level.get()) && Objects.equals(this.position, that.position);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.level.get(), this.position);
    }
}

