/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.util;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ChunkUtils {
    private static final Set<ChunkAccess> UNSAVED_CHUNKS = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public static void setLazyUnsaved(ChunkAccess chunkAccess) {
        UNSAVED_CHUNKS.add(chunkAccess);
    }

    public static void setLazyUnsaved(LevelAccessor level, BlockPos blockPos) {
        int chunkZ;
        int chunkX = SectionPos.m_123171_((int)blockPos.m_123341_());
        if (level.m_7232_(chunkX, chunkZ = SectionPos.m_123171_((int)blockPos.m_123343_()))) {
            ChunkUtils.setLazyUnsaved(level.m_6325_(chunkX, chunkZ));
        }
    }

    public static void setLazyUnsaved(LevelAccessor level, ChunkPos chunkPos) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        if (level.m_7232_(chunkX, chunkZ)) {
            ChunkUtils.setLazyUnsaved(level.m_6325_(chunkX, chunkZ));
        }
    }

    public static void applyChunkLazyUnsaved() {
        for (ChunkAccess chunk : UNSAVED_CHUNKS) {
            chunk.m_8092_(true);
        }
        UNSAVED_CHUNKS.clear();
    }

    @SubscribeEvent
    public static void handleChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunk = event.getChunk();
        if (UNSAVED_CHUNKS.remove(chunk)) {
            chunk.m_8092_(true);
        }
    }
}

