/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.util;

import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2r.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class ItemStackUtils {
    public static CompoundTag getModDataTag(ItemStack stack) {
        return NBTUtils.getChildTag(stack.m_41783_(), "oc2r");
    }

    public static CompoundTag getOrCreateModDataTag(ItemStack stack) {
        return NBTUtils.getOrCreateChildTag(stack.m_41784_(), "oc2r");
    }

    @Nullable
    public static BlockState getBlockState(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block == null || block == Blocks.f_50016_) {
            return null;
        }
        return block.m_49966_();
    }

    public static Optional<ItemEntity> spawnAsEntity(Level level, BlockPos pos, ItemStack stack) {
        return ItemStackUtils.spawnAsEntity(level, Vec3.m_82512_((Vec3i)pos), stack);
    }

    public static Optional<ItemEntity> spawnAsEntity(Level level, Vec3 pos, ItemStack stack) {
        if (level.m_5776_() || stack.m_41619_()) {
            return Optional.empty();
        }
        RandomSource rng = level.f_46441_;
        float tx = 0.5f * (rng.m_188501_() - 1.0f);
        float ty = 0.5f * (rng.m_188501_() - 1.0f);
        float tz = 0.5f * (rng.m_188501_() - 1.0f);
        double px = pos.f_82479_ + (double)tx;
        double py = pos.f_82480_ + (double)ty;
        double pz = pos.f_82481_ + (double)tz;
        ItemEntity entity = new ItemEntity(level, px, py, pz, stack);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
        return Optional.of(entity);
    }

    public static Optional<ItemEntity> spawnAsEntity(Level level, BlockPos pos, ItemStack stack, @Nullable Direction direction) {
        return ItemStackUtils.spawnAsEntity(level, Vec3.m_82512_((Vec3i)pos), stack, direction);
    }

    public static Optional<ItemEntity> spawnAsEntity(Level level, Vec3 pos, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return ItemStackUtils.spawnAsEntity(level, pos, stack);
        }
        if (level.f_46443_ || stack.m_41619_()) {
            return Optional.empty();
        }
        RandomSource rng = level.f_46441_;
        float ox = direction.m_122429_();
        float oy = direction.m_122430_();
        float oz = direction.m_122431_();
        float tx = 0.1f * (rng.m_188501_() - 0.5f) + ox * 0.65f;
        float ty = 0.1f * (rng.m_188501_() - 0.5f) + oy * 0.75f + (ox + oz) * 0.25f;
        float tz = 0.1f * (rng.m_188501_() - 0.5f) + oz * 0.65f;
        double px = pos.f_82479_ + (double)tx;
        double py = pos.f_82480_ + (double)ty;
        double pz = pos.f_82481_ + (double)tz;
        ItemEntity entity = new ItemEntity(level, px, py, pz, stack);
        entity.m_20334_(0.0125 * (rng.m_188500_() - 0.5) + (double)ox * 0.03, 0.0125 * (rng.m_188500_() - 0.5) + (double)oy * 0.08 + (double)(ox + oz) * 0.03, 0.0125 * (rng.m_188500_() - 0.5) + (double)oz * 0.03);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
        return Optional.of(entity);
    }
}

