/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.util;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public final class NBTUtils {
    public static <T extends Enum<T>> void putEnum(CompoundTag compound, String key, @Nullable Enum<T> value) {
        if (value != null) {
            compound.m_128405_(key, value.ordinal());
        }
    }

    @Nullable
    public static <T extends Enum<T>> T getEnum(CompoundTag compound, String key, Class<T> enumType) {
        if (!compound.m_128425_(key, 3)) {
            return null;
        }
        int ordinal = compound.m_128451_(key);
        try {
            return (T)((Enum[])enumType.getEnumConstants())[ordinal];
        }
        catch (IndexOutOfBoundsException ignored) {
            return null;
        }
    }

    public static CompoundTag getChildTag(@Nullable CompoundTag tag, String ... path) {
        if (tag == null) {
            return new CompoundTag();
        }
        CompoundTag childTag = tag;
        for (String tagName : path) {
            if (!childTag.m_128425_(tagName, 10)) {
                return new CompoundTag();
            }
            childTag = childTag.m_128469_(tagName);
        }
        return childTag;
    }

    public static CompoundTag getOrCreateChildTag(CompoundTag tag, String ... path) {
        CompoundTag childTag = tag;
        for (String tagName : path) {
            if (!childTag.m_128425_(tagName, 10)) {
                childTag.m_128365_(tagName, (Tag)new CompoundTag());
            }
            childTag = childTag.m_128469_(tagName);
        }
        return childTag;
    }

    public static CompoundTag makeInventoryTag(ItemStack ... items) {
        return new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])items)).serializeNBT();
    }
}

