/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm;

import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import java.nio.ByteBuffer;
import li.cil.oc2r.common.vm.AbstractVirtualMachine;
import li.cil.oc2r.common.vm.Terminal;
import li.cil.oc2r.common.vm.VMRunner;
import li.cil.sedna.device.serial.UART16550A;

public abstract class AbstractTerminalVMRunner
extends VMRunner {
    private final UART16550A uart;
    private final Terminal terminal;
    private final ByteArrayFIFOQueue outputBuffer = new ByteArrayFIFOQueue(1024);
    private final ByteArrayFIFOQueue inputBuffer = new ByteArrayFIFOQueue(32);

    public AbstractTerminalVMRunner(AbstractVirtualMachine virtualMachine, Terminal terminal) {
        super(virtualMachine);
        this.terminal = terminal;
        this.uart = virtualMachine.state.builtinDevices.uart;
    }

    protected abstract void sendTerminalUpdateToClient(ByteBuffer var1);

    @Override
    protected void handleBeforeRun() {
        int value;
        super.handleBeforeRun();
        while ((value = this.terminal.readInput()) != -1) {
            this.inputBuffer.enqueue((byte)value);
        }
    }

    @Override
    protected void step(int cyclesPerStep) {
        int value;
        super.step(cyclesPerStep);
        while (!this.inputBuffer.isEmpty() && this.uart.canPutByte()) {
            this.uart.putByte(this.inputBuffer.dequeueByte());
        }
        this.uart.flush();
        while ((value = this.uart.read()) != -1) {
            this.outputBuffer.enqueue((byte)value);
        }
    }

    @Override
    protected void handleAfterRun() {
        super.handleAfterRun();
        ByteBuffer output = ByteBuffer.allocate(this.outputBuffer.size());
        while (!this.outputBuffer.isEmpty()) {
            output.put(this.outputBuffer.dequeueByte());
        }
        output.flip();
        this.putTerminalOutput(output);
    }

    private void putTerminalOutput(ByteBuffer output) {
        if (output.hasRemaining()) {
            this.terminal.putOutput(output);
            output.flip();
            this.sendTerminalUpdateToClient(output);
        }
    }
}

