/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@Serialized
public final class Terminal {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 24;
    public static final int CHAR_WIDTH = 8;
    public static final int CHAR_HEIGHT = 16;
    private static final int TAB_WIDTH = 4;
    private static final int COLOR_MASK = 7;
    private static final int COLOR_FOREGROUND_SHIFT = 3;
    private static final int STYLE_BOLD_MASK = 1;
    private static final int STYLE_DIM_MASK = 2;
    private static final int STYLE_UNDERLINE_MASK = 4;
    private static final int STYLE_BLINK_MASK = 8;
    private static final int STYLE_INVERT_MASK = 16;
    private static final int STYLE_HIDDEN_MASK = 32;
    private static final byte DEFAULT_COLORS = 56;
    private static final byte DEFAULT_STYLE = 0;
    private final ByteArrayFIFOQueue input = new ByteArrayFIFOQueue(32);
    private final byte[] buffer = new byte[1920];
    private final byte[] colors = new byte[1920];
    private final byte[] styles = new byte[1920];
    private final boolean[] tabs = new boolean[80];
    private State state = State.NORMAL;
    private final int[] args = new int[4];
    private int argCount = 0;
    private int modes;
    private int scrollFirst = 0;
    private int scrollLast = 23;
    private int x;
    private int y;
    private int savedX;
    private int savedY;
    private byte color;
    private byte style;
    private final transient Set<RendererModel> renderers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private transient boolean displayOnly;
    private transient boolean hasPendingBell;

    public Terminal() {
        this.RIS();
    }

    public int getWidth() {
        return 640;
    }

    public int getHeight() {
        return 384;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayOnly(boolean value) {
        this.displayOnly = value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RendererView getRenderer() {
        Renderer renderer = new Renderer(this);
        this.renderers.add(renderer);
        return renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseRenderer(RendererView renderer) {
        if (renderer instanceof RendererModel) {
            RendererModel rendererModel = (RendererModel)((Object)renderer);
            rendererModel.close();
            this.renderers.remove(rendererModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.hasPendingBell) {
            this.hasPendingBell = false;
            Minecraft client = Minecraft.m_91087_();
            client.execute(() -> client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)NoteBlockInstrument.PLING.m_263188_(), (float)1.0f)));
        }
    }

    public synchronized int readInput() {
        if (this.input.isEmpty()) {
            return -1;
        }
        return this.input.dequeueByte() & 0xFF;
    }

    @Nullable
    public synchronized ByteBuffer getInput() {
        if (this.input.isEmpty()) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.input.size());
        while (!this.input.isEmpty()) {
            buffer.put(this.input.dequeueByte());
        }
        buffer.flip();
        return buffer;
    }

    public synchronized void putInput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.input.enqueue(values.get());
        }
    }

    public synchronized void putOutput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.putOutput(values.get());
        }
    }

    public synchronized void putInput(byte value) {
        this.input.enqueue(value);
    }

    public void putOutput(byte value) {
        char ch = (char)value;
        block0 : switch (this.state) {
            case NORMAL: {
                switch (value) {
                    case 7: {
                        this.hasPendingBell = true;
                        break;
                    }
                    case 27: {
                        this.state = State.ESCAPE;
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 13: {
                        this.setCursorPos(0, this.y);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        if (this.getMode(20)) {
                            this.NEL();
                            break;
                        }
                        this.IND();
                        break;
                    }
                    case 9: {
                        if (this.x >= 80) break;
                        do {
                            ++this.x;
                        } while (this.x < 80 && !this.tabs[this.x]);
                        break;
                    }
                    case 8: {
                        this.setCursorPos(Math.min(this.x, 79) - 1, this.y);
                        break;
                    }
                    default: {
                        this.putChar(ch);
                        break;
                    }
                }
                break;
            }
            case ESCAPE: {
                if (ch == '[') {
                    Arrays.fill(this.args, 0);
                    this.argCount = 0;
                    this.state = State.CONTROL_SEQUENCE;
                    break;
                }
                if (ch == '(') {
                    this.state = State.SHIFT_IN_CHARACTER_SET;
                    break;
                }
                if (ch == ')') {
                    this.state = State.SHIFT_OUT_CHARACTER_SET;
                    break;
                }
                if (ch == '#') {
                    this.state = State.HASH;
                    break;
                }
                this.state = State.NORMAL;
                switch (ch) {
                    case 'D': {
                        this.IND();
                        break block0;
                    }
                    case 'E': {
                        this.NEL();
                        break block0;
                    }
                    case 'M': {
                        this.RI();
                        break block0;
                    }
                    case '7': {
                        this.DECSC();
                        break block0;
                    }
                    case '8': {
                        this.DECRC();
                        break block0;
                    }
                    case 'H': {
                        this.HTS();
                        break block0;
                    }
                    case 'c': {
                        this.RIS();
                        break block0;
                    }
                    case '=': {
                        break block0;
                    }
                }
                break;
            }
            case CONTROL_SEQUENCE: {
                if (ch >= '0' && ch <= '9') {
                    if (this.argCount >= this.args.length) break;
                    int digit = ch - 48;
                    if (this.args[this.argCount] < (Integer.MAX_VALUE - digit) / 10) {
                        this.args[this.argCount] = this.args[this.argCount] * 10 + digit;
                        break;
                    }
                    this.args[this.argCount] = Integer.MAX_VALUE;
                    break;
                }
                if (ch == '?') break;
                if (this.argCount < this.args.length) {
                    ++this.argCount;
                }
                if (ch == ';') break;
                this.state = State.NORMAL;
                switch (ch) {
                    case 'A': {
                        this.CUU();
                        break;
                    }
                    case 'B': {
                        this.CUD();
                        break;
                    }
                    case 'C': {
                        this.CUF();
                        break;
                    }
                    case 'D': {
                        this.CUB();
                        break;
                    }
                    case 'H': {
                        this.CUP();
                        break;
                    }
                    case 'f': {
                        this.HVP();
                        break;
                    }
                    case 'm': {
                        this.SGR();
                        break;
                    }
                    case 'K': {
                        this.EL();
                        break;
                    }
                    case 'J': {
                        this.ED();
                        break;
                    }
                    case 'r': {
                        this.DECSTBM();
                        break;
                    }
                    case 'g': {
                        this.TBC();
                        break;
                    }
                    case 'h': {
                        this.SM();
                        break;
                    }
                    case 'l': {
                        this.RM();
                        break;
                    }
                    case 'n': {
                        this.DSR();
                        break;
                    }
                    case 'c': {
                        this.DA();
                    }
                }
                break;
            }
            case SHIFT_IN_CHARACTER_SET: 
            case SHIFT_OUT_CHARACTER_SET: {
                this.state = State.NORMAL;
                switch (ch) {
                    case 'A': {
                        break block0;
                    }
                    case 'B': {
                        break block0;
                    }
                    case '0': {
                        break block0;
                    }
                    case '1': {
                        break block0;
                    }
                }
                break;
            }
            case HASH: {
                this.state = State.NORMAL;
                switch (ch) {
                    case '3': {
                        break block0;
                    }
                    case '4': {
                        break block0;
                    }
                    case '5': {
                        break block0;
                    }
                    case '6': {
                        break block0;
                    }
                    case '8': {
                        Arrays.fill(this.buffer, (byte)69);
                        this.renderers.forEach(model -> model.getDirtyMask().set(-1));
                    }
                }
            }
        }
    }

    private void IND() {
        if (this.y >= this.scrollLast) {
            this.shiftUpOne();
        } else {
            this.setCursorPos(this.x, this.y + 1);
        }
    }

    private void NEL() {
        if (this.y >= this.scrollLast) {
            this.shiftUpOne();
            this.setCursorPos(0, this.y);
        } else {
            this.setCursorPos(0, this.y + 1);
        }
    }

    private void RI() {
        if (this.y <= this.scrollFirst) {
            this.shiftDownOne();
        } else {
            this.setCursorPos(0, this.y - 1);
        }
    }

    private void DECSC() {
        this.savedX = this.x;
        this.savedY = this.y;
    }

    private void DECRC() {
        this.x = this.savedX;
        this.y = this.savedY;
    }

    private void HTS() {
        if (this.x >= 0 && this.x < 80) {
            this.tabs[this.x] = true;
        }
    }

    private void RIS() {
        this.color = (byte)56;
        this.style = 0;
        this.clear();
        Arrays.fill(this.tabs, false);
        for (int i = 1; i < 80; ++i) {
            if (i % 4 != 0) continue;
            this.tabs[i] = true;
        }
    }

    private void CUU() {
        this.setClampedCursorPos(this.x, this.y - Math.max(1, this.args[0]));
    }

    private void CUD() {
        this.setClampedCursorPos(this.x, this.y + Math.max(1, this.args[0]));
    }

    private void CUF() {
        this.setClampedCursorPos(this.x + Math.max(1, this.args[0]), this.y);
    }

    private void CUB() {
        this.setClampedCursorPos(this.x - Math.max(1, this.args[0]), this.y);
    }

    private void CUP() {
        this.setRelativeCursorPos(this.args[1] - 1, this.args[0] - 1);
    }

    private void HVP() {
        this.CUP();
    }

    private void SGR() {
        for (int i = 0; i < this.argCount; ++i) {
            this.selectStyle(this.args[i]);
        }
    }

    private void EL() {
        switch (this.args[0]) {
            case 0: {
                this.clearLine(this.y, this.x, 80);
                break;
            }
            case 1: {
                this.clearLine(this.y, 0, this.x + 1);
                break;
            }
            case 2: {
                this.clearLine(this.y);
            }
        }
    }

    private void ED() {
        switch (this.args[0]) {
            case 0: {
                this.clearLine(this.y, this.x, 80);
                for (int iy = this.y + 1; iy < 24; ++iy) {
                    this.clearLine(iy);
                }
                break;
            }
            case 1: {
                for (int iy = 0; iy < this.y; ++iy) {
                    this.clearLine(iy);
                }
                this.clearLine(this.y, 0, this.x + 1);
                break;
            }
            case 2: {
                this.clear();
            }
        }
    }

    private void DECSTBM() {
        int last;
        int first;
        if (this.argCount == 2) {
            first = this.args[0] - 1;
            last = this.args[1] - 1;
        } else {
            first = 0;
            last = 23;
        }
        if (first < 0 || last > 23 || last - first <= 0) {
            return;
        }
        this.scrollFirst = first;
        this.scrollLast = last;
        this.setRelativeCursorPos(0, 0);
    }

    private void TBC() {
        switch (this.args[0]) {
            case 0: {
                if (this.x < 0 || this.x >= 80) break;
                this.tabs[this.x] = false;
                break;
            }
            case 3: {
                Arrays.fill(this.tabs, false);
            }
        }
    }

    private void SM() {
        for (int i = 0; i < this.argCount; ++i) {
            int mode = this.args[i];
            if (mode != 0) {
                this.setMode(mode);
            }
            if (mode != 6) continue;
            this.setRelativeCursorPos(0, 0);
        }
    }

    private void RM() {
        for (int i = 0; i < this.argCount; ++i) {
            int mode = this.args[i];
            if (mode != 0) {
                this.resetMode(mode);
            }
            if (mode != 6) continue;
            this.setRelativeCursorPos(0, 0);
            this.clear();
        }
    }

    private void DSR() {
        switch (this.args[0]) {
            case 5: {
                this.putResponse("\u001b[0n");
                break;
            }
            case 6: {
                if (this.getMode(6)) {
                    this.putResponse(String.format("\u001b[%d;%dR", this.y - this.scrollFirst + 1, this.x + 1));
                    break;
                }
                this.putResponse(String.format("\u001b[%d;%dR", this.y % 24 + 1, this.x + 1));
            }
        }
    }

    private void DA() {
        this.putResponse("\u001b[?1;0c");
    }

    private void setMode(int mode) {
        this.modes |= 1 << mode;
    }

    private void resetMode(int mode) {
        this.modes &= ~(1 << mode);
    }

    private boolean getMode(int mode) {
        return (this.modes & 1 << mode) != 0;
    }

    private void putResponse(String value) {
        for (int i = 0; i < value.length(); ++i) {
            this.putResponse((byte)value.charAt(i));
        }
    }

    private void putResponse(byte value) {
        if (!this.displayOnly) {
            this.putInput(value);
        }
    }

    private void selectStyle(int sgr) {
        switch (sgr) {
            case 0: {
                this.color = (byte)56;
                this.style = 0;
                break;
            }
            case 1: {
                this.style = (byte)(this.style | 1);
                break;
            }
            case 2: {
                this.style = (byte)(this.style | 2);
                break;
            }
            case 4: {
                this.style = (byte)(this.style | 4);
                break;
            }
            case 5: {
                this.style = (byte)(this.style | 8);
                break;
            }
            case 7: {
                this.style = (byte)(this.style | 0x10);
                break;
            }
            case 8: {
                this.style = (byte)(this.style | 0x20);
                break;
            }
            case 22: {
                this.style = (byte)(this.style & 0xFFFFFFFC);
                break;
            }
            case 24: {
                this.style = (byte)(this.style & 0xFFFFFFFB);
                break;
            }
            case 25: {
                this.style = (byte)(this.style & 0xFFFFFFF7);
                break;
            }
            case 27: {
                this.style = (byte)(this.style & 0xFFFFFFEF);
                break;
            }
            case 28: {
                this.style = (byte)(this.style & 0xFFFFFFDF);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                int color = sgr - 30;
                this.color = (byte)(this.color & 0xFFFFFFC7 | color << 3);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                int color = sgr - 40;
                this.color = (byte)(this.color & 0xFFFFFFF8 | color);
            }
        }
    }

    private void setRelativeCursorPos(int x, int y) {
        if (this.getMode(6)) {
            this.setCursorPos(x, Math.min(this.scrollFirst + y, this.scrollLast));
        } else {
            this.setCursorPos(x, y);
        }
    }

    private void setClampedCursorPos(int x, int y) {
        this.setCursorPos(x, Math.max(this.scrollFirst, Math.min(this.scrollLast, y)));
    }

    private void setCursorPos(int x, int y) {
        this.x = Math.max(0, Math.min(79, x));
        this.y = Math.max(0, Math.min(23, y));
    }

    private void putChar(char ch) {
        if (Character.isISOControl(ch)) {
            return;
        }
        if (this.x >= 80) {
            if (this.getMode(7)) {
                this.NEL();
            } else {
                this.setCursorPos(79, this.y);
            }
        }
        this.setChar(this.x, this.y, ch);
        ++this.x;
    }

    private void setChar(int x, int y, char ch) {
        int index = x + y * 80;
        if (this.buffer[index] == ch && this.colors[index] == this.color && this.styles[index] == this.style) {
            return;
        }
        this.buffer[index] = (byte)ch;
        this.colors[index] = this.color;
        this.styles[index] = this.style;
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << y, (prev, next) -> prev | next));
    }

    private void clear() {
        Arrays.fill(this.buffer, (byte)32);
        Arrays.fill(this.colors, (byte)56);
        Arrays.fill(this.styles, (byte)0);
        this.setCursorPos(0, 0);
        this.renderers.forEach(model -> model.getDirtyMask().set(-1));
    }

    private void clearLine(int y) {
        this.clearLine(y, 0, 80);
    }

    private void clearLine(int y, int fromIndex, int toIndex) {
        Arrays.fill(this.buffer, y * 80 + fromIndex, y * 80 + toIndex, (byte)32);
        Arrays.fill(this.colors, y * 80 + fromIndex, y * 80 + toIndex, (byte)56);
        Arrays.fill(this.styles, y * 80 + fromIndex, y * 80 + toIndex, (byte)0);
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << y, (prev, next) -> prev | next));
    }

    private void shiftUpOne() {
        this.shiftLines(this.scrollFirst + 1, this.scrollLast, -1);
    }

    private void shiftDownOne() {
        this.shiftLines(this.scrollFirst, this.scrollLast - 1, 1);
    }

    private void shiftLines(int firstLine, int lastLine, int count) {
        if (count == 0) {
            return;
        }
        int srcIndex = firstLine * 80;
        int charCount = (lastLine + 1) * 80 - srcIndex;
        int dstIndex = srcIndex + count * 80;
        System.arraycopy(this.buffer, srcIndex, this.buffer, dstIndex, charCount);
        System.arraycopy(this.colors, srcIndex, this.colors, dstIndex, charCount);
        System.arraycopy(this.styles, srcIndex, this.styles, dstIndex, charCount);
        int clearIndex = count > 0 ? srcIndex : dstIndex + charCount;
        int clearCount = Math.abs(count * 80);
        Arrays.fill(this.buffer, clearIndex, clearIndex + clearCount, (byte)32);
        Arrays.fill(this.colors, clearIndex, clearIndex + clearCount, (byte)56);
        Arrays.fill(this.styles, clearIndex, clearIndex + clearCount, (byte)0);
        int dirtyLinesMask = 0;
        int dirtyStart = Math.min(firstLine, firstLine + count);
        int dirtyEnd = Math.max(lastLine, lastLine + count);
        for (int i = dirtyStart; i <= dirtyEnd; ++i) {
            dirtyLinesMask |= 1 << i;
        }
        int finalDirtyLinesMask = dirtyLinesMask;
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
    }

    private static final class Color {
        static final int BLACK = 0;
        static final int RED = 1;
        static final int GREEN = 2;
        static final int YELLOW = 3;
        static final int BLUE = 4;
        static final int MAGENTA = 5;
        static final int CYAN = 6;
        static final int WHITE = 7;

        private Color() {
        }
    }

    public static enum State {
        NORMAL,
        ESCAPE,
        SHIFT_IN_CHARACTER_SET,
        SHIFT_OUT_CHARACTER_SET,
        HASH,
        CONTROL_SEQUENCE;

    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Renderer
    implements RendererModel,
    RendererView {
        private static final ResourceLocation LOCATION_FONT_TEXTURE = new ResourceLocation("oc2r", "textures/font/terminus.png");
        private static final int TEXTURE_RESOLUTION = 256;
        private static final float ONE_OVER_TEXTURE_RESOLUTION = 0.00390625f;
        private static final int TEXTURE_COLUMNS = 16;
        private static final int TEXTURE_BOLD_SHIFT = 16;
        private static final int[] COLORS = new int[]{65793, 0xEE3322, 0x33DD44, 0xFFCC11, 0x1188EE, 0xDD33CC, 0x22CCDD, 0xEEEEEE};
        private static final int[] DIM_COLORS = new int[]{65793, 0x772211, 0x116622, 0x886611, 0x115588, 0x771177, 0x116677, 0x777777};
        private final Terminal terminal;
        private final VertexBuffer[] lines = new VertexBuffer[24];
        private final AtomicInteger dirty = new AtomicInteger(-1);

        public Renderer(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public void render(PoseStack stack, Matrix4f projectionMatrix) {
            this.validateLineCache();
            this.renderBuffer(stack, projectionMatrix);
            if ((System.currentTimeMillis() + (long)this.terminal.hashCode()) % 1000L > 500L) {
                this.renderCursor(stack);
            }
        }

        @Override
        public AtomicInteger getDirtyMask() {
            return this.dirty;
        }

        @Override
        public void close() {
            for (int i = 0; i < this.lines.length; ++i) {
                VertexBuffer line = this.lines[i];
                if (line == null) continue;
                line.close();
                this.lines[i] = null;
            }
        }

        private int findLineIndex(VertexBuffer[] vba, VertexBuffer vb) {
            for (int i = 0; i < vba.length; ++i) {
                if (vba[i] != vb) continue;
                return i;
            }
            return -1;
        }

        private void renderBuffer(PoseStack stack, Matrix4f projectionMatrix) {
            ShaderInstance shader = GameRenderer.m_172814_();
            if (shader == null) {
                return;
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION_FONT_TEXTURE);
            for (VertexBuffer line : this.lines) {
                if (line.m_231230_()) continue;
                try {
                    line.m_85921_();
                    line.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shader);
                    VertexBuffer.m_85931_();
                }
                catch (Exception e) {
                    System.out.println("ERROR: " + e.getMessage());
                    System.out.println(this.findLineIndex(this.lines, line));
                }
            }
            RenderSystem.depthMask((boolean)true);
        }

        private void validateLineCache() {
            if (this.dirty.get() == 0) {
                return;
            }
            int mask = this.dirty.getAndSet(0);
            for (int row = 0; row < this.lines.length; ++row) {
                if ((mask & 1 << row) == 0) continue;
                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                Matrix4f matrix = new Matrix4f().translate(0.0f, (float)(row * 16), 0.0f);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
                this.renderBackground(matrix, builder, row);
                this.renderForeground(matrix, builder, row);
                BufferBuilder.RenderedBuffer rb = builder.m_231175_();
                if (this.lines[row] == null) {
                    this.lines[row] = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                } else if (this.lines[row] != null) {
                    this.lines[row].close();
                    this.lines[row] = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                }
                if (this.lines[row].m_231230_()) continue;
                this.lines[row].m_85921_();
                this.lines[row].m_231221_(rb);
                VertexBuffer.m_85931_();
            }
        }

        private void renderBackground(Matrix4f matrix, BufferBuilder buffer, int row) {
            float backgroundStartX = -1.0f;
            int backgroundColor = 0;
            float tx = 0.0f;
            int col = 0;
            int index = row * 80;
            while (col < 80) {
                byte colors = this.terminal.colors[index];
                byte style = this.terminal.styles[index];
                if ((style & 0x20) == 0) {
                    boolean hasBackground;
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int foregroundIndex = colors >> 3 & 7;
                    int backgroundIndex = colors & 7;
                    int background = palette[(style & 0x10) == 0 ? backgroundIndex : foregroundIndex];
                    boolean hadBackground = backgroundStartX >= 0.0f;
                    boolean bl = hasBackground = background != palette[0];
                    if (!hadBackground && hasBackground) {
                        backgroundStartX = tx;
                        backgroundColor = background;
                    } else if (hadBackground && (!hasBackground || backgroundColor != background)) {
                        this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
                        if (hasBackground) {
                            backgroundStartX = tx;
                            backgroundColor = background;
                        } else {
                            backgroundStartX = -1.0f;
                        }
                    }
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
            if (backgroundStartX >= 0.0f) {
                this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
            }
        }

        private void renderBackground(Matrix4f matrix, BufferBuilder buffer, float x0, float x1, int color) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float ulu = 0.99609375f;
            float ulv = 0.00390625f;
            buffer.m_252986_(matrix, x0, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
            buffer.m_252986_(matrix, x1, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
            buffer.m_252986_(matrix, x1, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
            buffer.m_252986_(matrix, x0, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
        }

        private void renderForeground(Matrix4f matrix, BufferBuilder buffer, int row) {
            float tx = 0.0f;
            int col = 0;
            int index = row * 80;
            while (col < 80) {
                byte colors = this.terminal.colors[index];
                byte style = this.terminal.styles[index];
                if ((style & 0x20) == 0) {
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int foregroundIndex = colors >> 3 & 7;
                    int backgroundIndex = colors & 7;
                    int foreground = palette[(style & 0x10) == 0 ? foregroundIndex : backgroundIndex];
                    int character = this.terminal.buffer[index] & 0xFF;
                    this.renderForeground(matrix, buffer, tx, character, foreground, style);
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
        }

        private void renderForeground(Matrix4f matrix, BufferBuilder buffer, float offset, int character, int color, byte style) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (Renderer.isPrintableCharacter((char)character)) {
                int x = character % 16 + ((style & 1) != 0 ? 16 : 0);
                int y = character / 16;
                float u0 = (float)x * 0.03125f;
                float u1 = (float)(x + 1) * 0.03125f;
                float v0 = (float)y * 0.0625f;
                float v1 = (float)(y + 1) * 0.0625f;
                buffer.m_252986_(matrix, offset, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_5752_();
                buffer.m_252986_(matrix, offset, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_5752_();
            }
            if ((style & 4) != 0) {
                float ulu = 0.99609375f;
                float ulv = 0.00390625f;
                buffer.m_252986_(matrix, offset, 13.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 13.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 14.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
                buffer.m_252986_(matrix, offset, 14.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.99609375f, 0.00390625f).m_5752_();
            }
        }

        private void renderCursor(PoseStack stack) {
            BufferUploader.m_166835_();
            if (this.terminal.x < 0 || this.terminal.x >= 80 || this.terminal.y < 0 || this.terminal.y >= 24) {
                return;
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172811_);
            stack.m_85836_();
            stack.m_252880_((float)(this.terminal.x * 8), (float)(this.terminal.y * 16), 0.0f);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int foreground = COLORS[7];
            float r = (float)(foreground >> 16 & 0xFF) / 255.0f;
            float g = (float)(foreground >> 8 & 0xFF) / 255.0f;
            float b = (float)(foreground & 0xFF) / 255.0f;
            buffer.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buffer.m_252986_(matrix, 8.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buffer.m_252986_(matrix, 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            BufferBuilder.RenderedBuffer rb = buffer.m_231175_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)rb);
            stack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }

        private static boolean isPrintableCharacter(char ch) {
            return ch == '\u0000' || ch > ' ' && ch <= '~' || ch >= '\u00b1';
        }
    }

    private static interface RendererModel {
        public AtomicInteger getDirtyMask();

        public void close();
    }

    private static final class Mode {
        static final int LNM = 20;
        static final int DECCKM = 1;
        static final int DECANM = 2;
        static final int DECCOLM = 3;
        static final int DECSCLM = 4;
        static final int DECSCNM = 5;
        static final int DECOM = 6;
        static final int DECAWM = 7;
        static final int DECARM = 8;
        static final int DECINLM = 9;

        private Mode() {
        }
    }

    public static interface RendererView {
        public void render(PoseStack var1, Matrix4f var2);
    }
}

