/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.context.global;

import li.cil.oc2r.common.vm.context.InterruptValidator;
import li.cil.sedna.api.device.InterruptController;

final class GlobalInterruptController
implements InterruptController {
    private final InterruptController parent;
    private final InterruptValidator validator;
    private int raisedInterruptMask;

    public GlobalInterruptController(InterruptController parent, InterruptValidator validator) {
        this.parent = parent;
        this.validator = validator;
        this.raisedInterruptMask = validator.getMaskedInterrupts(parent.getRaisedInterrupts());
    }

    public void invalidate() {
        this.parent.lowerInterrupts(this.raisedInterruptMask);
        this.raisedInterruptMask = 0;
    }

    public Object getIdentity() {
        return this.parent.getIdentity();
    }

    public void raiseInterrupts(int mask) {
        if (this.validator.isMaskValid(mask)) {
            this.parent.raiseInterrupts(mask);
            this.raisedInterruptMask |= mask;
        } else {
            throw new IllegalArgumentException("Trying to raise interrupt not allocated by this context.");
        }
    }

    public void lowerInterrupts(int mask) {
        if (this.validator.isMaskValid(mask)) {
            this.parent.lowerInterrupts(mask);
            this.raisedInterruptMask &= ~mask;
        } else {
            throw new IllegalArgumentException("Trying to lower interrupt not allocated by this context.");
        }
    }

    public int getRaisedInterrupts() {
        return this.raisedInterruptMask;
    }
}

