/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.context.global;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import li.cil.oc2r.api.bus.device.vm.context.MemoryRangeAllocator;
import li.cil.oc2r.common.vm.context.MemoryRangeManager;
import li.cil.sedna.api.Board;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.api.memory.MemoryRange;
import li.cil.sedna.api.memory.MemoryRangeAllocationStrategy;

final class GlobalMemoryRangeAllocator
implements MemoryRangeAllocator,
MemoryRangeManager {
    private final Board board;
    private final ArrayList<MemoryRange> reservedMemoryRanges;
    private final Object2LongArrayMap<MemoryMappedDevice> claimedMemoryRanges = new Object2LongArrayMap();

    public GlobalMemoryRangeAllocator(Board board, ArrayList<MemoryRange> reservedMemoryRanges) {
        this.board = board;
        this.reservedMemoryRanges = reservedMemoryRanges;
    }

    public Collection<MemoryRange> getClaimedMemoryRanges() {
        ArrayList<MemoryRange> result = new ArrayList<MemoryRange>();
        for (Object2LongMap.Entry entry : this.claimedMemoryRanges.object2LongEntrySet()) {
            MemoryMappedDevice device = (MemoryMappedDevice)entry.getKey();
            long address = entry.getLongValue();
            result.add(MemoryRange.at((long)address, (int)device.getLength()));
        }
        return result;
    }

    public void invalidate() {
        for (MemoryMappedDevice device : this.claimedMemoryRanges.keySet()) {
            this.board.removeDevice(device);
        }
        this.claimedMemoryRanges.clear();
    }

    @Override
    public boolean claimMemoryRange(long address, MemoryMappedDevice device) {
        if (this.board.addDevice(address, device)) {
            this.claimedMemoryRanges.put((Object)device, address);
            return true;
        }
        return false;
    }

    @Override
    public OptionalLong claimMemoryRange(MemoryMappedDevice device) {
        OptionalLong address = this.board.addDevice(device);
        if (address.isPresent()) {
            this.claimedMemoryRanges.put((Object)device, address.getAsLong());
            return address;
        }
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong findMemoryRange(MemoryMappedDevice device, long start) {
        return this.board.getAllocationStrategy().findMemoryRange(device, range -> {
            for (MemoryRange reservedRange : this.reservedMemoryRanges) {
                if (!reservedRange.intersects(range)) continue;
                return Optional.of(reservedRange);
            }
            return (Optional)MemoryRangeAllocationStrategy.getMemoryMapIntersectionProvider((MemoryMap)this.board.getMemoryMap()).apply(range);
        }, start);
    }

    @Override
    public void releaseMemoryRange(MemoryMappedDevice device) {
        this.board.removeDevice(device);
        this.claimedMemoryRanges.removeLong((Object)device);
    }
}

