/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.context.managed;

import java.util.ArrayList;
import li.cil.oc2r.api.bus.device.vm.context.VMLifecycleEventBus;
import li.cil.oc2r.common.vm.context.EventManager;

final class ManagedEventBus
implements VMLifecycleEventBus {
    private final VMLifecycleEventBus parent;
    private final EventManager manager;
    private final ArrayList<Object> subscribers = new ArrayList();
    private boolean isFrozen;

    public ManagedEventBus(VMLifecycleEventBus parent, EventManager manager) {
        this.parent = parent;
        this.manager = manager;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void invalidate() {
        for (Object subscriber : this.subscribers) {
            this.manager.unregister(subscriber);
        }
        this.subscribers.clear();
    }

    @Override
    public void register(Object subscriber) {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        this.parent.register(subscriber);
        this.subscribers.add(subscriber);
    }
}

