/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.device;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.utils.DirectByteBufferUtils;

public final class PciRootPortDevice
implements MemoryMappedDevice {
    private final ByteBuffer buffer;
    private int length;

    public PciRootPortDevice(int bus_count, int window_size, ByteBuffer buffer) {
        this.length = window_size * 2;
        if (buffer.capacity() < this.length) {
            throw new IllegalArgumentException("Buffer too small.");
        }
        this.buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(0, 305419896);
        this.buffer.putInt(4, 2);
        this.buffer.putInt(8, -16777216);
        this.buffer.putInt(12, 257);
        this.buffer.putInt(16, 0);
        this.buffer.putInt(44, 305419896);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.length = 0;
            DirectByteBufferUtils.release((ByteBuffer)this.buffer);
        }
    }

    public int getLength() {
        return this.length;
    }

    public long load(int offset, int sizeLog2) throws MemoryAccessException {
        if (offset >= 0 && offset <= this.length - (1 << sizeLog2)) {
            System.out.printf("PCI config read: %x %x%n", offset, sizeLog2);
            if (offset == 16) {
                long res = this.buffer.getInt(offset);
                System.out.printf("        00:00.0 BAR0 read    %x%n", res);
                System.out.printf("Clipped 00:00.0 BAR0 read to %x%n", res &= 0xFFFFF000L);
                return res;
            }
            return switch (sizeLog2) {
                case 0 -> this.buffer.get(offset);
                case 1 -> this.buffer.getShort(offset);
                case 2 -> this.buffer.getInt(offset);
                case 3 -> this.buffer.getLong(offset);
                default -> throw new IllegalArgumentException();
            };
        }
        return 0L;
    }

    public void store(int offset, long value, int sizeLog2) throws MemoryAccessException {
        if (offset >= 0 && offset <= this.length - (1 << sizeLog2)) {
            System.out.printf("PCI config write: %x %x %x%n", offset, value, sizeLog2);
            switch (sizeLog2) {
                case 0: {
                    this.buffer.put(offset, (byte)value);
                    break;
                }
                case 1: {
                    this.buffer.putShort(offset, (short)value);
                    break;
                }
                case 2: {
                    this.buffer.putInt(offset, (int)value);
                    break;
                }
                case 3: {
                    this.buffer.putLong(offset, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

