/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.device;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import li.cil.oc2r.jcodec.common.model.Picture;
import li.cil.oc2r.jcodec.scale.RgbToYuv420j;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.utils.DirectByteBufferUtils;

public final class SimpleFramebufferDevice
implements MemoryMappedDevice {
    public static final int STRIDE = 2;
    private final int width;
    private final int height;
    private final ByteBuffer buffer;
    private int length;
    private final BitSet dirtyLines;

    public SimpleFramebufferDevice(int width, int height, ByteBuffer buffer) {
        this.width = width;
        this.height = height;
        this.length = width * height * 2;
        if (buffer.capacity() < this.length) {
            throw new IllegalArgumentException("Buffer too small.");
        }
        this.buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.dirtyLines = new BitSet(height / 2);
        this.dirtyLines.set(0, height / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.length = 0;
            this.dirtyLines.clear();
            DirectByteBufferUtils.release((ByteBuffer)this.buffer);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasChanges() {
        return !this.dirtyLines.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyChanges(Picture picture) {
        if (this.dirtyLines.isEmpty()) {
            return false;
        }
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            SimpleFramebufferDevice.convertR5G6B5ToYUV420J(this.buffer, this.width, this.height, picture);
        }
        return true;
    }

    public static void convertR5G6B5ToYUV420J(ByteBuffer rgbBuffer, int width, int height, Picture yuvPicture) {
        byte[][] yuvData = yuvPicture.getData();
        byte[] yPlane = yuvData[0];
        byte[] uPlane = yuvData[1];
        byte[] vPlane = yuvData[2];
        int uvWidth = width / 2;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int index = j * width + i;
                short pixel = rgbBuffer.getShort(index * 2);
                int r5 = pixel >>> 11 & 0x1F;
                int g6 = pixel >>> 5 & 0x3F;
                int b5 = pixel & 0x1F;
                byte r = (byte)(r5 * 255 / 31 - 128);
                byte g = (byte)(g6 * 255 / 63 - 128);
                byte b = (byte)(b5 * 255 / 31 - 128);
                int[] yuv = new int[3];
                RgbToYuv420j.rgb2yuv(r, g, b, yuv);
                yPlane[index] = (byte)yuv[0];
                if (j % 2 != 0 || i % 2 != 0) continue;
                int uvIndex = j / 2 * uvWidth + i / 2;
                uPlane[uvIndex] = (byte)yuv[1];
                vPlane[uvIndex] = (byte)yuv[2];
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public long load(int offset, int sizeLog2) throws MemoryAccessException {
        if (offset >= 0 && offset <= this.length - (1 << sizeLog2)) {
            return switch (sizeLog2) {
                case 0 -> this.buffer.get(offset);
                case 1 -> this.buffer.getShort(offset);
                case 2 -> this.buffer.getInt(offset);
                case 3 -> this.buffer.getLong(offset);
                default -> throw new IllegalArgumentException();
            };
        }
        return 0L;
    }

    public void store(int offset, long value, int sizeLog2) throws MemoryAccessException {
        if (offset >= 0 && offset <= this.length - (1 << sizeLog2)) {
            switch (sizeLog2) {
                case 0: {
                    this.buffer.put(offset, (byte)value);
                    break;
                }
                case 1: {
                    this.buffer.putShort(offset, (short)value);
                    break;
                }
                case 2: {
                    this.buffer.putInt(offset, (int)value);
                    break;
                }
                case 3: {
                    this.buffer.putLong(offset, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.setDirty(offset);
        }
    }

    private void setDirty(int offset) {
        int pixelY = offset / (this.width * 2);
        this.dirtyLines.set(pixelY / 2);
    }
}

