/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.vm.provider;

import java.util.Optional;
import li.cil.oc2r.common.vm.device.PciRootPortDevice;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MemoryMap;

public final class PciRootPortDeviceProvider
implements DeviceTreeProvider {
    public Optional<String> getName(Device device) {
        return Optional.of("pci");
    }

    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> {
            DeviceTree pci = root.find("/pci");
            return pci.getChild(deviceName, r.address());
        });
    }

    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        PciRootPortDevice pr = (PciRootPortDevice)device;
        Optional range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        node.addProp("compatible", new Object[]{"pci-host-cam-generic"}).addProp("device_type", new Object[]{"pci"}).addProp("#address-cells", new Object[]{3}).addProp("#size-cells", new Object[]{2}).addProp("bus-range", new Object[]{0, 1}).addProp("ranges", new Object[]{0x2000000, 0, 0x40000000, 0, 0x40000000, 0, 0x20000000});
    }
}

