/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.decode;

import li.cil.oc2r.jcodec.codecs.h264.H264Utils;
import li.cil.oc2r.jcodec.common.io.BitReader;

public final class CAVLCReader {
    private CAVLCReader() {
    }

    public static int readNBit(BitReader bits, int n) {
        return bits.readNBit(n);
    }

    public static int readUE(BitReader bits) {
        int cnt;
        for (cnt = 0; bits.read1Bit() == 0 && cnt < 32; ++cnt) {
        }
        int res = 0;
        if (cnt > 0) {
            long val = bits.readNBit(cnt);
            res = (int)((long)((1 << cnt) - 1) + val);
        }
        return res;
    }

    public static int readSE(BitReader bits) {
        int val = CAVLCReader.readUE(bits);
        val = H264Utils.golomb2Signed(val);
        return val;
    }

    public static boolean readBool(BitReader bits) {
        return bits.read1Bit() != 0;
    }

    public static int readU(BitReader bits, int i) {
        return CAVLCReader.readNBit(bits, i);
    }

    public static int readTE(BitReader bits, int max) {
        if (max > 1) {
            return CAVLCReader.readUE(bits);
        }
        return ~bits.read1Bit() & 1;
    }

    public static int readZeroBitCount(BitReader bits) {
        int count;
        for (count = 0; bits.read1Bit() == 0 && count < 32; ++count) {
        }
        return count;
    }

    public static boolean moreRBSPData(BitReader bits) {
        return bits.remaining() >= 32 || bits.checkNBit(1) != 1 || bits.checkNBit(24) << 9 != 0;
    }
}

