/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.decode;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc2r.jcodec.codecs.common.biari.MDecoder;
import li.cil.oc2r.jcodec.codecs.h264.H264Utils;
import li.cil.oc2r.jcodec.codecs.h264.decode.SliceHeaderReader;
import li.cil.oc2r.jcodec.codecs.h264.decode.SliceReader;
import li.cil.oc2r.jcodec.codecs.h264.decode.aso.MapManager;
import li.cil.oc2r.jcodec.codecs.h264.decode.aso.Mapper;
import li.cil.oc2r.jcodec.codecs.h264.io.CABAC;
import li.cil.oc2r.jcodec.codecs.h264.io.CAVLC;
import li.cil.oc2r.jcodec.codecs.h264.io.model.NALUnit;
import li.cil.oc2r.jcodec.codecs.h264.io.model.NALUnitType;
import li.cil.oc2r.jcodec.codecs.h264.io.model.PictureParameterSet;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2r.jcodec.common.IntObjectMap;
import li.cil.oc2r.jcodec.common.io.BitReader;

public final class FrameReader {
    private final IntObjectMap<SeqParameterSet> sps = new IntObjectMap();
    private final IntObjectMap<PictureParameterSet> pps = new IntObjectMap();

    public List<SliceReader> readFrame(List<ByteBuffer> nalUnits) {
        ArrayList<SliceReader> result = new ArrayList<SliceReader>();
        for (ByteBuffer nalData : nalUnits) {
            NALUnit nalUnit = NALUnit.read(nalData);
            H264Utils.unescapeNAL(nalData);
            if (NALUnitType.SPS == nalUnit.type) {
                SeqParameterSet _sps = SeqParameterSet.read(nalData);
                this.sps.put(_sps.seqParameterSetId, _sps);
                continue;
            }
            if (NALUnitType.PPS == nalUnit.type) {
                PictureParameterSet _pps = PictureParameterSet.read(nalData);
                this.pps.put(_pps.picParameterSetId, _pps);
                continue;
            }
            if (NALUnitType.IDR_SLICE != nalUnit.type && NALUnitType.NON_IDR_SLICE != nalUnit.type) continue;
            if (this.sps.size() == 0 || this.pps.size() == 0) {
                return null;
            }
            result.add(this.createSliceReader(nalData, nalUnit));
        }
        return result;
    }

    private SliceReader createSliceReader(ByteBuffer segment, NALUnit nalUnit) {
        BitReader _in = BitReader.createBitReader(segment);
        SliceHeader sh = SliceHeaderReader.readPart1(_in);
        sh.pps = this.pps.get(sh.picParameterSetId);
        sh.sps = this.sps.get(sh.pps.seqParameterSetId);
        SliceHeaderReader.readPart2(sh, nalUnit, sh.sps, sh.pps, _in);
        Mapper mapper = new MapManager(sh.sps, sh.pps).getMapper(sh);
        CAVLC[] cavlc = new CAVLC[]{new CAVLC(sh.sps, 2, 2), new CAVLC(sh.sps, 1, 1), new CAVLC(sh.sps, 1, 1)};
        int mbWidth = sh.sps.picWidthInMbsMinus1 + 1;
        CABAC cabac = new CABAC(mbWidth);
        MDecoder mDecoder = null;
        if (sh.pps.entropyCodingModeFlag) {
            _in.terminate();
            int[][] cm = new int[2][1024];
            int qp = sh.pps.picInitQpMinus26 + 26 + sh.sliceQpDelta;
            cabac.initModels(cm, sh.sliceType, sh.cabacInitIdc, qp);
            mDecoder = new MDecoder(segment, cm);
        }
        return new SliceReader(sh.pps, cabac, cavlc, mDecoder, _in, mapper, sh, nalUnit);
    }
}

