/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.decode;

import li.cil.oc2r.jcodec.codecs.h264.H264Const;
import li.cil.oc2r.jcodec.common.ArrayUtil;
import li.cil.oc2r.jcodec.common.tools.MathUtil;

public final class Intra16x16PredictionBuilder {
    public static void predictWithMode(int predMode, int[][] residual, boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, byte[] topLeft, int x, byte[] pixOut) {
        switch (predMode) {
            case 0: {
                Intra16x16PredictionBuilder.predictVertical(residual, topLine, x, pixOut);
                break;
            }
            case 1: {
                Intra16x16PredictionBuilder.predictHorizontal(residual, leftRow, pixOut);
                break;
            }
            case 2: {
                Intra16x16PredictionBuilder.predictDC(residual, leftAvailable, topAvailable, leftRow, topLine, x, pixOut);
                break;
            }
            case 3: {
                Intra16x16PredictionBuilder.predictPlane(residual, leftRow, topLine, topLeft, x, pixOut);
            }
        }
    }

    public static void lumaPred(int predMode, boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, byte topLeft, int x, byte[][] pred) {
        switch (predMode) {
            case 0: {
                Intra16x16PredictionBuilder.lumaVerticalPred(topLine, x, pred);
                break;
            }
            case 1: {
                Intra16x16PredictionBuilder.lumaHorizontalPred(leftRow, pred);
                break;
            }
            case 2: {
                Intra16x16PredictionBuilder.lumaDCPred(leftAvailable, topAvailable, leftRow, topLine, x, pred);
                break;
            }
            case 3: {
                Intra16x16PredictionBuilder.lumaPlanePred(leftRow, topLine, topLeft, x, pred);
            }
        }
    }

    public static int lumaPredSAD(int predMode, boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, byte topLeft, int x, byte[] pred) {
        return switch (predMode) {
            case 0 -> Intra16x16PredictionBuilder.lumaVerticalPredSAD(topAvailable, topLine, x, pred);
            case 1 -> Intra16x16PredictionBuilder.lumaHorizontalPredSAD(leftAvailable, leftRow, pred);
            default -> Intra16x16PredictionBuilder.lumaDCPredSAD(leftAvailable, topAvailable, leftRow, topLine, x, pred);
            case 3 -> Intra16x16PredictionBuilder.lumaPlanePredSAD(leftAvailable, topAvailable, leftRow, topLine, topLeft, x, pred);
        };
    }

    public static void predictVertical(int[][] residual, byte[] topLine, int x, byte[] pixOut) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                pixOut[off] = (byte)MathUtil.clip(residual[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] + topLine[x + i], -128, 127);
                ++i;
                ++off;
            }
        }
    }

    public static void lumaVerticalPred(byte[] topLine, int x, byte[][] pred) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                pred[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] = topLine[x + i];
                ++i;
                ++off;
            }
        }
    }

    public static int lumaVerticalPredSAD(boolean topAvailable, byte[] topLine, int x, byte[] pred) {
        if (!topAvailable) {
            return Integer.MAX_VALUE;
        }
        int sad = 0;
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                sad += MathUtil.abs(pred[(j << 4) + i] - topLine[x + i]);
            }
        }
        return sad;
    }

    public static void predictHorizontal(int[][] residual, byte[] leftRow, byte[] pixOut) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                pixOut[off] = (byte)MathUtil.clip(residual[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] + leftRow[j], -128, 127);
                ++i;
                ++off;
            }
        }
    }

    public static void lumaHorizontalPred(byte[] leftRow, byte[][] pred) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                pred[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] = leftRow[j];
                ++i;
                ++off;
            }
        }
    }

    public static int lumaHorizontalPredSAD(boolean leftAvailable, byte[] leftRow, byte[] pred) {
        if (!leftAvailable) {
            return Integer.MAX_VALUE;
        }
        int sad = 0;
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                sad += MathUtil.abs(pred[(j << 4) + i] - leftRow[j]);
            }
        }
        return sad;
    }

    public static void predictDC(int[][] residual, boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, int x, byte[] pixOut) {
        int s0 = Intra16x16PredictionBuilder.getDC(leftAvailable, topAvailable, leftRow, topLine, x);
        for (int i = 0; i < 256; ++i) {
            pixOut[i] = (byte)MathUtil.clip(residual[H264Const.LUMA_4x4_BLOCK_LUT[i]][H264Const.LUMA_4x4_POS_LUT[i]] + s0, -128, 127);
        }
    }

    public static void lumaDCPred(boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, int x, byte[][] pred) {
        int s0 = Intra16x16PredictionBuilder.getDC(leftAvailable, topAvailable, leftRow, topLine, x);
        for (int i = 0; i < pred.length; ++i) {
            int j = 0;
            while (j < pred[i].length) {
                byte[] byArray = pred[i];
                int n = j++;
                byArray[n] = (byte)(byArray[n] + s0);
            }
        }
    }

    public static int lumaDCPredSAD(boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, int x, byte[] pred) {
        int s0 = Intra16x16PredictionBuilder.getDC(leftAvailable, topAvailable, leftRow, topLine, x);
        int sad = 0;
        for (byte b : pred) {
            sad += MathUtil.abs(b - s0);
        }
        return sad;
    }

    private static int getDC(boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, int x) {
        int s0 = leftAvailable && topAvailable ? ArrayUtil.sumByte(leftRow) + ArrayUtil.sumByte(topLine, x, 16) + 16 >> 5 : (leftAvailable ? ArrayUtil.sumByte(leftRow) + 8 >> 4 : (topAvailable ? ArrayUtil.sumByte(topLine, x, 16) + 8 >> 4 : 0));
        return s0;
    }

    public static void predictPlane(int[][] residual, byte[] leftRow, byte[] topLine, byte[] topLeft, int x, byte[] pixOut) {
        int H = 0;
        for (int i = 0; i < 7; ++i) {
            H += (i + 1) * (topLine[x + 8 + i] - topLine[x + 6 - i]);
        }
        H += 8 * (topLine[x + 15] - topLeft[0]);
        int V = 0;
        for (int j = 0; j < 7; ++j) {
            V += (j + 1) * (leftRow[8 + j] - leftRow[6 - j]);
        }
        int c = 5 * (V += 8 * (leftRow[15] - topLeft[0])) + 32 >> 6;
        int b = 5 * H + 32 >> 6;
        int a = 16 * (leftRow[15] + topLine[x + 15]);
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                int val = MathUtil.clip(a + b * (i - 7) + c * (j - 7) + 16 >> 5, -128, 127);
                pixOut[off] = (byte)MathUtil.clip(residual[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] + val, -128, 127);
                ++i;
                ++off;
            }
        }
    }

    public static void lumaPlanePred(byte[] leftRow, byte[] topLine, byte topLeft, int x, byte[][] pred) {
        int H = 0;
        for (int i = 0; i < 7; ++i) {
            H += (i + 1) * (topLine[x + 8 + i] - topLine[x + 6 - i]);
        }
        H += 8 * (topLine[x + 15] - topLeft);
        int V = 0;
        for (int j = 0; j < 7; ++j) {
            V += (j + 1) * (leftRow[8 + j] - leftRow[6 - j]);
        }
        int c = 5 * (V += 8 * (leftRow[15] - topLeft)) + 32 >> 6;
        int b = 5 * H + 32 >> 6;
        int a = 16 * (leftRow[15] + topLine[x + 15]);
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                int val = MathUtil.clip(a + b * (i - 7) + c * (j - 7) + 16 >> 5, -128, 127);
                pred[H264Const.LUMA_4x4_BLOCK_LUT[off]][H264Const.LUMA_4x4_POS_LUT[off]] = (byte)val;
                ++i;
                ++off;
            }
        }
    }

    public static int lumaPlanePredSAD(boolean leftAvailable, boolean topAvailable, byte[] leftRow, byte[] topLine, byte topLeft, int x, byte[] pred) {
        if (!leftAvailable || !topAvailable) {
            return Integer.MAX_VALUE;
        }
        int H = 0;
        for (int i = 0; i < 7; ++i) {
            H += (i + 1) * (topLine[x + 8 + i] - topLine[x + 6 - i]);
        }
        H += 8 * (topLine[x + 15] - topLeft);
        int V = 0;
        for (int j = 0; j < 7; ++j) {
            V += (j + 1) * (leftRow[8 + j] - leftRow[6 - j]);
        }
        int c = 5 * (V += 8 * (leftRow[15] - topLeft)) + 32 >> 6;
        int b = 5 * H + 32 >> 6;
        int a = 16 * (leftRow[15] + topLine[x + 15]);
        int sad = 0;
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                int val = MathUtil.clip(a + b * (i - 7) + c * (j - 7) + 16 >> 5, -128, 127);
                sad += MathUtil.abs(pred[off] - val);
                ++i;
                ++off;
            }
        }
        return sad;
    }
}

