/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.encode;

import li.cil.oc2r.jcodec.codecs.h264.encode.MBEncoderHelper;
import li.cil.oc2r.jcodec.codecs.h264.encode.RateControl;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SliceType;
import li.cil.oc2r.jcodec.common.model.Picture;
import li.cil.oc2r.jcodec.common.model.Size;
import li.cil.oc2r.jcodec.common.tools.MathUtil;

public final class CQPRateControl
implements RateControl {
    private static final int MINQP = 12;
    private final int initialQp;
    private int oldQp;
    private SliceType sliceType;

    public CQPRateControl(int qp) {
        this.initialQp = qp;
    }

    @Override
    public int startPicture(Size sz, int maxSize, SliceType sliceType) {
        this.oldQp = this.initialQp;
        this.sliceType = sliceType;
        return this.initialQp;
    }

    @Override
    public int accept(int bits) {
        return 0;
    }

    @Override
    public int initialQpDelta(Picture pic, int mbX, int mbY) {
        if (this.initialQp <= 12) {
            return 0;
        }
        byte[] patch = new byte[256];
        MBEncoderHelper.take(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), mbX << 4, mbY << 4, patch, 16, 16);
        int avg = this.calcAvg(patch);
        double var = this.calcVar(patch, avg);
        double bright = this.calcBright(avg);
        int newQp = this.initialQp;
        int range = (this.initialQp - 12) / 2;
        double delta = var * 0.1 * Math.max(0.0, bright - 2.0);
        var += delta;
        if (var < 4.0) {
            newQp = this.sliceType == SliceType.I ? Math.max(this.initialQp / 2, 12) : Math.max(2 * this.initialQp / 3, 18);
        } else if (var < 8.0) {
            newQp = this.initialQp - range / 2;
        } else if (var < 16.0) {
            newQp = this.initialQp - range / 4;
        } else if (var < 32.0) {
            newQp = this.initialQp - range / 8;
        } else if (var < 64.0) {
            newQp = this.initialQp - range / 16;
        }
        int qpDelta = newQp - this.oldQp;
        this.oldQp = newQp;
        return qpDelta;
    }

    private int calcAvg(byte[] patch) {
        int sum = 0;
        for (int i = 0; i < 256; ++i) {
            sum += patch[i];
        }
        return sum >> 8;
    }

    private double calcVar(byte[] patch, int avg) {
        long sum1 = 0L;
        for (int i = 0; i < 256; ++i) {
            int diff = patch[i] - avg;
            sum1 += (long)(diff * diff);
        }
        return Math.sqrt(sum1 >> 8);
    }

    private double calcBright(int avg) {
        return MathUtil.log2(avg + 128);
    }
}

