/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.encode;

import java.util.Arrays;
import li.cil.oc2r.jcodec.codecs.h264.H264Const;
import li.cil.oc2r.jcodec.codecs.h264.H264Encoder;
import li.cil.oc2r.jcodec.codecs.h264.decode.BlockInterpolator;
import li.cil.oc2r.jcodec.codecs.h264.decode.CoeffTransformer;
import li.cil.oc2r.jcodec.codecs.h264.encode.EncodedMB;
import li.cil.oc2r.jcodec.codecs.h264.encode.EncodingContext;
import li.cil.oc2r.jcodec.codecs.h264.encode.H264EncoderUtils;
import li.cil.oc2r.jcodec.codecs.h264.encode.MBEncoderHelper;
import li.cil.oc2r.jcodec.codecs.h264.encode.MBWriterI16x16;
import li.cil.oc2r.jcodec.codecs.h264.io.model.MBType;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2r.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2r.jcodec.common.io.BitWriter;
import li.cil.oc2r.jcodec.common.model.Picture;

public final class MBWriterP16x16 {
    private final SeqParameterSet sps;
    private final Picture ref;
    private final BlockInterpolator interpolator;

    public MBWriterP16x16(SeqParameterSet sps, Picture ref) {
        this.sps = sps;
        this.ref = ref;
        this.interpolator = new BlockInterpolator();
    }

    public void encodeMacroblock(EncodingContext ctx, Picture pic, int mbX, int mbY, BitWriter out, EncodedMB outMB, int qp, H264Encoder.NonRdVector params) {
        if (this.sps.numRefFrames > 1) {
            int refIdx = this.decideRef();
            CAVLCWriter.writeTE(out, refIdx, this.sps.numRefFrames - 1);
        }
        int partBlkSize = 4;
        boolean refIdx = true;
        boolean trAvb = mbY > 0 && mbX < this.sps.picWidthInMbsMinus1;
        boolean tlAvb = mbX > 0 && mbY > 0;
        int ax = ctx.mvLeftX[0];
        int ay = ctx.mvLeftY[0];
        boolean ar = ctx.mvLeftR[0] == 1;
        int bx = ctx.mvTopX[mbX << 2];
        int by = ctx.mvTopY[mbX << 2];
        boolean br = ctx.mvTopR[mbX << 2] == 1;
        int cx = trAvb ? ctx.mvTopX[(mbX << 2) + 4] : 0;
        int cy = trAvb ? ctx.mvTopY[(mbX << 2) + 4] : 0;
        boolean cr = trAvb && ctx.mvTopR[(mbX << 2) + 4] == 1;
        int dx = tlAvb ? ctx.mvTopLeftX : 0;
        int dy = tlAvb ? ctx.mvTopLeftY : 0;
        boolean dr = tlAvb && ctx.mvTopLeftR == 1;
        int mvpx = H264EncoderUtils.median(ax, ar, bx, br, cx, cr, dx, dr, mbX > 0, mbY > 0, trAvb, tlAvb);
        int mvpy = H264EncoderUtils.median(ay, ar, by, br, cy, cr, dy, dr, mbX > 0, mbY > 0, trAvb, tlAvb);
        CAVLCWriter.writeSE(out, params.mv[0] - mvpx);
        CAVLCWriter.writeSE(out, params.mv[1] - mvpy);
        Picture mbRef = Picture.create(16, 16, this.sps.chromaFormatIdc);
        int[][] mb = new int[][]{new int[256], new int[64], new int[64]};
        this.interpolator.getBlockLuma(this.ref, mbRef, 0, (mbX << 6) + params.mv[0], (mbY << 6) + params.mv[1], 16, 16);
        BlockInterpolator.getBlockChroma(this.ref.getPlaneData(1), this.ref.getPlaneWidth(1), this.ref.getPlaneHeight(1), mbRef.getPlaneData(1), 0, mbRef.getPlaneWidth(1), (mbX << 6) + params.mv[0], (mbY << 6) + params.mv[1], 8, 8);
        BlockInterpolator.getBlockChroma(this.ref.getPlaneData(2), this.ref.getPlaneWidth(2), this.ref.getPlaneHeight(2), mbRef.getPlaneData(2), 0, mbRef.getPlaneWidth(2), (mbX << 6) + params.mv[0], (mbY << 6) + params.mv[1], 8, 8);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), mbX << 4, mbY << 4, mb[0], mbRef.getPlaneData(0), 16, 16);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(1), pic.getPlaneWidth(1), pic.getPlaneHeight(1), mbX << 3, mbY << 3, mb[1], mbRef.getPlaneData(1), 8, 8);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(2), pic.getPlaneWidth(2), pic.getPlaneHeight(2), mbX << 3, mbY << 3, mb[2], mbRef.getPlaneData(2), 8, 8);
        int codedBlockPattern = this.getCodedBlockPattern();
        CAVLCWriter.writeUE(out, H264Const.CODED_BLOCK_PATTERN_INTER_COLOR_INV[codedBlockPattern]);
        CAVLCWriter.writeSE(out, qp - ctx.prevQp);
        MBWriterP16x16.luma(ctx, mb[0], mbX, mbY, out, qp, outMB.getNc());
        MBWriterP16x16.chroma(ctx, mb[1], mb[2], mbX, mbY, out, qp);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(0), mb[0], mbRef.getPlaneData(0), 4, 0, 0, 16, 16);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(1), mb[1], mbRef.getPlaneData(1), 3, 0, 0, 8, 8);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(2), mb[2], mbRef.getPlaneData(2), 3, 0, 0, 8, 8);
        Arrays.fill(outMB.getMx(), params.mv[0]);
        Arrays.fill(outMB.getMy(), params.mv[1]);
        Arrays.fill(outMB.getMr(), 1);
        outMB.setType(MBType.P_16x16);
        outMB.setQp(qp);
        ctx.prevQp = qp;
    }

    private int getCodedBlockPattern() {
        return 47;
    }

    private int decideRef() {
        return 0;
    }

    private static void luma(EncodingContext ctx, int[] pix, int mbX, int mbY, BitWriter out, int qp, int[] nc) {
        int j;
        int i;
        int[][] ac = new int[16][16];
        for (i = 0; i < ac.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_4x4[i].length; ++j) {
                ac[i][j] = pix[H264Const.PIX_MAP_SPLIT_4x4[i][j]];
            }
            CoeffTransformer.fdct4x4(ac[i]);
        }
        MBWriterP16x16.writeAC(ctx, mbX, out, mbX << 2, mbY << 2, ac, qp, nc);
        for (i = 0; i < ac.length; ++i) {
            CoeffTransformer.dequantizeAC(ac[i], qp, null);
            CoeffTransformer.idct4x4(ac[i]);
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_4x4[i].length; ++j) {
                pix[H264Const.PIX_MAP_SPLIT_4x4[i][j]] = ac[i][j];
            }
        }
    }

    private static void chroma(EncodingContext ctx, int[] pix1, int[] pix2, int mbX, int mbY, BitWriter out, int qp) {
        int j;
        int i;
        int[][] ac1 = new int[4][16];
        int[][] ac2 = new int[4][16];
        for (i = 0; i < ac1.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                ac1[i][j] = pix1[H264Const.PIX_MAP_SPLIT_2x2[i][j]];
            }
        }
        for (i = 0; i < ac2.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                ac2[i][j] = pix2[H264Const.PIX_MAP_SPLIT_2x2[i][j]];
            }
        }
        MBWriterI16x16.chromaResidual(mbX, mbY, out, qp, ac1, ac2, ctx.cavlc[1], ctx.cavlc[2], ctx.leftMBType, ctx.topMBType[mbX], MBType.P_16x16);
        for (i = 0; i < ac1.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                pix1[H264Const.PIX_MAP_SPLIT_2x2[i][j]] = ac1[i][j];
            }
        }
        for (i = 0; i < ac2.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                pix2[H264Const.PIX_MAP_SPLIT_2x2[i][j]] = ac2[i][j];
            }
        }
    }

    private static void writeAC(EncodingContext ctx, int mbX, BitWriter out, int mbLeftBlk, int mbTopBlk, int[][] ac, int qp, int[] nc) {
        for (int bIndx = 0; bIndx < ac.length; ++bIndx) {
            int dIdx = H264Const.BLK_DISP_MAP[bIndx];
            CoeffTransformer.quantizeAC(ac[dIdx], qp);
            int blkOffLeft = H264Const.MB_DISP_OFF_LEFT[bIndx];
            int blkOffTop = H264Const.MB_DISP_OFF_TOP[bIndx];
            int coeffToken = ctx.cavlc[0].writeACBlock(out, mbLeftBlk + blkOffLeft, mbTopBlk + blkOffTop, blkOffLeft == 0 ? ctx.leftMBType : MBType.P_16x16, blkOffTop == 0 ? ctx.topMBType[mbX] : MBType.P_16x16, ac[dIdx], H264Const.totalZeros16, 0, 16, CoeffTransformer.zigzag4x4);
            nc[dIdx] = coeffToken >> 4;
        }
    }
}

