/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.io.model;

import java.util.Comparator;
import li.cil.oc2r.jcodec.codecs.h264.H264Utils;
import li.cil.oc2r.jcodec.common.model.ColorSpace;
import li.cil.oc2r.jcodec.common.model.Picture;

public final class Frame
extends Picture {
    private int frameNo;
    private H264Utils.MvList2D mvs;
    private Frame[][][] refsUsed;
    private boolean shortTerm;
    private int poc;
    public static final Comparator<Frame> POCAsc = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return Integer.compare(o1.poc, o2.poc);
    };
    public static final Comparator<Frame> POCDesc = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return Integer.compare(o2.poc, o1.poc);
    };

    public Frame(int width, int height, byte[][] data, ColorSpace color, int frameNo, H264Utils.MvList2D mvs, Frame[][][] refsUsed, int poc) {
        super(width, height, data, color);
        this.frameNo = frameNo;
        this.mvs = mvs;
        this.refsUsed = refsUsed;
        this.poc = poc;
        this.shortTerm = true;
    }

    public static Frame createFrame(Frame pic) {
        Picture comp = pic.createCompatible();
        return new Frame(comp.getWidth(), comp.getHeight(), comp.getData(), comp.getColor(), pic.frameNo, pic.mvs, pic.refsUsed, pic.poc);
    }

    public void copyFromFrame(Frame src) {
        super.copyFrom(src);
        this.frameNo = src.frameNo;
        this.mvs = src.mvs;
        this.shortTerm = src.shortTerm;
        this.refsUsed = src.refsUsed;
        this.poc = src.poc;
    }

    public int getFrameNo() {
        return this.frameNo;
    }

    public H264Utils.MvList2D getMvs() {
        return this.mvs;
    }

    public boolean isShortTerm() {
        return this.shortTerm;
    }

    public void setShortTerm(boolean shortTerm) {
        this.shortTerm = shortTerm;
    }

    public int getPOC() {
        return this.poc;
    }

    public Frame[][][] getRefsUsed() {
        return this.refsUsed;
    }
}

