/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.io.write;

import li.cil.oc2r.jcodec.common.io.BitWriter;
import li.cil.oc2r.jcodec.common.tools.MathUtil;

public final class CAVLCWriter {
    private CAVLCWriter() {
    }

    public static void writeUE(BitWriter out, int value) {
        int bits = 0;
        int cumul = 0;
        for (int i = 0; i < 15; ++i) {
            if (value < cumul + (1 << i)) {
                bits = i;
                break;
            }
            cumul += 1 << i;
        }
        out.writeNBit(0, bits);
        out.write1Bit(1);
        out.writeNBit(value - cumul, bits);
    }

    public static void writeSE(BitWriter out, int value) {
        CAVLCWriter.writeUE(out, MathUtil.golomb(value));
    }

    public static void writeTE(BitWriter out, int value, int max) {
        if (max > 1) {
            CAVLCWriter.writeUE(out, value);
        } else {
            out.write1Bit(~value & 1);
        }
    }

    public static void writeBool(BitWriter out, boolean value) {
        out.write1Bit(value ? 1 : 0);
    }

    public static void writeU(BitWriter out, int i, int n) {
        out.writeNBit(i, n);
    }

    public static void writeNBit(BitWriter out, long value, int n, String message) {
        for (int i = 0; i < n; ++i) {
            out.write1Bit((int)(value >> n - i - 1) & 1);
        }
    }

    public static void writeTrailingBits(BitWriter out) {
        out.write1Bit(1);
        out.flush();
    }
}

