/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.codecs.h264.io.write;

import li.cil.oc2r.jcodec.codecs.h264.io.model.PictureParameterSet;
import li.cil.oc2r.jcodec.codecs.h264.io.model.RefPicMarking;
import li.cil.oc2r.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2r.jcodec.codecs.h264.io.model.SliceType;
import li.cil.oc2r.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2r.jcodec.common.io.BitWriter;
import li.cil.oc2r.jcodec.common.model.ColorSpace;

public final class SliceHeaderWriter {
    private SliceHeaderWriter() {
    }

    public static void write(SliceHeader sliceHeader, boolean idrSlice, int nalRefIdc, BitWriter writer) {
        SeqParameterSet sps = sliceHeader.sps;
        PictureParameterSet pps = sliceHeader.pps;
        CAVLCWriter.writeUE(writer, sliceHeader.firstMbInSlice);
        int value = sliceHeader.sliceType.ordinal() + (sliceHeader.sliceTypeRestr ? 5 : 0);
        CAVLCWriter.writeUE(writer, value);
        CAVLCWriter.writeUE(writer, sliceHeader.picParameterSetId);
        if (sliceHeader.frameNum > 1 << sps.log2MaxFrameNumMinus4 + 4) {
            throw new IllegalArgumentException("frame_num > " + (1 << sps.log2MaxFrameNumMinus4 + 4));
        }
        writer.writeNBit(sliceHeader.frameNum, sps.log2MaxFrameNumMinus4 + 4);
        if (!sps.frameMbsOnlyFlag) {
            CAVLCWriter.writeBool(writer, sliceHeader.fieldPicFlag);
            if (sliceHeader.fieldPicFlag) {
                CAVLCWriter.writeBool(writer, sliceHeader.bottomFieldFlag);
            }
        }
        if (idrSlice) {
            CAVLCWriter.writeUE(writer, sliceHeader.idrPicId);
        }
        if (sps.picOrderCntType == 0) {
            if (sliceHeader.picOrderCntLsb > 1 << sps.log2MaxPicOrderCntLsbMinus4 + 4) {
                throw new IllegalArgumentException("pic_order_cnt_lsb > " + (1 << sps.log2MaxPicOrderCntLsbMinus4 + 4));
            }
            CAVLCWriter.writeU(writer, sliceHeader.picOrderCntLsb, sps.log2MaxPicOrderCntLsbMinus4 + 4);
            if (pps.picOrderPresentFlag && !sps.fieldPicFlag) {
                CAVLCWriter.writeSE(writer, sliceHeader.deltaPicOrderCntBottom);
            }
        }
        if (sps.picOrderCntType == 1 && !sps.deltaPicOrderAlwaysZeroFlag) {
            CAVLCWriter.writeSE(writer, sliceHeader.deltaPicOrderCnt[0]);
            if (pps.picOrderPresentFlag && !sps.fieldPicFlag) {
                CAVLCWriter.writeSE(writer, sliceHeader.deltaPicOrderCnt[1]);
            }
        }
        if (pps.redundantPicCntPresentFlag) {
            CAVLCWriter.writeUE(writer, sliceHeader.redundantPicCnt);
        }
        if (sliceHeader.sliceType == SliceType.B) {
            CAVLCWriter.writeBool(writer, sliceHeader.directSpatialMvPredFlag);
        }
        if (sliceHeader.sliceType == SliceType.P || sliceHeader.sliceType == SliceType.SP || sliceHeader.sliceType == SliceType.B) {
            CAVLCWriter.writeBool(writer, sliceHeader.numRefIdxActiveOverrideFlag);
            if (sliceHeader.numRefIdxActiveOverrideFlag) {
                CAVLCWriter.writeUE(writer, sliceHeader.numRefIdxActiveMinus1[0]);
                if (sliceHeader.sliceType == SliceType.B) {
                    CAVLCWriter.writeUE(writer, sliceHeader.numRefIdxActiveMinus1[1]);
                }
            }
        }
        SliceHeaderWriter.writeRefPicListReordering(sliceHeader, writer);
        if (pps.weightedPredFlag && (sliceHeader.sliceType == SliceType.P || sliceHeader.sliceType == SliceType.SP) || pps.weightedBipredIdc == 1 && sliceHeader.sliceType == SliceType.B) {
            SliceHeaderWriter.writePredWeightTable(sliceHeader, writer);
        }
        if (nalRefIdc != 0) {
            SliceHeaderWriter.writeDecRefPicMarking(sliceHeader, idrSlice, writer);
        }
        if (pps.entropyCodingModeFlag && sliceHeader.sliceType.isInter()) {
            CAVLCWriter.writeUE(writer, sliceHeader.cabacInitIdc);
        }
        CAVLCWriter.writeSE(writer, sliceHeader.sliceQpDelta);
        if (sliceHeader.sliceType == SliceType.SP || sliceHeader.sliceType == SliceType.SI) {
            if (sliceHeader.sliceType == SliceType.SP) {
                CAVLCWriter.writeBool(writer, sliceHeader.spForSwitchFlag);
            }
            CAVLCWriter.writeSE(writer, sliceHeader.sliceQsDelta);
        }
        if (pps.deblockingFilterControlPresentFlag) {
            CAVLCWriter.writeUE(writer, sliceHeader.disableDeblockingFilterIdc);
            if (sliceHeader.disableDeblockingFilterIdc != 1) {
                CAVLCWriter.writeSE(writer, sliceHeader.sliceAlphaC0OffsetDiv2);
                CAVLCWriter.writeSE(writer, sliceHeader.sliceBetaOffsetDiv2);
            }
        }
        if (pps.numSliceGroupsMinus1 > 0 && pps.sliceGroupMapType >= 3 && pps.sliceGroupMapType <= 5) {
            int len = (sps.picHeightInMapUnitsMinus1 + 1) * (sps.picWidthInMbsMinus1 + 1) / (pps.sliceGroupChangeRateMinus1 + 1);
            if ((sps.picHeightInMapUnitsMinus1 + 1) * (sps.picWidthInMbsMinus1 + 1) % (pps.sliceGroupChangeRateMinus1 + 1) > 0) {
                ++len;
            }
            len = SliceHeaderWriter.CeilLog2(len + 1);
            CAVLCWriter.writeU(writer, sliceHeader.sliceGroupChangeCycle, len);
        }
    }

    private static int CeilLog2(int uiVal) {
        int uiTmp = uiVal - 1;
        int uiRet = 0;
        while (uiTmp != 0) {
            uiTmp >>= 1;
            ++uiRet;
        }
        return uiRet;
    }

    private static void writeDecRefPicMarking(SliceHeader sliceHeader, boolean idrSlice, BitWriter writer) {
        if (idrSlice) {
            RefPicMarkingIDR drpmidr = sliceHeader.refPicMarkingIDR;
            CAVLCWriter.writeBool(writer, drpmidr.discardDecodedPics());
            CAVLCWriter.writeBool(writer, drpmidr.useForlongTerm());
        } else {
            CAVLCWriter.writeBool(writer, sliceHeader.refPicMarkingNonIDR != null);
            if (sliceHeader.refPicMarkingNonIDR != null) {
                RefPicMarking.Instruction[] instructions;
                RefPicMarking drpmidr = sliceHeader.refPicMarkingNonIDR;
                block8: for (RefPicMarking.Instruction mmop : instructions = drpmidr.instructions()) {
                    switch (mmop.type()) {
                        case REMOVE_SHORT: {
                            CAVLCWriter.writeUE(writer, 1);
                            CAVLCWriter.writeUE(writer, mmop.arg1() - 1);
                            continue block8;
                        }
                        case REMOVE_LONG: {
                            CAVLCWriter.writeUE(writer, 2);
                            CAVLCWriter.writeUE(writer, mmop.arg1());
                            continue block8;
                        }
                        case CONVERT_INTO_LONG: {
                            CAVLCWriter.writeUE(writer, 3);
                            CAVLCWriter.writeUE(writer, mmop.arg1() - 1);
                            CAVLCWriter.writeUE(writer, mmop.arg2());
                            continue block8;
                        }
                        case TRUNK_LONG: {
                            CAVLCWriter.writeUE(writer, 4);
                            CAVLCWriter.writeUE(writer, mmop.arg1() + 1);
                            continue block8;
                        }
                        case CLEAR: {
                            CAVLCWriter.writeUE(writer, 5);
                            continue block8;
                        }
                        case MARK_LONG: {
                            CAVLCWriter.writeUE(writer, 6);
                            CAVLCWriter.writeUE(writer, mmop.arg1());
                        }
                    }
                }
                CAVLCWriter.writeUE(writer, 0);
            }
        }
    }

    private static void writePredWeightTable(SliceHeader sliceHeader, BitWriter writer) {
        SeqParameterSet sps = sliceHeader.sps;
        CAVLCWriter.writeUE(writer, sliceHeader.predWeightTable.lumaLog2WeightDenom);
        if (sps.chromaFormatIdc != ColorSpace.MONO) {
            CAVLCWriter.writeUE(writer, sliceHeader.predWeightTable.chromaLog2WeightDenom);
        }
        SliceHeaderWriter.writeOffsetWeight(sliceHeader, writer, 0);
        if (sliceHeader.sliceType == SliceType.B) {
            SliceHeaderWriter.writeOffsetWeight(sliceHeader, writer, 1);
        }
    }

    private static void writeOffsetWeight(SliceHeader sliceHeader, BitWriter writer, int list) {
        SeqParameterSet sps = sliceHeader.sps;
        int defaultLW = 1 << sliceHeader.predWeightTable.lumaLog2WeightDenom;
        int defaultCW = 1 << sliceHeader.predWeightTable.chromaLog2WeightDenom;
        for (int i = 0; i < sliceHeader.predWeightTable.lumaWeight[list].length; ++i) {
            boolean flagLuma = sliceHeader.predWeightTable.lumaWeight[list][i] != defaultLW || sliceHeader.predWeightTable.lumaOffset[list][i] != 0;
            CAVLCWriter.writeBool(writer, flagLuma);
            if (flagLuma) {
                CAVLCWriter.writeSE(writer, sliceHeader.predWeightTable.lumaWeight[list][i]);
                CAVLCWriter.writeSE(writer, sliceHeader.predWeightTable.lumaOffset[list][i]);
            }
            if (sps.chromaFormatIdc == ColorSpace.MONO) continue;
            boolean flagChroma = sliceHeader.predWeightTable.chromaWeight[list][0][i] != defaultCW || sliceHeader.predWeightTable.chromaOffset[list][0][i] != 0 || sliceHeader.predWeightTable.chromaWeight[list][1][i] != defaultCW || sliceHeader.predWeightTable.chromaOffset[list][1][i] != 0;
            CAVLCWriter.writeBool(writer, flagChroma);
            if (!flagChroma) continue;
            for (int j = 0; j < 2; ++j) {
                CAVLCWriter.writeSE(writer, sliceHeader.predWeightTable.chromaWeight[list][j][i]);
                CAVLCWriter.writeSE(writer, sliceHeader.predWeightTable.chromaOffset[list][j][i]);
            }
        }
    }

    private static void writeRefPicListReordering(SliceHeader sliceHeader, BitWriter writer) {
        if (sliceHeader.sliceType.isInter()) {
            boolean l0ReorderingPresent = sliceHeader.refPicReordering != null && sliceHeader.refPicReordering[0] != null;
            CAVLCWriter.writeBool(writer, l0ReorderingPresent);
            if (l0ReorderingPresent) {
                SliceHeaderWriter.writeReorderingList(sliceHeader.refPicReordering[0], writer);
            }
        }
        if (sliceHeader.sliceType == SliceType.B) {
            boolean l1ReorderingPresent = sliceHeader.refPicReordering != null && sliceHeader.refPicReordering[1] != null;
            CAVLCWriter.writeBool(writer, l1ReorderingPresent);
            if (l1ReorderingPresent) {
                SliceHeaderWriter.writeReorderingList(sliceHeader.refPicReordering[1], writer);
            }
        }
    }

    private static void writeReorderingList(int[][] reordering, BitWriter writer) {
        if (reordering == null) {
            return;
        }
        for (int i = 0; i < reordering[0].length; ++i) {
            CAVLCWriter.writeUE(writer, reordering[0][i]);
            CAVLCWriter.writeUE(writer, reordering[1][i]);
        }
        CAVLCWriter.writeUE(writer, 3);
    }
}

