/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.common.io;

import java.nio.ByteBuffer;

public final class BitWriter {
    private final ByteBuffer buf;
    private int curInt;
    private int curBit;
    private int initPos;

    public BitWriter(ByteBuffer buf) {
        this.buf = buf;
        this.initPos = buf.position();
    }

    public BitWriter fork() {
        BitWriter fork = new BitWriter(this.buf.duplicate());
        fork.curBit = this.curBit;
        fork.curInt = this.curInt;
        fork.initPos = this.initPos;
        return fork;
    }

    public void writeOther(BitWriter bw) {
        if (this.curBit >= 8) {
            int shift = 32 - this.curBit;
            for (int i = this.initPos; i < bw.buf.position(); ++i) {
                this.buf.put((byte)(this.curInt >> 24));
                this.curInt <<= 8;
                this.curInt |= (bw.buf.get(i) & 0xFF) << shift;
            }
        } else {
            int shift = 24 - this.curBit;
            for (int i = this.initPos; i < bw.buf.position(); ++i) {
                this.curInt |= (bw.buf.get(i) & 0xFF) << shift;
                this.buf.put((byte)(this.curInt >> 24));
                this.curInt <<= 8;
            }
        }
        this.writeNBit(bw.curInt >> 32 - bw.curBit, bw.curBit);
    }

    public void flush() {
        int toWrite = this.curBit + 7 >> 3;
        for (int i = 0; i < toWrite; ++i) {
            this.buf.put((byte)(this.curInt >>> 24));
            this.curInt <<= 8;
        }
    }

    private void putInt(int i) {
        this.buf.put((byte)(i >>> 24));
        this.buf.put((byte)(i >> 16));
        this.buf.put((byte)(i >> 8));
        this.buf.put((byte)i);
    }

    public void writeNBit(int value, int n) {
        if (n > 32) {
            throw new IllegalArgumentException("Max 32 bit to write");
        }
        if (n == 0) {
            return;
        }
        value &= -1 >>> 32 - n;
        if (32 - this.curBit >= n) {
            this.curInt |= value << 32 - this.curBit - n;
            this.curBit += n;
            if (this.curBit == 32) {
                this.putInt(this.curInt);
                this.curBit = 0;
                this.curInt = 0;
            }
        } else {
            int secPart = n - (32 - this.curBit);
            this.curInt |= value >>> secPart;
            this.putInt(this.curInt);
            this.curInt = value << 32 - secPart;
            this.curBit = secPart;
        }
    }

    public void write1Bit(int bit) {
        this.curInt |= bit << 32 - this.curBit - 1;
        ++this.curBit;
        if (this.curBit == 32) {
            this.putInt(this.curInt);
            this.curBit = 0;
            this.curInt = 0;
        }
    }

    public int curBit() {
        return this.curBit & 7;
    }

    public int position() {
        return (this.buf.position() - this.initPos << 3) + this.curBit;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }
}

