/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.jcodec.common.model;

import java.util.Arrays;
import li.cil.oc2r.jcodec.common.model.ColorSpace;
import li.cil.oc2r.jcodec.common.model.Size;

public class Picture {
    private ColorSpace color;
    private final int width;
    private final int height;
    private final byte[][] data;

    public static Picture createPicture(int width, int height, byte[][] data, ColorSpace color) {
        return new Picture(width, height, data, color);
    }

    public Picture(int width, int height, byte[][] data, ColorSpace color) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.color = color;
        if (color != null) {
            for (int i = 0; i < color.nComp; ++i) {
                int mask = 255 >> 8 - color.compWidth[i];
                if ((width & mask) != 0) {
                    throw new IllegalArgumentException("Component " + i + " width should be a multiple of " + (1 << color.compWidth[i]) + " for colorspace: " + color);
                }
                mask = 255 >> 8 - color.compHeight[i];
                if ((height & mask) == 0) continue;
                throw new IllegalArgumentException("Component " + i + " height should be a multiple of " + (1 << color.compHeight[i]) + " for colorspace: " + color);
            }
        }
    }

    public static Picture copyPicture(Picture other) {
        return new Picture(other.width, other.height, other.data, other.color);
    }

    public static Picture create(int width, int height, ColorSpace colorSpace) {
        int[] planeSizes = new int[4];
        for (int i = 0; i < colorSpace.nComp; ++i) {
            int n = colorSpace.compPlane[i];
            planeSizes[n] = planeSizes[n] + (width >> colorSpace.compWidth[i]) * (height >> colorSpace.compHeight[i]);
        }
        int nPlanes = 0;
        for (int i = 0; i < 4; ++i) {
            nPlanes += planeSizes[i] != 0 ? 1 : 0;
        }
        byte[][] data1 = new byte[nPlanes][];
        int plane = 0;
        for (int i = 0; i < 4; ++i) {
            if (planeSizes[i] == 0) continue;
            data1[plane++] = new byte[planeSizes[i]];
        }
        return new Picture(width, height, data1, colorSpace);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPlaneData(int plane) {
        return this.data[plane];
    }

    public ColorSpace getColor() {
        return this.color;
    }

    public void setColor(ColorSpace color) {
        this.color = color;
    }

    public byte[][] getData() {
        return this.data;
    }

    public int getPlaneWidth(int plane) {
        return this.width >> this.color.compWidth[plane];
    }

    public int getPlaneHeight(int plane) {
        return this.height >> this.color.compHeight[plane];
    }

    public boolean compatible(Picture src) {
        return src.color == this.color && src.width == this.width && src.height == this.height;
    }

    public Picture createCompatible() {
        return Picture.create(this.width, this.height, this.color);
    }

    public void copyFrom(Picture src) {
        if (!this.compatible(src)) {
            throw new IllegalArgumentException("Can not copy to incompatible picture");
        }
        for (int plane = 0; plane < this.color.nComp; ++plane) {
            if (this.data[plane] == null) continue;
            System.arraycopy(src.data[plane], 0, this.data[plane], 0, (this.width >> this.color.compWidth[plane]) * (this.height >> this.color.compHeight[plane]));
        }
    }

    public void fill(int val) {
        for (byte[] plane : this.data) {
            Arrays.fill(plane, (byte)val);
        }
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }
}

