/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.client.model;

import java.util.NoSuchElementException;
import java.util.Optional;
import me.jesuismister.cubicracers.entity.custom.Kart;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class KartModel
extends GeoModel<Kart> {
    private static float WHEELS_ROTATION_DEGREE = 18.0f;
    private static float WHEELS_TURN_DEGREE = 15.0f;
    private static float ROTATE_KART_DEGREE = 5.0f;

    public ResourceLocation getModelResource(Kart kart) {
        return new ResourceLocation("cubicracers", kart.MODEL);
    }

    public ResourceLocation getTextureResource(Kart kart) {
        if (kart.getIsInvinsible()) {
            return new ResourceLocation("cubicracers", "textures/entity/star_model.png");
        }
        return new ResourceLocation("cubicracers", kart.TEXTURE);
    }

    public ResourceLocation getAnimationResource(Kart kart) {
        return new ResourceLocation("cubicracers", kart.ANIMATION);
    }

    public void setCustomAnimations(Kart kart, long instanceId, AnimationState<Kart> animationState) {
        super.setCustomAnimations((GeoAnimatable)kart, instanceId, animationState);
        Optional bonesKart = this.getBone("kart");
        if (!bonesKart.isPresent()) {
            return;
        }
        if (!kart.getDeltaOn()) {
            float rotYDroit;
            kart.setPourcentageInclinaison(0.0f);
            Optional bonesGaucheAvant = this.getBone("front_left");
            Optional bonesDroiteAvant = this.getBone("front_right");
            Optional bonesGaucheArriere = this.getBone("back_left");
            Optional bonesDroiteArriere = this.getBone("back_right");
            Optional bonesPropeller = this.getBone("propeller");
            float rotYGauche = 0.0f;
            try {
                rotYDroit = ((GeoBone)bonesDroiteArriere.get()).getRotY();
            }
            catch (NoSuchElementException e) {
                System.out.println("INVALID KART FORMAT");
                return;
            }
            if (kart.getIsDrifting() && kart.getDriftingSens().equals("Left")) {
                if (kart.getIsPressingKeyLeft() && !kart.getIsPressingKeyRight()) {
                    rotYGauche = 1.75f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = 1.75f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                } else if (kart.getIsPressingKeyRight() && !kart.getIsPressingKeyLeft()) {
                    rotYGauche = -1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = -1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                } else {
                    rotYGauche = 1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = 1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                }
            } else if (kart.getIsDrifting() && kart.getDriftingSens().equals("Right")) {
                if (kart.getIsPressingKeyRight() && !kart.getIsPressingKeyLeft()) {
                    rotYGauche = -1.75f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = (-1.75f * WHEELS_TURN_DEGREE - 180.0f) * ((float)Math.PI / 180);
                } else if (kart.getIsPressingKeyLeft() && !kart.getIsPressingKeyRight()) {
                    rotYGauche = 1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = (1.125f * WHEELS_TURN_DEGREE - 180.0f) * ((float)Math.PI / 180);
                } else {
                    rotYGauche = -1.125f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                    rotYDroit = (-1.125f * WHEELS_TURN_DEGREE - 180.0f) * ((float)Math.PI / 180);
                }
            } else {
                if (kart.getIsPressingKeyLeft() && !kart.getIsPressingKeyRight()) {
                    rotYGauche = WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                } else if (kart.getIsPressingKeyRight() && !kart.getIsPressingKeyLeft()) {
                    rotYGauche = -1.0f * WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                }
                if (kart.getIsPressingKeyLeft() && !kart.getIsPressingKeyRight()) {
                    rotYDroit = WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                } else if (kart.getIsPressingKeyRight() && !kart.getIsPressingKeyLeft()) {
                    rotYDroit = -WHEELS_TURN_DEGREE * ((float)Math.PI / 180);
                }
            }
            kart.setActualRotationWheels((float)((double)kart.getActualRotationWheels() + Math.toRadians(kart.getSpeed() * WHEELS_ROTATION_DEGREE)) % (float)Math.abs(360));
            if (bonesGaucheAvant.isPresent()) {
                ((GeoBone)bonesGaucheAvant.get()).updateRotation(-kart.getActualRotationWheels(), rotYGauche, 0.0f);
            }
            if (bonesDroiteAvant.isPresent()) {
                ((GeoBone)bonesDroiteAvant.get()).updateRotation(-kart.getActualRotationWheels(), rotYDroit, 0.0f);
            }
            if (bonesGaucheArriere.isPresent()) {
                ((GeoBone)bonesGaucheArriere.get()).updateRotation(-kart.getActualRotationWheels(), 0.0f, 0.0f);
            }
            if (bonesDroiteArriere.isPresent()) {
                ((GeoBone)bonesDroiteArriere.get()).updateRotation(-kart.getActualRotationWheels(), ((GeoBone)bonesDroiteArriere.get()).getRotY(), 0.0f);
            }
            if (bonesPropeller.isPresent()) {
                ((GeoBone)bonesPropeller.get()).updateRotation(0.0f, 0.0f, -2.0f * kart.getActualRotationWheels());
            }
        } else {
            if (kart.getIsPressingKeyLeft() && !kart.getIsPressingKeyRight()) {
                if (kart.getPourcentageInclinaison() < 1.0f) {
                    kart.setPourcentageInclinaison(kart.getPourcentageInclinaison() + 0.02f);
                }
            } else if (kart.getIsPressingKeyRight() && !kart.getIsPressingKeyLeft()) {
                if (kart.getPourcentageInclinaison() > -1.0f) {
                    kart.setPourcentageInclinaison(kart.getPourcentageInclinaison() - 0.02f);
                }
            } else if (kart.getPourcentageInclinaison() != 0.0f) {
                kart.setPourcentageInclinaison((float)((double)kart.getPourcentageInclinaison() + (double)(-(Math.abs(kart.getPourcentageInclinaison()) / kart.getPourcentageInclinaison())) * 0.02));
            }
            ((GeoBone)bonesKart.get()).updateRotation(0.0f, 0.0f, ROTATE_KART_DEGREE * ((float)Math.PI / 180) * kart.getPourcentageInclinaison());
        }
    }
}

