/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import me.jesuismister.cubicracers.entity.client.model.KartModel;
import me.jesuismister.cubicracers.entity.custom.Kart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class KartRenderer
extends GeoEntityRenderer<Kart> {
    public KartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new KartModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(Kart animatable) {
        if (animatable.getIsInvinsible()) {
            return new ResourceLocation("cubicracers", "textures/entity/star_model.png");
        }
        return new ResourceLocation("cubicracers", animatable.TEXTURE);
    }

    public void render(@NotNull Kart entity, float entityYaw, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        Quaternionf rotation = new Quaternionf();
        if (entity.getCanMove()) {
            if (entity.getIsDrifting()) {
                if (entity.getDriftingSens().equals("Left")) {
                    rotation.rotateY((float)(-Math.toRadians(entityYaw - 20.0f)));
                } else {
                    rotation.rotateY((float)(-Math.toRadians(entityYaw + 20.0f)));
                }
            } else {
                rotation.rotateY((float)(-Math.toRadians(entityYaw)));
            }
        } else {
            rotation.rotateY((float)(-Math.toRadians(entityYaw + entity.getStunRotation())));
        }
        poseStack.m_252781_(rotation);
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public RenderType getRenderType(Kart animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return super.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
    }
}

