/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import me.jesuismister.cubicracers.entity.custom.ItemKartAbstract;
import me.jesuismister.cubicracers.entity.custom.Kart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Banana
extends ItemKartAbstract
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String TEXTURE = "textures/entity/banana.png";
    public static final String MODEL = "geo/banana.geo.json";
    public static final String ANIMATION = "animations/banana.animation.json";
    public static final float HITBOX = 1.0f;
    private static final int TICK_TO_DESPAWN = 1800;
    private int tickAlive = 0;

    public Banana(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("dancing", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsPropulsing() && !this.m_20096_()) {
            double x = Math.sin(Math.toRadians(-this.m_146908_())) * 3.5;
            double z = Math.cos(Math.toRadians(-this.m_146908_())) * 3.5;
            Vec3 vec3 = new Vec3(x, 0.0, z);
            this.m_20256_(vec3);
            this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().f_82479_, (1.0 - Math.sqrt(this.propulsionY)) * 3.0, this.m_20184_().f_82481_));
            this.propulsionY += 0.3f;
        } else {
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.0));
            for (Entity entity : nearbyEntities) {
                Kart kart;
                if (!(entity instanceof Kart) || (kart = (Kart)entity).m_146895_() == null) continue;
                if (kart.getCanMove()) {
                    Kart.stunKart(kart, "Banana");
                }
                if (!this.m_9236_().m_5776_()) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                return;
            }
            ++this.tickAlive;
            if (this.tickAlive > 1800) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.getIsPropulsing()) {
                this.setIsPropulsing(false);
            }
            this.m_6478_(MoverType.SELF, new Vec3(0.0, -1.0, 0.0));
        }
    }
}

