/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import java.util.Random;
import me.jesuismister.cubicracers.entity.custom.ItemKartAbstract;
import me.jesuismister.cubicracers.entity.custom.Kart;
import me.jesuismister.cubicracers.network.Network;
import me.jesuismister.cubicracers.network.message.itemsKart.particles.ExplosionParticleMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BobOmb
extends ItemKartAbstract
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String TEXTURE = "textures/entity/bob_omb.png";
    public static final String MODEL = "geo/bob_omb.geo.json";
    public static final String ANIMATION = "animations/bob_omb.animation.json";
    public static final float HITBOX = 1.0f;
    private static final float RANGE = 4.0f;
    private static final float TICK_TO_DESPAWN = 80.0f;
    public static final EntityDataAccessor<Boolean> shouldExplode = SynchedEntityData.m_135353_(Kart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float tickAlive = 0.0f;

    public BobOmb(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(shouldExplode, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsPropulsing() && !this.m_20096_()) {
            double x = Math.sin(Math.toRadians(-this.m_146908_())) * 3.5;
            double z = Math.cos(Math.toRadians(-this.m_146908_())) * 3.5;
            Vec3 vec3 = new Vec3(x, 0.0, z);
            this.m_20256_(vec3);
            this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().f_82479_, (1.0 - Math.sqrt(this.propulsionY)) * 3.0, this.m_20184_().f_82481_));
            this.propulsionY += 0.3f;
        } else {
            if (this.getShouldExplode()) {
                this.stun(4.0f, "Bob_omb");
                if (!this.m_9236_().m_5776_()) {
                    this.sendExplosionParticle();
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                return;
            }
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.0));
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof Kart)) continue;
                this.setShouldExplode(true);
                break;
            }
            this.tickAlive += 1.0f;
            if (this.tickAlive > 80.0f) {
                this.setShouldExplode(true);
            }
            if (this.getIsPropulsing()) {
                this.setIsPropulsing(false);
            }
            this.m_6478_(MoverType.SELF, new Vec3(0.0, -1.0, 0.0));
        }
    }

    private void sendExplosionParticle() {
        Network.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ExplosionParticleMessage(this.m_20185_(), this.m_20186_(), this.m_20189_()));
    }

    public static void spawnExplosionParticles(double x, double y, double z) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            double offsetX = random.nextGaussian() * 4.0;
            double offsetY = random.nextGaussian() * 4.0;
            double offsetZ = random.nextGaussian() * 4.0;
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, offsetX, offsetY, offsetZ);
        }
    }

    public boolean getShouldExplode() {
        return (Boolean)this.f_19804_.m_135370_(shouldExplode);
    }

    public void setShouldExplode(boolean value) {
        this.f_19804_.m_135381_(shouldExplode, (Object)value);
    }
}

