/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import me.jesuismister.cubicracers.entity.custom.ItemKartAbstract;
import me.jesuismister.cubicracers.entity.custom.Kart;
import me.jesuismister.cubicracers.init.KartItemsInit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FakeBox
extends ItemKartAbstract
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String TEXTURE = "textures/entity/item_box.png";
    public static final String MODEL = "geo/item_box.geo.json";
    public static final String ANIMATION = "animations/item_box.animation.json";
    public static final float HITBOX_X = 1.0f;
    public static final float HITBOX_Y = 2.0f;
    private static final float TICK_TO_DESPAWN = 1800.0f;
    private float tickAlive = 0.0f;
    private float propulsionY = -1.0f;

    public FakeBox(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public FakeBox(Level level, double x, double y, double z) {
        this((EntityType)KartItemsInit.ITEM_BOX.get(), level);
        this.f_19854_ = Math.floor(x) + 0.5;
        this.f_19855_ = y;
        this.f_19856_ = Math.floor(z) + 0.5;
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("box_on", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsPropulsing() && !this.m_20096_()) {
            double x = Math.sin(Math.toRadians(-this.m_146908_())) * 3.5;
            double z = Math.cos(Math.toRadians(-this.m_146908_())) * 3.5;
            Vec3 vec3 = new Vec3(x, 0.0, z);
            this.m_20256_(vec3);
            this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().f_82479_, (1.0 - Math.sqrt(this.propulsionY)) * 3.0, this.m_20184_().f_82481_));
            this.propulsionY += 0.3f;
        } else {
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.5));
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof Kart)) continue;
                Kart kart = (Kart)entity;
                Kart.stunKart(kart, "Fake_box");
                if (this.m_9236_().m_5776_()) continue;
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.tickAlive += 1.0f;
            if (this.tickAlive > 1800.0f) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.getIsPropulsing()) {
                this.setIsPropulsing(false);
            }
            this.m_6478_(MoverType.SELF, new Vec3(0.0, -1.0, 0.0));
        }
    }
}

