/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import me.jesuismister.cubicracers.entity.custom.ItemKartAbstract;
import me.jesuismister.cubicracers.entity.custom.Kart;
import me.jesuismister.cubicracers.init.SoundsInit;
import me.jesuismister.cubicracers.sounds.SoundGreenShellMoving;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GreenShell
extends ItemKartAbstract
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final float MAX_SPEED = 1.5f;
    public static final String TEXTURE = "textures/entity/green_shell.png";
    public static final String MODEL = "geo/green_shell.geo.json";
    public static final String ANIMATION = "animations/green_shell.animation.json";
    public static final float HITBOX = 1.0f;
    private static final int TICK_TO_DESPAWN = 400;
    private int tickAlive = 0;
    private int bounceTime = 0;
    @OnlyIn(value=Dist.CLIENT)
    private SoundGreenShellMoving greenShellMoving;

    public GreenShell(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("spin", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof Kart)) continue;
            Kart kart = (Kart)entity;
            if (kart.getCanMove()) {
                Kart.stunKart(kart, "Green_shell");
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
        if (this.f_19862_) {
            this.bounce();
        }
        GreenShell.setMovement(this);
        this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().f_82479_, -1.0, this.m_20184_().f_82481_));
        ++this.tickAlive;
        if (this.m_9236_().m_5776_()) {
            this.playMovingSound();
        }
        if (this.tickAlive > 400) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void setMovement(GreenShell green_shell) {
        green_shell.setSpeed(1.5f);
        double x = Math.sin(Math.toRadians(-green_shell.m_146908_())) * 1.5;
        double z = Math.cos(Math.toRadians(-green_shell.m_146908_())) * 1.5;
        Vec3 vec3 = new Vec3(x, 0.0, z);
        green_shell.m_20256_(vec3);
    }

    public float getStepHeight() {
        return 1.2f;
    }

    private void bounce() {
        if (!this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.WEST)).m_60713_(Blocks.f_50016_) && !this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.WEST)).m_60713_(Blocks.f_49990_)) {
            this.m_146922_(-this.m_146908_());
            ++this.bounceTime;
        } else if (!this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60713_(Blocks.f_50016_) && !this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60713_(Blocks.f_49990_)) {
            this.m_146922_(-this.m_146908_());
            ++this.bounceTime;
        } else if (!this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.NORTH)).m_60713_(Blocks.f_50016_) && !this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60713_(Blocks.f_49990_)) {
            this.m_146922_(-180.0f - this.m_146908_());
            ++this.bounceTime;
        } else if (!this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.SOUTH)).m_60713_(Blocks.f_50016_) && !this.m_9236_().m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60713_(Blocks.f_49990_)) {
            this.m_146922_(180.0f - this.m_146908_());
            ++this.bounceTime;
        }
        if (this.bounceTime > 4) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playMovingSound() {
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof Player) || this.isSoundPlaying((SoundInstance)this.greenShellMoving)) continue;
            this.greenShellMoving = new SoundGreenShellMoving(this, (SoundEvent)SoundsInit.GREEN_SHELL_MOVING.get(), SoundSource.RECORDS);
            SoundsInit.playSoundLoop(this.greenShellMoving, this.m_9236_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }
}

