/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import java.util.Map;
import me.jesuismister.cubicracers.config.KartItemConfig;
import me.jesuismister.cubicracers.entity.custom.ItemKartAbstract;
import me.jesuismister.cubicracers.entity.custom.Kart;
import me.jesuismister.cubicracers.init.ItemInit;
import me.jesuismister.cubicracers.init.KartItemsInit;
import me.jesuismister.cubicracers.network.Network;
import me.jesuismister.cubicracers.network.message.ItemToClientMessage;
import me.jesuismister.cubicracers.util.ClientRandom;
import me.jesuismister.cubicracers.util.ClientUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemBox
extends ItemKartAbstract
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String TEXTURE = "textures/entity/item_box.png";
    public static final String MODEL = "geo/item_box.geo.json";
    public static final String ANIMATION = "animations/item_box.animation.json";
    public static final float HITBOX_X = 1.0f;
    public static final float HITBOX_Y = 2.0f;
    private static final double BANANA_DROP_RATE = 20.0;
    private static final double GREEN_SHELL_DROP_RATE = 50.0;
    private static final double MUSHROOM_DROP_RATE = 65.0;
    private static final double FAKE_BOX_DROP_RATE = 75.0;
    private static final double BOMB_OMB_DROP_RATE = 85.0;
    private static final double STAR_DROP_RATE = 90.0;
    private static final double THUNDER_DROP_RATE = 95.0;
    private static final double KLAXON_DROP_RATE = 100.0;
    private static final int TICK_TO_GET_BACK_ITEM = 80;
    public static final EntityDataAccessor<Boolean> hasItem = SynchedEntityData.m_135353_(ItemBox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> tickDisabled = SynchedEntityData.m_135353_(ItemBox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ItemBox(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public ItemBox(Level level, double x, double y, double z) {
        this((EntityType)KartItemsInit.ITEM_BOX.get(), level);
        this.f_19854_ = Math.floor(x) + 0.5;
        this.f_19855_ = y;
        this.f_19856_ = Math.floor(z) + 0.5;
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getHasItem()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("box_on", Animation.LoopType.LOOP));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("box_off", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(hasItem, (Object)true);
        this.f_19804_.m_135372_(tickDisabled, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        BlockState state = Blocks.f_50058_.m_49966_();
        if (this.getHasItem()) {
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.5));
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof Kart)) continue;
                Kart kart = (Kart)entity;
                if (this.m_9236_().m_5776_() || !this.giveRandomItem(kart)) continue;
                this.setHasItem(false);
                this.setTickDisabled(0);
                ClientUtil.spawnParticleForAll(this.m_9236_(), 20.0, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), true, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 0.6f, 0.0f, 0.6f, 0.8f, 40);
                break;
            }
        }
        if (!this.getHasItem()) {
            if (this.getTickDisabled() > 80) {
                this.setHasItem(true);
            }
            this.setTickDisabled(this.getTickDisabled() + 1);
        }
    }

    public boolean giveRandomItem(Kart kart) {
        if (kart.m_146895_() == null || !(kart.m_146895_() instanceof Player)) {
            return false;
        }
        if (kart.getKartItem().equals("None")) {
            kart.setKartItem(this.getRandomItem());
        }
        ServerPlayer player = (ServerPlayer)kart.m_146895_();
        Network.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ItemToClientMessage(kart.getKartItem()));
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ItemInit.ITEM_BOX_SPAWN_ITEM.get());
    }

    @Override
    public boolean m_6469_(DamageSource damage, float p_19947_) {
        Entity entity = damage.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_146895_() == null) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                if (!player.m_7500_() && !this.m_9236_().m_5776_()) {
                    Item spawn_item = (Item)ItemInit.ITEM_BOX_SPAWN_ITEM.get();
                    player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)spawn_item)));
                }
                return true;
            }
        }
        return false;
    }

    private String getRandomItem() {
        int max = 0;
        for (ForgeConfigSpec.DoubleValue v : KartItemConfig.ITEMS_DROP_RATES.values()) {
            max = (int)((double)max + (Double)v.get());
        }
        int rand = ClientRandom.nextInt(max);
        int temp = 0;
        for (Map.Entry<String, ForgeConfigSpec.DoubleValue> v : KartItemConfig.ITEMS_DROP_RATES.entrySet()) {
            if (rand > (temp = (int)((double)temp + (Double)v.getValue().get()))) continue;
            return v.getKey();
        }
        return "None";
    }

    public boolean getHasItem() {
        return (Boolean)this.f_19804_.m_135370_(hasItem);
    }

    public void setHasItem(boolean value) {
        this.f_19804_.m_135381_(hasItem, (Object)value);
    }

    public int getTickDisabled() {
        return (Integer)this.f_19804_.m_135370_(tickDisabled);
    }

    public void setTickDisabled(int value) {
        this.f_19804_.m_135381_(tickDisabled, (Object)value);
    }
}

