/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import me.jesuismister.cubicracers.entity.custom.Kart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class ItemKartAbstract
extends Entity {
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(ItemKartAbstract.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> isPropulsing = SynchedEntityData.m_135353_(ItemKartAbstract.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float propulsionY = -1.0f;

    public ItemKartAbstract(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(isPropulsing, (Object)false);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_20068_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_7341_(@NotNull Entity rider) {
        return false;
    }

    protected void m_7378_(@NotNull CompoundTag p_20052_) {
    }

    protected void m_7380_(@NotNull CompoundTag p_20139_) {
    }

    public boolean m_6469_(DamageSource damage, float p_19947_) {
        Player player;
        Entity entity = damage.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_20202_() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return false;
    }

    public boolean getIsPropulsing() {
        return (Boolean)this.f_19804_.m_135370_(isPropulsing);
    }

    public void setIsPropulsing(boolean value) {
        this.f_19804_.m_135381_(isPropulsing, (Object)value);
    }

    public void setSpeed(float new_speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(new_speed));
    }

    public static void spawnItemFront(Kart kart, ItemKartAbstract item) {
        if (kart.m_9236_() != null) {
            double angle = Math.toRadians(kart.m_146908_());
            item.m_6034_(kart.m_20185_() + -Math.sin(angle) * (double)Kart.HITBOX_X * 2.0, kart.m_20186_() + 0.2, kart.m_20189_() + Math.cos(angle) * (double)Kart.HITBOX_X * 2.0);
            item.m_146922_(kart.m_146908_());
            item.setIsPropulsing(true);
            kart.m_9236_().m_7967_((Entity)item);
        }
    }

    public static void spawnItemBack(Kart kart, ItemKartAbstract item) {
        if (kart.m_9236_() != null) {
            double angle = Math.toRadians(kart.m_146908_());
            item.m_6034_(kart.m_20185_() + Math.sin(angle) * (double)Kart.HITBOX_X * 1.5, kart.m_20186_(), kart.m_20189_() + -Math.cos(angle) * (double)Kart.HITBOX_X * 1.5);
            item.m_146922_(kart.m_146908_() + 180.0f);
            kart.m_9236_().m_7967_((Entity)item);
        }
    }

    public void stun(float range, String motif) {
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)range));
        for (Entity entity : nearbyEntities) {
            Kart kart;
            if (!(entity instanceof Kart) || !(kart = (Kart)entity).getCanMove()) continue;
            Kart.stunKart(kart, motif);
        }
    }
}

