/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.entity.custom;

import java.util.List;
import me.jesuismister.cubicracers.block.HollowRoadBlock;
import me.jesuismister.cubicracers.block.KartController;
import me.jesuismister.cubicracers.config.KartConfig;
import me.jesuismister.cubicracers.config.RoadBlockConfig;
import me.jesuismister.cubicracers.entity.custom.KartAbstract;
import me.jesuismister.cubicracers.init.BlockInit;
import me.jesuismister.cubicracers.init.ItemInit;
import me.jesuismister.cubicracers.init.KartInit;
import me.jesuismister.cubicracers.init.SoundsInit;
import me.jesuismister.cubicracers.network.Network;
import me.jesuismister.cubicracers.network.message.KartPositionMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.BananaUseMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.BobOmbUseMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.FakeBoxUseMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.GreenShellUseMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.KlaxonUseMessage;
import me.jesuismister.cubicracers.network.message.itemsKart.use.ThunderUseMessage;
import me.jesuismister.cubicracers.sounds.SoundEngineIdle;
import me.jesuismister.cubicracers.sounds.SoundEngineMax;
import me.jesuismister.cubicracers.sounds.SoundKartDrifting;
import me.jesuismister.cubicracers.sounds.SoundKartGliding;
import me.jesuismister.cubicracers.sounds.SoundKartOffRoad;
import me.jesuismister.cubicracers.sounds.SoundStarMode;
import me.jesuismister.cubicracers.tags.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber(modid="cubicracers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Kart
extends KartAbstract
implements GeoEntity {
    public int id;
    public static float HITBOX_X;
    public static float HITBOX_Y;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final String TEXTURE;
    public final String MODEL;
    public final String ANIMATION;
    public float MAX_SPEED;
    public float DELTA_SPEED;
    public float ACCELERATION_BOOST;
    public float BOOST;
    public float MANIABILITE_COEEF;
    public final float PLAYER_POS_Y;
    public float speedToShow = 0.0f;
    public String stunMotif = "None";
    public boolean boostFini = true;
    @OnlyIn(value=Dist.CLIENT)
    private SoundEngineIdle engineIdleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundEngineMax engineMaxLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundStarMode starModeLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundKartGliding kartGliding;
    @OnlyIn(value=Dist.CLIENT)
    private SoundKartDrifting kartDrifting;
    @OnlyIn(value=Dist.CLIENT)
    private SoundKartOffRoad kartOffRoad;

    public Kart(EntityType<?> entityType, Level level, int id, String texture, String model, String animation, float playerPosY, float hitboxX, float hitboxY) {
        super(entityType, level);
        this.id = id;
        this.TEXTURE = texture;
        this.MODEL = model;
        this.ANIMATION = animation;
        this.PLAYER_POS_Y = playerPosY;
        HITBOX_X = hitboxX;
        HITBOX_Y = hitboxY;
        this.m_20331_(false);
    }

    public Kart(Level level, int id, double x, double y, double z, String name, String texture, String model, String animation, float playerPosY, float hitboxX, float hitboxY) {
        this((EntityType)KartInit.KARTS.get(name).get(), level, id, texture, model, animation, playerPosY, hitboxX, hitboxY);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setKartItem("None");
    }

    protected void m_19956_(Entity player, Entity.MoveFunction position) {
        super.m_19956_(player, position);
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)this.PLAYER_POS_Y;
        double z = player.m_20189_();
        player.m_6034_(x, y, z);
    }

    @Override
    public void m_8119_() {
        Player player;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.updateSounds();
        }
        if (this.m_9236_().f_46443_) {
            this.MAX_SPEED = ((Double)KartConfig.MAX_SPEED.get(this.id).get()).floatValue();
            this.DELTA_SPEED = ((Double)KartConfig.MAX_SPEED.get(this.id).get()).floatValue();
            this.ACCELERATION_BOOST = ((Double)KartConfig.ACCELERATION_BOOST.get(this.id).get()).floatValue();
            this.BOOST = ((Double)KartConfig.BOOST.get(this.id).get()).floatValue();
            this.MANIABILITE_COEEF = ((Double)KartConfig.HANDLING.get(this.id).get()).floatValue();
        }
        if ((player = (Player)this.m_146895_()) == null) {
            this.resetBindValue();
        }
        if (this.isOnKartController()) {
            this.setSpeed(0.0f);
            return;
        }
        this.collision();
        this.isStun();
        if (!this.getCanMove()) {
            this.applyStun();
        }
        if (this.getTimeStar() > 0.0f) {
            this.setTimeStar(this.getTimeStar() - 0.1f);
        }
        if (this.getDriftTimeBoost() > 0.0f) {
            this.setDriftTimeBoost(this.getDriftTimeBoost() - 0.1f);
        }
        if (this.getTimeBoost() > 0.0f) {
            this.setTimeBoost(this.getTimeBoost() - 0.1f);
        }
        if (this.getCanMove() && this.getIsPressingKeyItem()) {
            this.useItem();
        }
        this.deltaplane(player);
        this.rotateOrDrift();
        if (this.getCanMove()) {
            this.setVectorMovment();
        }
        this.moveCamera(player);
        if (this.m_9236_().m_5776_() && player != null && player.m_20202_() != null && player.m_20202_().equals((Object)this) && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20202_() != null && Minecraft.m_91087_().f_91074_.m_20202_().equals((Object)this)) {
            Network.CHANNEL.sendToServer((Object)new KartPositionMessage(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        }
        this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().f_82479_, (double)this.calculateFallSpeed(), this.m_20184_().f_82481_));
    }

    private void resetBindValue() {
        this.setIsPressingKeyAccelerate(false);
        this.setIsPressingKeyDeccelerate(false);
        this.setIsPressingKeyFoward(false);
        this.setIsPressingKeyBackward(false);
        this.setIsPressingKeyLeft(false);
        this.setIsPressingKeyRight(false);
        this.setIsPressingKeyDelta(false);
        this.setPreviousPressingKeyDelta(false);
        this.setIsPressingKeyDrift(false);
        this.setIsPressingKeyItem(false);
    }

    private float calculateFallSpeed() {
        if (this.getDeltaOn()) {
            return -0.2f;
        }
        if (this.m_20069_()) {
            return -0.4f;
        }
        if (!this.m_20096_() && !this.getDeltaOn()) {
            return -1.2f;
        }
        return 0.0f;
    }

    private void moveCamera(Player player) {
        if (player != null) {
            player.m_146922_(this.m_146908_());
            player.m_5618_(this.m_146908_());
        }
    }

    private void setVectorMovment() {
        if (this.getTimeBoost() > 0.0f || this.getIsInvinsible() && !this.getIsPressingKeyDeccelerate()) {
            this.setSpeed(this.MAX_SPEED);
        } else if (this.getDeltaOn()) {
            this.setSpeed(this.DELTA_SPEED);
        } else if ((!this.f_19862_ || this.getSpeed() <= this.MAX_SPEED / 10.0f) && this.getIsPressingKeyAccelerate()) {
            this.setSpeed(Mth.m_14036_((float)(this.getSpeed() + this.ACCELERATION_BOOST), (float)(-this.MAX_SPEED / 2.0f), (float)this.MAX_SPEED));
        } else if (this.getIsPressingKeyDeccelerate()) {
            this.setSpeed(Mth.m_14036_((float)(this.getSpeed() - this.ACCELERATION_BOOST), (float)(-this.MAX_SPEED / 2.0f), (float)this.MAX_SPEED));
            this.resetDriftWithNoBoost();
        } else {
            this.slowDownKart();
        }
        this.setKartMovement();
    }

    private void applyStun() {
        this.resetBindValue();
        this.setDriftTimeBoost(0.0f);
        this.setTimeBoost(0.0f);
        this.setSpeed(Mth.m_14036_((float)(this.getSpeed() - this.ACCELERATION_BOOST * 1.5f), (float)0.0f, (float)this.MAX_SPEED));
        this.setKartMovement();
        this.setStunRotation(this.getStunRotation() - 12.0f);
    }

    private void useItem() {
        if (this.getKartItem().equals("Banana")) {
            Entity entity;
            if (this.m_9236_().m_5776_()) {
                Network.CHANNEL.sendToServer((Object)new BananaUseMessage(this.getIsPressingKeyForward()));
            }
            if (!this.getIsPressingKeyForward()) {
                Entity entity2;
                if (this.m_146895_() != null && (entity2 = this.m_146895_()) instanceof Player) {
                    Player player = (Player)entity2;
                    SoundsInit.playSound((SoundEvent)SoundsInit.SPAWN_ITEM_BELOW.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
                }
            } else if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof Player) {
                Player player = (Player)entity;
                SoundsInit.playSound((SoundEvent)SoundsInit.THROWING_ITEM.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
            }
        } else if (this.getKartItem().equals("Mushroom")) {
            this.setTimeBoost(5.0f);
            this.setSpeed(this.MAX_SPEED + this.BOOST);
        } else if (this.getKartItem().equals("Star")) {
            this.setTimeStar(20.0f);
            this.setStarSpeedBoost(1.5f);
            this.setIsInvinsible(true);
            this.setSpeed(this.MAX_SPEED * this.getStarSpeedBoost());
        } else if (this.getKartItem().equals("Thunder")) {
            if (this.m_9236_().m_5776_()) {
                Network.CHANNEL.sendToServer((Object)new ThunderUseMessage());
            }
        } else if (this.getKartItem().equals("Klaxon")) {
            if (this.m_9236_().m_5776_()) {
                Network.CHANNEL.sendToServer((Object)new KlaxonUseMessage(this.m_20185_(), this.m_20186_(), this.m_20189_()));
            }
        } else if (this.getKartItem().equals("Bob_omb")) {
            Entity entity;
            if (this.m_9236_().m_5776_()) {
                Network.CHANNEL.sendToServer((Object)new BobOmbUseMessage(this.getIsPressingKeyForward()));
            }
            if (!this.getIsPressingKeyForward()) {
                Entity entity3;
                if (this.m_146895_() != null && (entity3 = this.m_146895_()) instanceof Player) {
                    Player player = (Player)entity3;
                    SoundsInit.playSound((SoundEvent)SoundsInit.SPAWN_ITEM_BELOW.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
                }
            } else if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof Player) {
                Player player = (Player)entity;
                SoundsInit.playSound((SoundEvent)SoundsInit.THROWING_ITEM.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
            }
        } else if (this.getKartItem().equals("Fake_box")) {
            Entity entity;
            if (this.m_9236_().m_5776_()) {
                Network.CHANNEL.sendToServer((Object)new FakeBoxUseMessage(this.getIsPressingKeyForward()));
            }
            if (!this.getIsPressingKeyForward()) {
                Entity entity4;
                if (this.m_146895_() != null && (entity4 = this.m_146895_()) instanceof Player) {
                    Player player = (Player)entity4;
                    SoundsInit.playSound((SoundEvent)SoundsInit.SPAWN_ITEM_BELOW.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
                }
            } else if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof Player) {
                Player player = (Player)entity;
                SoundsInit.playSound((SoundEvent)SoundsInit.THROWING_ITEM.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
            }
        } else if (this.getKartItem().equals("Green_shell") && this.m_9236_().m_5776_()) {
            Network.CHANNEL.sendToServer((Object)new GreenShellUseMessage(this.getIsPressingKeyBackward()));
        }
        this.setKartItem("None");
    }

    private void rotateOrDrift() {
        if (this.getSpeed() != 0.0f && this.getCanMove()) {
            if ((this.isOnRoadBlock() || this.getTimeBoost() > 0.0f || this.getIsInvinsible()) && this.getIsPressingKeyDrift() && !this.f_19862_ && !this.getDeltaOn() && (double)this.getSpeed() > (double)this.MAX_SPEED * 0.25) {
                if (this.getDriftingTime() == 0.0f) {
                    if (this.getIsPressingKeyLeft() && !this.getIsPressingKeyRight()) {
                        this.setDrifting("Left");
                    } else if (this.getIsPressingKeyRight() && !this.getIsPressingKeyLeft()) {
                        this.setDrifting("Right");
                    }
                }
                if (this.getIsDrifting() && this.getDriftingSens().equals("Left")) {
                    if (this.getIsPressingKeyLeft() && !this.getIsPressingKeyRight()) {
                        if (this.getDriftingTime() < 3.0f) {
                            this.setDriftingTime(this.getDriftingTime() + 0.06f);
                        }
                        this.m_146922_(this.m_146908_() - this.MANIABILITE_COEEF * 1.5f);
                    } else if (this.getIsPressingKeyRight() && !this.getIsPressingKeyLeft()) {
                        this.m_146922_(this.m_146908_() - this.MANIABILITE_COEEF * 0.45000002f);
                    } else {
                        if (this.getDriftingTime() < 3.0f) {
                            this.setDriftingTime(this.getDriftingTime() + 0.02f);
                        }
                        this.m_146922_(this.m_146908_() - this.MANIABILITE_COEEF * 1.125f);
                    }
                } else if (this.getIsDrifting() && this.getDriftingSens().equals("Right")) {
                    if (this.getIsPressingKeyAccelerate() && this.getIsPressingKeyRight() && !this.getIsPressingKeyLeft()) {
                        if (this.getDriftingTime() < 3.0f) {
                            this.setDriftingTime(this.getDriftingTime() + 0.06f);
                        }
                        this.m_146922_(this.m_146908_() + this.MANIABILITE_COEEF * 1.5f);
                    } else if (this.getIsPressingKeyLeft() && !this.getIsPressingKeyRight()) {
                        this.m_146922_(this.m_146908_() + this.MANIABILITE_COEEF * 0.75f);
                    } else {
                        if (this.getDriftingTime() < 3.0f) {
                            this.setDriftingTime(this.getDriftingTime() + 0.02f);
                        }
                        this.m_146922_(this.m_146908_() + this.MANIABILITE_COEEF * 1.125f);
                    }
                }
            } else {
                this.resetDrift();
                if (this.getIsPressingKeyLeft() && !this.getIsPressingKeyRight()) {
                    if (this.getSpeed() > 0.0f) {
                        this.m_146922_(this.m_146908_() - this.MANIABILITE_COEEF);
                    } else {
                        this.m_146922_(this.m_146908_() + this.MANIABILITE_COEEF);
                    }
                } else if (this.getIsPressingKeyRight() && !this.getIsPressingKeyLeft()) {
                    if (this.getSpeed() > 0.0f) {
                        this.m_146922_(this.m_146908_() + this.MANIABILITE_COEEF);
                    } else {
                        this.m_146922_(this.m_146908_() - this.MANIABILITE_COEEF);
                    }
                }
            }
        } else {
            this.resetDrift();
        }
    }

    private void deltaplane(Player player) {
        if (player == null) {
            this.setDeltaOn(false);
            return;
        }
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        BlockPos blockPos = new BlockPos((int)playerX, (int)playerY - 1, (int)playerZ);
        BlockState blockState = this.m_20193_().m_8055_(blockPos);
        if (!this.getDeltaOn() && blockState.m_60795_() && this.getIsPressingKeyDelta() && !this.getPreviousPressingKeyDelta()) {
            this.setDeltaOn(true);
        } else if (this.getDeltaOn() && (this.getIsPressingKeyDelta() && !this.getPreviousPressingKeyDelta() || !blockState.m_60795_())) {
            this.setDeltaOn(false);
        }
        this.setPreviousPressingKeyDelta(this.getIsPressingKeyDelta());
    }

    private void isStun() {
        if (this.getStunRotation() <= 0.0f) {
            this.setCanMove(true);
            this.setStunRotation(0.0f);
        }
    }

    private boolean isOnKartController() {
        int blockX = (int)Math.floor(this.m_20185_());
        int blockY = (int)Math.floor(this.m_20186_()) - 1;
        int blockZ = (int)Math.floor(this.m_20189_());
        BlockState blockState = this.m_20193_().m_8055_(new BlockPos(blockX, blockY, blockZ));
        if (blockState.m_60713_((Block)BlockInit.KART_CONTROLLER.get()) && ((Boolean)blockState.m_61143_((Property)KartController.LIT)).booleanValue()) {
            this.setSpeed(0.0f);
            if (((Direction)blockState.m_61143_((Property)KartController.FACING)).m_122424_().equals((Object)Direction.NORTH)) {
                this.m_146922_(180.0f);
            } else if (((Direction)blockState.m_61143_((Property)KartController.FACING)).m_122424_().equals((Object)Direction.WEST)) {
                this.m_146922_(90.0f);
            } else if (((Direction)blockState.m_61143_((Property)KartController.FACING)).m_122424_().equals((Object)Direction.EAST)) {
                this.m_146922_(-90.0f);
            } else if (((Direction)blockState.m_61143_((Property)KartController.FACING)).m_122424_().equals((Object)Direction.SOUTH)) {
                this.m_146922_(0.0f);
            }
            this.m_6034_((double)blockX + 0.5, (double)blockY + 1.0, (double)blockZ + 0.5);
            return true;
        }
        return false;
    }

    public boolean isOnRoadBlock() {
        if (!((Boolean)RoadBlockConfig.ROAD_BLOCK_REQUIRE.get()).booleanValue()) {
            return true;
        }
        int blockX = (int)Math.floor(this.m_20185_());
        int blockY = (int)Math.floor(this.m_20186_());
        int blockZ = (int)Math.floor(this.m_20189_());
        return this.m_20193_().m_8055_(new BlockPos(blockX, blockY - 1, blockZ)).m_204336_(ModTags.Blocks.ROAD_BLOCK_TAG) || this.m_20193_().m_8055_(new BlockPos(blockX, blockY, blockZ)).m_60734_() instanceof HollowRoadBlock;
    }

    private void collision() {
        if (this.f_19862_) {
            this.setDriftingTime(0.0f);
        }
        if (this.getIsInvinsible()) {
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.5));
            for (Entity entity : nearbyEntities) {
                Kart kart;
                if (!(entity instanceof Kart) || !(kart = (Kart)entity).getCanMove()) continue;
                Kart.stunKart(kart, "Star");
            }
        }
        if (this.getIsInvinsible() && this.getTimeStar() <= 0.0f) {
            this.setIsInvinsible(false);
            this.setStarSpeedBoost(1.0f);
        }
    }

    public void setKartMovement() {
        double angle = Math.toRadians(this.m_146908_());
        if (!this.getIsInvinsible() && this.getSpeed() > 0.0f && (this.getDriftTimeBoost() > 0.0f || this.getTimeBoost() > 0.0f)) {
            this.spawnBoostParticules(ParticleTypes.f_123744_);
        }
        float clamped_speed = this.getSpeed();
        if (this.getDriftTimeBoost() > 0.0f || this.getTimeBoost() > 0.0f) {
            clamped_speed = Mth.m_14036_((float)(this.getSpeed() + this.BOOST), (float)0.0f, (float)(this.MAX_SPEED + this.BOOST));
        }
        if (this.getIsInvinsible() && !this.getIsPressingKeyDeccelerate()) {
            clamped_speed *= this.getStarSpeedBoost();
        }
        if (!(this.isOnRoadBlock() || this.getIsInvinsible() && !(this.getTimeBoost() <= 0.0f))) {
            this.setSpeed(Mth.m_14036_((float)this.getSpeed(), (float)(-this.MAX_SPEED / 2.0f), (float)(this.MAX_SPEED / 2.0f)));
        }
        double x = Math.sin(-angle) * (double)clamped_speed;
        double z = Math.cos(-angle) * (double)clamped_speed;
        Vec3 vec3 = new Vec3(x, 0.0, z);
        this.speedToShow = clamped_speed;
        this.m_20256_(vec3);
    }

    public void slowDownKart() {
        double z;
        double x;
        if (this.getSpeed() > -0.075f && this.getSpeed() < 0.075f) {
            this.setSpeed(0.0f);
            x = 0.0;
            z = 0.0;
        } else {
            double angle = Math.toRadians(this.m_146908_());
            this.setSpeed(this.getSpeed() / 1.05f);
            float clamped_speed = Mth.m_14036_((float)this.getSpeed(), (float)(-this.MAX_SPEED / 2.0f), (float)this.MAX_SPEED);
            this.setSpeed(clamped_speed);
            x = Math.sin(-angle) * (double)clamped_speed;
            if (this.f_19862_) {
                x *= (double)0.85f;
            }
            z = Math.cos(-angle) * (double)clamped_speed;
            if (this.f_19862_) {
                z *= (double)0.85f;
            }
        }
        Vec3 vec3 = new Vec3(x, 0.0, z);
        this.m_20256_(vec3);
    }

    public void resetDrift() {
        if (this.getDriftingTime() != 0.0f) {
            this.setDriftTimeBoost((float)Math.floor(this.getDriftingTime()));
        }
        this.setIsDrifting(false);
        this.setDriftingTime(0.0f);
        this.setDriftingSens("None");
    }

    public void resetDriftWithNoBoost() {
        this.setIsDrifting(false);
        this.setDriftingTime(0.0f);
        this.setDriftingSens("None");
    }

    public void setDrifting(String sens) {
        this.setIsDrifting(true);
        this.setDriftingTime(0.1f);
        this.setDriftingSens(sens);
    }

    public void spawnBoostParticules(SimpleParticleType particle) {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        float yaw = this.m_146908_();
        double motionX = -Math.sin(Math.toRadians(yaw));
        double motionZ = Math.cos(Math.toRadians(yaw));
        this.spawnParticules(particle, 0.25 * Math.cos(Math.toRadians(yaw)), 0.0, 0.25 * Math.sin(Math.toRadians(yaw)), motionX * 0.5, 0.0, motionZ * 0.5);
    }

    public void spawnParticules(SimpleParticleType particle, double x1, double y1, double z1, double x2, double y2, double z2) {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        minecraft.f_91061_.m_107370_((ParticleOptions)particle, x - x1, y - y1, z - z1, x2, y2, z2);
        minecraft.f_91061_.m_107370_((ParticleOptions)particle, x + x1, y + y1, z + z1, x2, y2, z2);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ItemInit.KARTS_SPAWN_ITEM.get(this.id).get());
    }

    public boolean m_6469_(DamageSource damage, float p_19947_) {
        Entity entity = damage.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_146895_() == null) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                if (!player.m_7500_() && !this.m_9236_().m_5776_()) {
                    Item spawn_item = (Item)ItemInit.KARTS_SPAWN_ITEM.get(this.id).get();
                    player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)spawn_item)));
                }
                return true;
            }
        }
        return false;
    }

    public static void stunKart(Kart kart, String motif) {
        if (kart.getIsInvinsible()) {
            return;
        }
        kart.stunMotif = motif;
        kart.setCanMove(false);
        kart.setStunRotation(720.0f);
        kart.setDeltaOn(false);
        kart.setDriftTimeBoost(0.0f);
        kart.resetDrift();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_engine", 0, this::predicate_engine)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_propeller", 0, this::predicate_propeller)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_glider", 0, this::predicade_glider)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_drift", 0, this::predicate_drift)});
    }

    private <T extends GeoAnimatable> PlayState predicate_engine(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("engine", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate_propeller(AnimationState<T> tAnimationState) {
        if (this.m_20069_()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("propeller_on", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("propeller_off", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicade_glider(AnimationState<T> tAnimationState) {
        if (this.getDeltaOn()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("glider_on", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("glider_off", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate_drift(AnimationState<T> tAnimationState) {
        if (this.getDriftingTime() >= 3.0f) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("drift_v", Animation.LoopType.LOOP));
        } else if (this.getDriftingTime() >= 2.0f) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("drift_o", Animation.LoopType.LOOP));
        } else if (this.getDriftingTime() >= 1.0f) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("drift_b", Animation.LoopType.LOOP));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("drift_off", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSounds() {
        Player player;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.getIsInvinsible()) {
            if (!this.isSoundPlaying((SoundInstance)this.starModeLoop)) {
                this.starModeLoop = new SoundStarMode(this, (SoundEvent)SoundsInit.STAR_MODE.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.starModeLoop, this.m_9236_());
            }
        } else if (this.getDeltaOn()) {
            if (!this.isSoundPlaying((SoundInstance)this.kartGliding)) {
                this.kartGliding = new SoundKartGliding(this, (SoundEvent)SoundsInit.KART_GLIDING.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.kartGliding, this.m_9236_());
            }
        } else if (this.getSpeed() > -this.MAX_SPEED * 0.2f && this.getSpeed() < this.MAX_SPEED * 0.2f) {
            if (!this.isSoundPlaying((SoundInstance)this.engineIdleLoop)) {
                this.engineIdleLoop = new SoundEngineIdle(this, (SoundEvent)SoundsInit.ENGINE_IDLE.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.engineIdleLoop, this.m_9236_());
            }
        } else if (!this.isOnRoadBlock()) {
            if (!this.isSoundPlaying((SoundInstance)this.kartOffRoad)) {
                this.kartOffRoad = new SoundKartOffRoad(this, (SoundEvent)SoundsInit.KART_OFF_ROAD.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.kartOffRoad, this.m_9236_());
            }
        } else if (this.getSpeed() != 0.0f) {
            if (!this.isSoundPlaying((SoundInstance)this.engineMaxLoop)) {
                this.engineMaxLoop = new SoundEngineMax(this, (SoundEvent)SoundsInit.ENGINE_MAX.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.engineMaxLoop, this.m_9236_());
            }
            if (this.getIsDrifting() && !this.isSoundPlaying((SoundInstance)this.kartDrifting)) {
                this.kartDrifting = new SoundKartDrifting(this, (SoundEvent)SoundsInit.KART_DRIFTING.get(), SoundSource.RECORDS);
                SoundsInit.playSoundLoop(this.kartDrifting, this.m_9236_());
            }
        }
        if (this.boostFini && (this.getTimeBoost() > 0.0f || this.getDriftTimeBoost() > 0.0f)) {
            this.boostFini = false;
            if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof Player) {
                player = (Player)entity;
                SoundsInit.playSound((SoundEvent)SoundsInit.KART_SPEED_BOOST.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 1.0f);
            }
        } else if (!this.boostFini && this.getTimeBoost() <= 0.0f && this.getDriftTimeBoost() <= 0.0f) {
            this.boostFini = true;
        }
        if (!this.stunMotif.equals("None")) {
            if (this.stunMotif.equals("Green_shell")) {
                Entity entity2;
                if (this.m_146895_() != null && (entity2 = this.m_146895_()) instanceof Player) {
                    Player player2 = (Player)entity2;
                    SoundsInit.playSound((SoundEvent)SoundsInit.GREEN_SHELL_HIT_KART.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player2, SoundSource.RECORDS, 1.0f);
                }
            } else if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof Player) {
                player = (Player)entity;
                SoundsInit.playSound((SoundEvent)SoundsInit.BANANA_HIT_KART.get(), this.m_9236_(), new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), player, SoundSource.RECORDS, 0.7f);
            }
            this.stunMotif = "None";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }
}

