/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.init;

import java.util.function.Supplier;
import me.jesuismister.cubicracers.block.BoosterBlock;
import me.jesuismister.cubicracers.block.HollowRoadBlock;
import me.jesuismister.cubicracers.block.KartController;
import me.jesuismister.cubicracers.block.RoadBlock;
import me.jesuismister.cubicracers.init.ItemInit;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cubicracers");
    public static final RegistryObject<Block> BOOSTER = BlockInit.registerBlock("booster", () -> new BoosterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50450_).m_60953_(p_152684_ -> 3).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> ROAD_BLOCK = BlockInit.registerBlock("road_block", () -> new RoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistryObject<Block> ROAD_BLOCK_DIRT = BlockInit.registerBlock("road_block_dirt", () -> new RoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_)));
    public static final RegistryObject<Block> ROAD_BLOCK_SAND = BlockInit.registerBlock("road_block_sand", () -> new RoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
    public static final RegistryObject<Block> ROAD_BLOCK_SNOW = BlockInit.registerBlock("road_block_snow", () -> new RoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50127_)));
    public static final RegistryObject<Block> STARTING_BLOCK = BlockInit.registerBlock("starting_block", () -> new RoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistryObject<Block> KART_CONTROLLER = BlockInit.registerBlock("kart_controller", () -> new KartController(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50532_)));
    public static final RegistryObject<Block> HOLLOW_ROAD_BLOCK = BlockInit.registerBlock("hollow_road_block", () -> new HollowRoadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50374_).m_60918_(SoundType.f_56742_)));

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }
}

