/*
 * Decompiled with CFR 0.152.
 */
package me.jesuismister.cubicracers.init;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SoundsInit {
    public static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"cubicracers");
    public static RegistryObject<SoundEvent> ENGINE_IDLE = SoundsInit.addSound("engine_idle");
    public static RegistryObject<SoundEvent> ENGINE_MAX = SoundsInit.addSound("engine_max");
    public static RegistryObject<SoundEvent> STAR_MODE = SoundsInit.addSound("kart_star_mode");
    public static RegistryObject<SoundEvent> KART_GLIDING = SoundsInit.addSound("kart_gliding");
    public static RegistryObject<SoundEvent> KART_DRIFTING = SoundsInit.addSound("kart_drifting");
    public static RegistryObject<SoundEvent> KART_OFF_ROAD = SoundsInit.addSound("kart_off_road");
    public static RegistryObject<SoundEvent> KART_SPEED_BOOST = SoundsInit.addSound("kart_speed_boost");
    public static RegistryObject<SoundEvent> BANANA_HIT_KART = SoundsInit.addSound("banana_hit_kart");
    public static RegistryObject<SoundEvent> BOB_OMB_EXPLOSION = SoundsInit.addSound("bob_omb_explosion");
    public static RegistryObject<SoundEvent> GREEN_SHELL_MOVING = SoundsInit.addSound("green_shell_moving");
    public static RegistryObject<SoundEvent> GREEN_SHELL_HIT_KART = SoundsInit.addSound("green_shell_hit_kart");
    public static RegistryObject<SoundEvent> SPAWN_ITEM_BELOW = SoundsInit.addSound("spawn_item_below");
    public static RegistryObject<SoundEvent> THROWING_ITEM = SoundsInit.addSound("throwing_item");
    public static RegistryObject<SoundEvent> ITEM_BOX_CONSUME = SoundsInit.addSound("item_box_consume");
    public static RegistryObject<SoundEvent> KLAXON = SoundsInit.addSound("klaxon");

    public static RegistryObject<SoundEvent> addSound(String soundName) {
        return SOUND_REGISTER.register(soundName, () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("cubicracers", soundName)));
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        SoundsInit.playSound(evt, world, pos, entity, category, volume, 0.5f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.m_5594_(entity, pos, evt, category, volume, pitch);
        } else if (!world.f_46443_) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, evt, category, volume, pitch);
        }
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category) {
        SoundsInit.playSound(evt, world, pos, entity, category, 0.15f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(AbstractTickableSoundInstance loop, Level world) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)loop);
        }
    }
}

