/*
 * Decompiled with CFR 0.152.
 */
package freakmobs.network;

import freakmobs.FreakMobsMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FreakMobsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        FreakMobsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        FreakMobsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Butcher_kill = message.data.Butcher_kill;
                    variables.Defield_Creefly = message.data.Defield_Creefly;
                    variables.shadow_spawn = message.data.shadow_spawn;
                    variables.shadowy = message.data.shadowy;
                    variables.tf2 = message.data.tf2;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Butcher_kill = 0.0;
        public double Defield_Creefly = 0.0;
        public double shadow_spawn = 0.0;
        public double shadowy = 0.0;
        public double tf2 = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Butcher_kill", this.Butcher_kill);
            nbt.m_128347_("Defield_Creefly", this.Defield_Creefly);
            nbt.m_128347_("shadow_spawn", this.shadow_spawn);
            nbt.m_128347_("shadowy", this.shadowy);
            nbt.m_128347_("tf2", this.tf2);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Butcher_kill = nbt.m_128459_("Butcher_kill");
            this.Defield_Creefly = nbt.m_128459_("Defield_Creefly");
            this.shadow_spawn = nbt.m_128459_("shadow_spawn");
            this.shadowy = nbt.m_128459_("shadowy");
            this.tf2 = nbt.m_128459_("tf2");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("freak_mobs", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "freak_mobs_mapvars";
        public double step1_nether_portal = 0.0;
        public double step2_nether_fortress = 0.0;
        public double step3_dragon_kill = 0.0;
        public double walkers_spawn = 0.0;
        public double walkers_spawn_barrier = 4.0;
        public double walkers_legs_spawn = 0.0;
        public double walkers_legs_spawn_barrier = 4.0;
        public double zombie_warrior_spawn = 0.0;
        public double skeleton_warrior_spawn = 0.0;
        public double bomber_spawn = 0.0;
        public double mimic_spawn = 0.0;
        public double gargoyle_spawn = 0.0;
        public double pigbug_spawn = 0.0;
        public double reanimator_spawn = 0.0;
        public double hellburner_spawn = 0.0;
        public double fire_sentry_spawn = 0.0;
        public double soul_spawn = 0.0;
        public double wither_spawn = 0.0;
        public double boatmen_spawn = 0.0;
        public double gitler_spawn = 0.0;
        public double jumper_spawn = 0.0;
        public double creefly_spawn = 0.0;
        public double flasher_spawn = 0.0;
        public double frogger_spawn = 0.0;
        public double golem_spawn = 0.0;
        public double guard_spawn = 0.0;
        public double vacuum_spawn = 0.0;
        public double aether_spawn = 0.0;
        public double eye_spawn = 0.0;
        public double titan_spawn = 0.0;
        public double aberration_spawn = 0.0;
        public double shadows_spawn = 0.0;
        public double book_spawn = 0.0;
        public double enderguard_spawn = 0.0;
        public double enderstrider_spawn = 0.0;
        public double enderclinch = 0.0;
        public double imitator = 0.0;
        public double puj_spawn = 0.0;
        public double I_don_t_respect_devils = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.step1_nether_portal = nbt.m_128459_("step1_nether_portal");
            this.step2_nether_fortress = nbt.m_128459_("step2_nether_fortress");
            this.step3_dragon_kill = nbt.m_128459_("step3_dragon_kill");
            this.walkers_spawn = nbt.m_128459_("walkers_spawn");
            this.walkers_spawn_barrier = nbt.m_128459_("walkers_spawn_barrier");
            this.walkers_legs_spawn = nbt.m_128459_("walkers_legs_spawn");
            this.walkers_legs_spawn_barrier = nbt.m_128459_("walkers_legs_spawn_barrier");
            this.zombie_warrior_spawn = nbt.m_128459_("zombie_warrior_spawn");
            this.skeleton_warrior_spawn = nbt.m_128459_("skeleton_warrior_spawn");
            this.bomber_spawn = nbt.m_128459_("bomber_spawn");
            this.mimic_spawn = nbt.m_128459_("mimic_spawn");
            this.gargoyle_spawn = nbt.m_128459_("gargoyle_spawn");
            this.pigbug_spawn = nbt.m_128459_("pigbug_spawn");
            this.reanimator_spawn = nbt.m_128459_("reanimator_spawn");
            this.hellburner_spawn = nbt.m_128459_("hellburner_spawn");
            this.fire_sentry_spawn = nbt.m_128459_("fire_sentry_spawn");
            this.soul_spawn = nbt.m_128459_("soul_spawn");
            this.wither_spawn = nbt.m_128459_("wither_spawn");
            this.boatmen_spawn = nbt.m_128459_("boatmen_spawn");
            this.gitler_spawn = nbt.m_128459_("gitler_spawn");
            this.jumper_spawn = nbt.m_128459_("jumper_spawn");
            this.creefly_spawn = nbt.m_128459_("creefly_spawn");
            this.flasher_spawn = nbt.m_128459_("flasher_spawn");
            this.frogger_spawn = nbt.m_128459_("frogger_spawn");
            this.golem_spawn = nbt.m_128459_("golem_spawn");
            this.guard_spawn = nbt.m_128459_("guard_spawn");
            this.vacuum_spawn = nbt.m_128459_("vacuum_spawn");
            this.aether_spawn = nbt.m_128459_("aether_spawn");
            this.eye_spawn = nbt.m_128459_("eye_spawn");
            this.titan_spawn = nbt.m_128459_("titan_spawn");
            this.aberration_spawn = nbt.m_128459_("aberration_spawn");
            this.shadows_spawn = nbt.m_128459_("shadows_spawn");
            this.book_spawn = nbt.m_128459_("book_spawn");
            this.enderguard_spawn = nbt.m_128459_("enderguard_spawn");
            this.enderstrider_spawn = nbt.m_128459_("enderstrider_spawn");
            this.enderclinch = nbt.m_128459_("enderclinch");
            this.imitator = nbt.m_128459_("imitator");
            this.puj_spawn = nbt.m_128459_("puj_spawn");
            this.I_don_t_respect_devils = nbt.m_128459_("I_don_t_respect_devils");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("step1_nether_portal", this.step1_nether_portal);
            nbt.m_128347_("step2_nether_fortress", this.step2_nether_fortress);
            nbt.m_128347_("step3_dragon_kill", this.step3_dragon_kill);
            nbt.m_128347_("walkers_spawn", this.walkers_spawn);
            nbt.m_128347_("walkers_spawn_barrier", this.walkers_spawn_barrier);
            nbt.m_128347_("walkers_legs_spawn", this.walkers_legs_spawn);
            nbt.m_128347_("walkers_legs_spawn_barrier", this.walkers_legs_spawn_barrier);
            nbt.m_128347_("zombie_warrior_spawn", this.zombie_warrior_spawn);
            nbt.m_128347_("skeleton_warrior_spawn", this.skeleton_warrior_spawn);
            nbt.m_128347_("bomber_spawn", this.bomber_spawn);
            nbt.m_128347_("mimic_spawn", this.mimic_spawn);
            nbt.m_128347_("gargoyle_spawn", this.gargoyle_spawn);
            nbt.m_128347_("pigbug_spawn", this.pigbug_spawn);
            nbt.m_128347_("reanimator_spawn", this.reanimator_spawn);
            nbt.m_128347_("hellburner_spawn", this.hellburner_spawn);
            nbt.m_128347_("fire_sentry_spawn", this.fire_sentry_spawn);
            nbt.m_128347_("soul_spawn", this.soul_spawn);
            nbt.m_128347_("wither_spawn", this.wither_spawn);
            nbt.m_128347_("boatmen_spawn", this.boatmen_spawn);
            nbt.m_128347_("gitler_spawn", this.gitler_spawn);
            nbt.m_128347_("jumper_spawn", this.jumper_spawn);
            nbt.m_128347_("creefly_spawn", this.creefly_spawn);
            nbt.m_128347_("flasher_spawn", this.flasher_spawn);
            nbt.m_128347_("frogger_spawn", this.frogger_spawn);
            nbt.m_128347_("golem_spawn", this.golem_spawn);
            nbt.m_128347_("guard_spawn", this.guard_spawn);
            nbt.m_128347_("vacuum_spawn", this.vacuum_spawn);
            nbt.m_128347_("aether_spawn", this.aether_spawn);
            nbt.m_128347_("eye_spawn", this.eye_spawn);
            nbt.m_128347_("titan_spawn", this.titan_spawn);
            nbt.m_128347_("aberration_spawn", this.aberration_spawn);
            nbt.m_128347_("shadows_spawn", this.shadows_spawn);
            nbt.m_128347_("book_spawn", this.book_spawn);
            nbt.m_128347_("enderguard_spawn", this.enderguard_spawn);
            nbt.m_128347_("enderstrider_spawn", this.enderstrider_spawn);
            nbt.m_128347_("enderclinch", this.enderclinch);
            nbt.m_128347_("imitator", this.imitator);
            nbt.m_128347_("puj_spawn", this.puj_spawn);
            nbt.m_128347_("I_don_t_respect_devils", this.I_don_t_respect_devils);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "freak_mobs_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Butcher_kill = original.Butcher_kill;
            clone.Defield_Creefly = original.Defield_Creefly;
            clone.shadow_spawn = original.shadow_spawn;
            clone.shadowy = original.shadowy;
            clone.tf2 = original.tf2;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                FreakMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

