/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.mimicer.entities.goals;

import de.cadentem.mimicer.entities.MimicerEntity;
import de.cadentem.mimicer.entities.goals.Roll;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MimicerFleeGoal
extends Goal {
    private final MimicerEntity mimicer;
    private final double speedModifier;
    private float ticksUntilLeave;
    private float ticksUntilFlee;
    private boolean shouldLeave;
    private Path fleePath;
    private int ticksUntilNextPathRecalculation;

    public MimicerFleeGoal(MimicerEntity mimicer, float ticksUntilLeave, double speedModifier) {
        this.mimicer = mimicer;
        this.ticksUntilLeave = ticksUntilLeave;
        this.ticksUntilFlee = 10.0f;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        if (this.mimicer.m_20145_()) {
            return false;
        }
        if (this.mimicer.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.mimicer.m_5448_() != null;
    }

    public boolean m_8045_() {
        if (this.mimicer.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.mimicer.m_5448_() != null;
    }

    public void m_8056_() {
        this.setFleePath();
        this.shouldLeave = false;
    }

    public void m_8037_() {
        LivingEntity target = this.mimicer.m_5448_();
        if (this.shouldLeave && !this.mimicer.targetIsFacingMe) {
            this.mimicer.disappear();
        }
        this.ticksUntilFlee -= 1.0f;
        this.tickStareClock();
        if (this.ticksUntilFlee <= 0.0f) {
            this.fleeTick();
            this.mimicer.isFleeing = true;
            this.mimicer.m_20088_().m_135381_(MimicerEntity.FLEEING_ACCESSOR, (Object)true);
        } else if (target != null) {
            this.mimicer.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
        }
    }

    private void setFleePath() {
        LivingEntity target = this.mimicer.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 fleePosition = DefaultRandomPos.m_148407_((PathfinderMob)this.mimicer, (int)32, (int)7, (Vec3)target.m_20182_());
        if (fleePosition != null) {
            this.fleePath = this.mimicer.m_21573_().m_26524_(fleePosition.f_82479_, fleePosition.f_82480_, fleePosition.f_82481_, 0);
        }
    }

    public void tickStareClock() {
        this.ticksUntilLeave -= 1.0f;
        if (this.ticksUntilLeave < 0.0f) {
            this.shouldLeave = true;
        }
    }

    public void fleeTick() {
        if (this.fleePath == null || this.fleePath.m_77392_()) {
            this.setFleePath();
        }
        this.mimicer.playFleeSound();
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.ticksUntilNextPathRecalculation == 0) {
            this.ticksUntilNextPathRecalculation = 2;
            if (!this.mimicer.m_21573_().m_26536_(this.fleePath, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 2;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
    }
}

