/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.config.SoundAttractConfig;

public class DynamicScanCooldownManager {
    public static int currentScanCooldownTicks = 20;
    private static final int MIN_COOLDOWN = 10;
    private static final int DEFAULT_MAX_COOLDOWN = 60;
    private static final int HIGH_MOBCOUNT_MAX_COOLDOWN = 100;
    private static final int HIGH_MOBCOUNT_THRESHOLD = 100;
    private static long lastCheckTime = System.currentTimeMillis();
    private static long lastTickCount = 0L;

    private static double getLowTps() {
        return (Double)SoundAttractConfig.COMMON.minTpsForScanCooldown.get();
    }

    private static double getHighTps() {
        return (Double)SoundAttractConfig.COMMON.maxTpsForScanCooldown.get();
    }

    public static void update(long totalTickCount, int mobCount) {
        int maxCooldown;
        long now = System.currentTimeMillis();
        long ticksElapsed = totalTickCount - lastTickCount;
        long timeElapsed = now - lastCheckTime;
        int n = maxCooldown = mobCount > 100 ? 100 : 60;
        if (ticksElapsed > 0L && timeElapsed > 0L) {
            double tps = (double)ticksElapsed * 1000.0 / (double)timeElapsed * 20.0;
            double lowTps = DynamicScanCooldownManager.getLowTps();
            double highTps = DynamicScanCooldownManager.getHighTps();
            if (tps < lowTps || mobCount > 100) {
                currentScanCooldownTicks = Math.min(maxCooldown, currentScanCooldownTicks + 2);
            } else if (tps > highTps && currentScanCooldownTicks > 10) {
                currentScanCooldownTicks = Math.max(10, currentScanCooldownTicks - 1);
            }
        }
        lastCheckTime = now;
        lastTickCount = totalTickCount;
    }

    public static boolean shouldScanThisTick(long mobId, long totalTickCount) {
        return (mobId + totalTickCount) % (long)currentScanCooldownTicks == 0L;
    }
}

