/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class SoundAttractClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ClientLevel clientWorld = Minecraft.getInstance().level;
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientWorld == null || clientPlayer == null) {
            return;
        }
        SoundInstance soundInstance = event.getSound();
        if (soundInstance instanceof AbstractSoundInstance) {
            AbstractSoundInstance soundInstance2 = (AbstractSoundInstance)soundInstance;
            ResourceLocation soundRL = soundInstance2.getLocation();
            if (soundRL == null || soundRL.equals((Object)SoundMessage.VOICE_CHAT_SOUND_ID)) {
                return;
            }
            if (!SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(soundRL)) {
                return;
            }
            SoundEvent se = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundRL);
            if (se == null) {
                return;
            }
            double x = soundInstance2.getX();
            double y = soundInstance2.getY();
            double z = soundInstance2.getZ();
            ResourceLocation dim = clientWorld.dimension().location();
            Optional<UUID> sourcePlayerUUID = Optional.empty();
            int calculatedRange = -1;
            double calculatedWeight = 1.0;
            if (se != null && se.getLocation().getPath().contains("step") && clientPlayer.position().distanceToSqr(x, y, z) < 2.25) {
                sourcePlayerUUID = Optional.of(clientPlayer.getUUID());
                Vec3 motion = clientPlayer.getDeltaMovement();
                double horizontalSpeedSq = motion.x * motion.x + motion.z * motion.z;
                boolean isOnGround = clientPlayer.onGround();
                boolean isSneaking = clientPlayer.isShiftKeyDown();
                boolean isSprinting = clientPlayer.isSprinting();
                PlayerAction currentAction = PlayerAction.IDLE;
                if (isSneaking) {
                    if (horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 9.0E-4) {
                        currentAction = PlayerAction.CRAWLING;
                    } else if (horizontalSpeedSq > 9.0E-4 && horizontalSpeedSq <= 0.004791600000000001) {
                        currentAction = PlayerAction.SNEAKING;
                    }
                } else if (isSprinting && !isOnGround) {
                    currentAction = PlayerAction.SPRINT_JUMPING;
                } else if (isSprinting && horizontalSpeedSq > 0.046655999999999996) {
                    currentAction = PlayerAction.SPRINTING;
                } else if (isOnGround && horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 0.046655999999999996) {
                    currentAction = PlayerAction.WALKING;
                }
                switch (currentAction.ordinal()) {
                    case 1: {
                        calculatedRange = 2;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case 2: {
                        calculatedRange = 3;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case 3: {
                        calculatedRange = 8;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case 4: {
                        calculatedRange = 12;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case 5: {
                        calculatedRange = 16;
                        calculatedWeight = 1.0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            SoundMessage msg = new SoundMessage(soundRL, new Vec3(x, y, z), dim, sourcePlayerUUID, calculatedRange, calculatedWeight, Optional.empty(), Optional.empty());
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void registerVoiceChatIntegration() {
    }

    private static int parseIntOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOr(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

