/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractClientEvents;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.AIModificationEvents;
import com.example.soundattract.integration.PlasmoVoiceBootstrap;
import com.example.soundattract.integration.TaczIntegration;
import com.example.soundattract.integration.VanillaIntegrationEvents;
import com.example.soundattract.loot.ModLootModifiers;
import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="soundattract")
public class SoundAttractMod {
    public static final String MOD_ID = "soundattract";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SoundAttractMod(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::onConfigReload);
        ModLootModifiers.register(modEventBus);
        modEventBus.addListener(this::registerPacketHandlers);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SoundAttractConfig.COMMON_SPEC);
        NeoForge.EVENT_BUS.register((Object)new FovEvents());
        NeoForge.EVENT_BUS.register((Object)new StealthDetectionEvents());
        NeoForge.EVENT_BUS.register((Object)new AIModificationEvents());
        NeoForge.EVENT_BUS.register((Object)new SoundAttractionEvents());
        NeoForge.EVENT_BUS.register(VanillaIntegrationEvents.class);
        TaczIntegration.register();
        NeoForge.EVENT_BUS.register((Object)new PlasmoVoiceBootstrap());
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new SoundAttractClientEvents());
        }
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SoundAttractConfig.COMMON_SPEC) {
            LOGGER.info("Baking SoundAttractMod config values due to config event.");
            SoundAttractConfig.bakeConfig();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SoundAttractConfig.COMMON_SPEC) {
            LOGGER.info("Re-baking SoundAttractMod config values due to config reload.");
            SoundAttractConfig.bakeConfig();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("voicechat")) {
            LOGGER.info("[SoundAttractMod] VoiceChat mod is loaded. Integration is active.");
        } else {
            LOGGER.info("[SoundAttractMod] VoiceChat mod not present; skipping integration");
        }
    }

    private void registerPacketHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(SoundMessage.TYPE, SoundMessage.STREAM_CODEC, SoundMessage::handle);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        SoundTracker.initialize();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        SoundTracker.shutdown();
    }
}

