/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.CombatBlockBreakAssistGoal;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class SoundAttractionEvents {
    private static final Map<ResourceKey<Level>, Long> dimensionLoadTimes = new ConcurrentHashMap<ResourceKey<Level>, Long>();
    private static final Map<Mob, List<GoalDefinition>> PENDING_GOAL_ADDITIONS = new ConcurrentHashMap<Mob, List<GoalDefinition>>();
    private static long lastMobCountUpdateTime_ServerTick = -1L;
    private static int cachedAttractedMobCount_ServerTick = 0;
    private static Set<EntityType<?>> CACHED_ATTRACTED_ENTITY_TYPES = null;
    private static List<String> lastKnownAttractedEntitiesConfig_Copy = null;

    private static void scheduleAddGoal(Mob mob, int priority, Goal goal) {
        PENDING_GOAL_ADDITIONS.computeIfAbsent(mob, k -> new ArrayList()).add(new GoalDefinition(priority, goal));
    }

    public static Set<EntityType<?>> getCachedAttractedEntityTypes() {
        List currentConfigListFromGetter = (List)SoundAttractConfig.COMMON.attractedEntities.get();
        ArrayList<String> currentConfigListMutableCopy = new ArrayList<String>(currentConfigListFromGetter);
        if (CACHED_ATTRACTED_ENTITY_TYPES == null || lastKnownAttractedEntitiesConfig_Copy == null || !lastKnownAttractedEntitiesConfig_Copy.equals(currentConfigListMutableCopy)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && CACHED_ATTRACTED_ENTITY_TYPES != null) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Attracted entities config changed, rebuilding EntityType cache.");
            }
            CACHED_ATTRACTED_ENTITY_TYPES = currentConfigListFromGetter.stream().map(idStr -> {
                try {
                    return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)idStr));
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Invalid ResourceLocation for attracted entity type in config: {}", idStr, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            lastKnownAttractedEntitiesConfig_Copy = currentConfigListMutableCopy;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                String resultingTypes = CACHED_ATTRACTED_ENTITY_TYPES.stream().map(et -> BuiltInRegistries.ENTITY_TYPE.getKey(et).toString()).collect(Collectors.joining(", "));
                SoundAttractMod.LOGGER.info("[DIAGNOSTIC] Final attracted EntityType cache contains: [{}]", (Object)resultingTypes);
            }
        }
        return CACHED_ATTRACTED_ENTITY_TYPES;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (ServerLifecycleHooks.getCurrentServer() == null || ServerLifecycleHooks.getCurrentServer().overworld() == null) {
            return;
        }
        ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().overworld();
        long currentTime = serverLevel.getGameTime();
        int mobCountUpdateInterval = (Integer)SoundAttractConfig.COMMON.groupUpdateInterval.get();
        if (currentTime - lastMobCountUpdateTime_ServerTick >= (long)(mobCountUpdateInterval = Math.max(20, mobCountUpdateInterval)) || lastMobCountUpdateTime_ServerTick == -1L) {
            int currentMobCount = 0;
            HashSet<Mob> countedMobsInTick = new HashSet<Mob>();
            Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
            if (!attractedEntityTypes.isEmpty()) {
                for (ServerPlayer player : serverLevel.players()) {
                    int simDistanceBlocks = player.server.getPlayerList().getViewDistance() * 16;
                    AABB playerSimArea = player.getBoundingBox().inflate((double)simDistanceBlocks);
                    List mobsNearPlayer = serverLevel.getEntitiesOfClass(Mob.class, playerSimArea);
                    for (Mob mob : mobsNearPlayer) {
                        if (!mob.isAlive() || mob.isRemoved() || !attractedEntityTypes.contains(mob.getType()) || !countedMobsInTick.add(mob)) continue;
                        ++currentMobCount;
                    }
                }
            }
            cachedAttractedMobCount_ServerTick = currentMobCount;
            lastMobCountUpdateTime_ServerTick = currentTime;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Updated attracted mob count for DynamicScanCooldownManager: {}", (Object)cachedAttractedMobCount_ServerTick);
            }
        }
        int mobCountForCooldownManager = cachedAttractedMobCount_ServerTick;
        DynamicScanCooldownManager.update(currentTime, mobCountForCooldownManager);
        SoundTracker.tick();
        BlockBreakerManager.processPendingActions();
        if (!PENDING_GOAL_ADDITIONS.isEmpty()) {
            Iterator<Map.Entry<Mob, List<GoalDefinition>>> iterator = PENDING_GOAL_ADDITIONS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Mob, List<GoalDefinition>> entry = iterator.next();
                Mob mob = entry.getKey();
                List<GoalDefinition> goalsToAdd = entry.getValue();
                if (mob.isAlive() && mob.level() != null && !mob.isRemoved()) {
                    for (GoalDefinition def : goalsToAdd) {
                        boolean goalExists = mob.goalSelector.getAvailableGoals().stream().anyMatch(wrappedGoal -> def.goalClass.isInstance(wrappedGoal.getGoal()));
                        if (goalExists) continue;
                        mob.goalSelector.addGoal(def.priority, def.goalInstance);
                        if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added goal {} to mob {}", (Object)def.goalClass.getSimpleName(), (Object)mob.getName().getString());
                    }
                }
                iterator.remove();
            }
        }
    }

    private void tryUpdateGroupsWithDelay(ServerLevel serverLevel) {
        long currentTime = serverLevel.getGameTime();
        ResourceKey dimensionKey = serverLevel.dimension();
        dimensionLoadTimes.putIfAbsent((ResourceKey<Level>)dimensionKey, currentTime);
        long timeSinceLoad = currentTime - dimensionLoadTimes.get(dimensionKey);
        int delay = (Integer)SoundAttractConfig.COMMON.initialGroupComputationDelay.get();
        if (timeSinceLoad >= (long)delay) {
            MobGroupManager.updateGroups(serverLevel);
        }
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level;
        if (!event.getLevel().isClientSide() && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tryUpdateGroupsWithDelay(serverLevel);
            RaidManager.tick(serverLevel);
        }
    }

    @SubscribeEvent
    public void onMobJoinLevel(EntityJoinLevelEvent event) {
        Level level;
        boolean hasMatchingprofile;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean isAttractedByType = attractedEntityTypes.contains(mob.getType());
        boolean bl = hasMatchingprofile = SoundAttractConfig.getMatchingProfile(mob) != null;
        if (!isAttractedByType && !hasMatchingprofile) {
            return;
        }
        double moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        SoundAttractionEvents.scheduleAddGoal(mob, 2, new CombatBlockBreakAssistGoal(mob));
        SoundAttractionEvents.scheduleAddGoal(mob, 3, new LeaderAttractionGoal(mob, moveSpeed));
        SoundAttractionEvents.scheduleAddGoal(mob, 3, new AttractionGoal(mob, moveSpeed));
        SoundAttractionEvents.scheduleAddGoal(mob, 4, new FollowerEdgeRelayGoal(mob, moveSpeed));
        SoundAttractionEvents.scheduleAddGoal(mob, 5, new FollowLeaderGoal(mob, moveSpeed));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Scheduled goals for mob {} of type {}", (Object)mob.getName().getString(), (Object)EntityType.getKey((EntityType)mob.getType()));
        }
        if ((level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tryUpdateGroupsWithDelay(serverLevel);
        }
    }

    private static class GoalDefinition {
        final int priority;
        final Goal goalInstance;
        final Class<? extends Goal> goalClass;

        GoalDefinition(int priority, Goal goalInstance) {
            this.priority = priority;
            this.goalInstance = goalInstance;
            this.goalClass = goalInstance.getClass();
        }
    }
}

