/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public record SoundMessage(ResourceLocation soundId, Vec3 position, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight, Optional<String> animatorClass, Optional<String> taczType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SoundMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"soundattract", (String)"sound_message"));
    public static final ResourceLocation VOICE_CHAT_SOUND_ID = ResourceLocation.fromNamespaceAndPath((String)"soundattract", (String)"voice_chat");
    private static final StreamCodec<FriendlyByteBuf, Part1> PART1_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Part1::soundId, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new), Part1::position, (StreamCodec)ResourceLocation.STREAM_CODEC, Part1::dimension, (StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), Part1::sourcePlayerUUID, Part1::new);
    public static final StreamCodec<FriendlyByteBuf, SoundMessage> STREAM_CODEC = StreamCodec.composite(PART1_CODEC, sm -> new Part1(sm.soundId(), sm.position(), sm.dimension(), sm.sourcePlayerUUID()), (StreamCodec)ByteBufCodecs.VAR_INT, SoundMessage::range, (StreamCodec)ByteBufCodecs.DOUBLE, SoundMessage::weight, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), SoundMessage::animatorClass, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), SoundMessage::taczType, (part1, range, weight, animClass, taczType) -> new SoundMessage(part1.soundId(), part1.position(), part1.dimension(), part1.sourcePlayerUUID(), (int)range, (double)weight, (Optional<String>)animClass, (Optional<String>)taczType));

    public static void handle(SoundMessage msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            try {
                ServerPlayer sp;
                ResourceLocation loc = msg.soundId();
                if (!(SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() || loc.equals((Object)VOICE_CHAT_SOUND_ID) || SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(loc))) {
                    return;
                }
                Player patt0$temp = context.player();
                ServerPlayer sender = patt0$temp instanceof ServerPlayer ? (sp = (ServerPlayer)patt0$temp) : null;
                ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)msg.dimension());
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().getLevel(levelKey);
                if (serverLevel == null) {
                    return;
                }
                Vec3 soundLocation = msg.position().equals((Object)Vec3.ZERO) && sender != null ? sender.position() : msg.position();
                BlockPos pos = BlockPos.containing((Position)soundLocation);
                String dimString = msg.dimension().toString();
                int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
                if (msg.soundId().equals((Object)VOICE_CHAT_SOUND_ID)) {
                    if (msg.range() > 0 && msg.animatorClass().isPresent()) {
                        SoundTracker.addVirtualSound(pos, dimString, msg.range(), msg.weight(), lifetime, msg.sourcePlayerUUID().orElse(null), msg.animatorClass().get());
                    }
                } else {
                    Optional se = BuiltInRegistries.SOUND_EVENT.getOptional(msg.soundId());
                    double range = msg.range();
                    double weight = msg.weight();
                    if (range < 0.0) {
                        SoundAttractConfig.SoundDefaultEntry def = SoundAttractConfig.SOUND_DEFAULT_ENTRIES_CACHE.get(msg.soundId());
                        if (def != null) {
                            range = def.range();
                            weight = def.weight();
                        } else {
                            range = 10.0;
                            weight = 1.0;
                        }
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[SoundMessage] Using fallback range/weight for {}: range={}, weight={}", new Object[]{msg.soundId(), range, weight});
                        }
                    }
                    double finalRange = range;
                    double finalWeight = weight;
                    se.ifPresent(soundEvent -> SoundTracker.addSound(soundEvent, pos, dimString, finalRange, finalWeight, lifetime, null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private record Part1(ResourceLocation soundId, Vec3 position, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID) {
    }
}

