/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public final class BlockBreakerManager {
    private static final Map<Mob, GoalAction> PENDING = new ConcurrentHashMap<Mob, GoalAction>();

    private BlockBreakerManager() {
    }

    public static void scheduleAdd(Mob mob, Goal goal, int priority) {
        if (mob == null || goal == null) {
            return;
        }
        PENDING.put(mob, new GoalAction(ActionType.ADD, goal, priority));
    }

    public static void scheduleRemove(Mob mob, Goal goal) {
        if (mob == null || goal == null) {
            return;
        }
        PENDING.put(mob, new GoalAction(ActionType.REMOVE, goal, 0));
    }

    public static void processPendingActions() {
        if (PENDING.isEmpty()) {
            return;
        }
        for (Mob mob : PENDING.keySet()) {
            GoalAction action = PENDING.remove(mob);
            if (action == null || !mob.isAlive() || mob.isRemoved()) continue;
            switch (action.type.ordinal()) {
                case 0: {
                    mob.goalSelector.getAvailableGoals().stream().filter(w -> w.getGoal().getClass().equals(action.goal.getClass())).findFirst().ifPresent(w -> mob.goalSelector.removeGoal(w.getGoal()));
                    mob.goalSelector.addGoal(action.priority, action.goal);
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break;
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Added goal {} for {} at priority {}", new Object[]{action.goal.getClass().getSimpleName(), mob.getName().getString(), action.priority});
                    break;
                }
                case 1: {
                    mob.goalSelector.removeGoal(action.goal);
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break;
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Removed goal {} for {}", (Object)action.goal.getClass().getSimpleName(), (Object)mob.getName().getString());
                }
            }
        }
    }

    private record GoalAction(ActionType type, Goal goal, int priority) {
    }

    private static enum ActionType {
        ADD,
        REMOVE;

    }
}

