/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FollowLeaderGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private Mob leader;
    private static final double MAX_DISTANCE = 12.0;
    private Vec3 lastPos = null;
    private int stuckTicks = 0;
    private int stuckThreshold;
    private int dynamicTickCounter;
    private Vec3 lastRandomDest;
    private boolean hasPickedDest;

    public FollowLeaderGoal(Mob mob, double moveSpeed) {
        this.stuckThreshold = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        this.dynamicTickCounter = 0;
        this.lastRandomDest = null;
        this.hasPickedDest = false;
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private double getGroupDistance() {
        return (Double)SoundAttractConfig.COMMON.groupDistance.get();
    }

    public boolean canUse() {
        this.leader = MobGroupManager.getLeader(this.mob);
        if (this.leader == null || this.leader == this.mob) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)this.leader) < this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (smartEdge && MobGroupManager.isEdgeMob(this.mob)) {
            return false;
        }
        return this.leader.isAlive();
    }

    public boolean canContinueToUse() {
        if (this.leader == null || !this.leader.isAlive()) {
            return false;
        }
        return !(this.mob.distanceToSqr((Entity)this.leader) < this.getGroupDistance() * this.getGroupDistance());
    }

    public void tick() {
        if (this.leader == null || !this.leader.isAlive()) {
            return;
        }
        int scanCooldown = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        int updateInterval = Math.max(1, scanCooldown / 2);
        this.dynamicTickCounter = (this.dynamicTickCounter + 1) % updateInterval;
        if (this.dynamicTickCounter != 0) {
            return;
        }
        double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
        boolean raidAdvancing = RaidManager.isRaidAdvancing(this.leader);
        double speed = raidAdvancing ? this.moveSpeed * sprintMult : this.moveSpeed;
        Vec3 leaderPos = this.leader.position();
        Vec3 curPos = this.mob.position();
        if (curPos.distanceToSqr(leaderPos) > 2.25) {
            this.mob.getNavigation().moveTo(this.leader.getX(), this.leader.getY(), this.leader.getZ(), speed);
        }
        if (this.lastPos != null && curPos.distanceToSqr(this.lastPos) < 0.04) {
            ++this.stuckTicks;
            if (this.stuckTicks > this.stuckThreshold) {
                this.stuckTicks = 0;
                this.mob.getNavigation().moveTo(this.leader.getX(), this.leader.getY(), this.leader.getZ(), speed);
            }
        } else {
            this.stuckTicks = 0;
        }
        this.lastPos = curPos;
        if (this.leader.getNavigation().isDone()) {
            this.hasPickedDest = false;
            this.lastRandomDest = null;
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.leader = null;
        this.hasPickedDest = false;
        this.lastRandomDest = null;
    }
}

