/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class LeaderAttractionGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private Vec3 chosenDest = null;
    private boolean hasPicked = false;
    private BlockPos lastPos = null;
    private int stuckTicks = 0;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private SoundTracker.SoundRecord cachedSound = null;

    public LeaderAttractionGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean byType = attractedTypes.contains(this.mob.getType());
        boolean hasProfile = SoundAttractConfig.getMatchingProfile(this.mob) != null;
        return byType || hasProfile;
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private SoundTracker.SoundRecord findBestRelayedSound() {
        List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
        SoundTracker.SoundRecord best = null;
        if (relays != null && !relays.isEmpty()) {
            for (MobGroupManager.SoundRelay relay : relays) {
                SoundTracker.SoundRecord rec = new SoundTracker.SoundRecord(null, relay.soundId, new BlockPos((int)relay.x, (int)relay.y, (int)relay.z), 200, this.mob.level().dimension().location().toString(), relay.range, relay.weight);
                if (best != null && !(rec.weight > best.weight)) continue;
                best = rec;
            }
        }
        return best;
    }

    public boolean canUse() {
        if (this.mob.isVehicle() || this.mob.isSleeping()) {
            return false;
        }
        if (!this.isMobEligible()) {
            return false;
        }
        if (MobGroupManager.getLeader(this.mob) != this.mob) {
            return false;
        }
        if (RaidManager.isRaidTicking(this.mob)) {
            return false;
        }
        if (RaidManager.isRaidAdvancing(this.mob)) {
            BlockPos raidTarget = RaidManager.getRaidTarget(this.mob);
            if (raidTarget == null) {
                return false;
            }
            this.cachedSound = null;
            this.targetSoundPos = raidTarget;
            this.currentTargetWeight = 1000.0;
            this.hasPicked = false;
            this.chosenDest = null;
            return true;
        }
        SoundTracker.SoundRecord relayed = this.findBestRelayedSound();
        if (relayed == null) {
            return false;
        }
        this.cachedSound = relayed;
        this.targetSoundPos = relayed.pos;
        this.currentTargetWeight = relayed.weight;
        this.hasPicked = false;
        this.chosenDest = null;
        return true;
    }

    public boolean canContinueToUse() {
        BlockPos destination;
        if (!this.isMobEligible() || this.mob.isVehicle() || this.mob.isSleeping()) {
            return false;
        }
        if (this.targetSoundPos == null) {
            return false;
        }
        if (RaidManager.isRaidTicking(this.mob)) {
            return false;
        }
        if (RaidManager.isRaidAdvancing(this.mob)) {
            BlockPos destination2;
            BlockPos blockPos = destination2 = this.chosenDest != null ? BlockPos.containing((Position)this.chosenDest) : this.targetSoundPos;
            if (this.mob.getNavigation().isDone() && destination2 != null && this.mob.blockPosition().distSqr((Vec3i)destination2) < 4.0) {
                RaidManager.clearRaid(this.mob);
                return false;
            }
            return true;
        }
        BlockPos blockPos = destination = this.chosenDest != null ? BlockPos.containing((Position)this.chosenDest) : this.targetSoundPos;
        if (this.mob.getNavigation().isDone() && destination != null && this.mob.blockPosition().distSqr((Vec3i)destination) < 4.0) {
            return false;
        }
        List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
        if (relays != null) {
            for (MobGroupManager.SoundRelay relay : relays) {
                double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                if (!(relay.weight > this.currentTargetWeight * switchRatio)) continue;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[LeaderAttractionGoal] {} switching target due to better relay ({} > {}).", new Object[]{this.mob.getName().getString(), relay.weight, this.currentTargetWeight});
                }
                return false;
            }
        }
        return true;
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetSoundPos = null;
        this.currentTargetWeight = -1.0;
        this.cachedSound = null;
        this.hasPicked = false;
        this.chosenDest = null;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("LeaderAttractionGoal stop: {}", (Object)this.mob.getName().getString());
        }
    }

    public void tick() {
        if (RaidManager.isRaidAdvancing(this.mob)) {
            BlockPos raidTarget;
            if (this.targetSoundPos == null && (raidTarget = RaidManager.getRaidTarget(this.mob)) != null) {
                this.targetSoundPos = raidTarget;
            }
            if (this.targetSoundPos == null) {
                return;
            }
            if (this.lastPos != null && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.lastPos)) < 1.0) {
                ++this.stuckTicks;
            } else {
                this.stuckTicks = 0;
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
            }
            if (this.stuckTicks == 0) {
                this.lastPos = this.mob.blockPosition();
            }
            if (this.stuckTicks >= 40 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue() && this.blockBreakerGoal == null) {
                BlockBreakerPosGoal newGoal = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get());
                BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                this.blockBreakerGoal = newGoal;
            }
            if (!this.hasPicked) {
                double arrivalDist = this.getArrivalDistance();
                long seed = this.mob.getUUID().getMostSignificantBits() ^ this.mob.getUUID().getLeastSignificantBits() ^ (long)this.targetSoundPos.hashCode();
                Random rand = new Random(seed);
                double angle = rand.nextDouble() * (Math.PI * 2);
                double radius = arrivalDist * Math.sqrt(rand.nextDouble());
                int blockX = this.targetSoundPos.getX() + (int)Math.floor(Math.cos(angle) * radius);
                int blockZ = this.targetSoundPos.getZ() + (int)Math.floor(Math.sin(angle) * radius);
                int groundY = this.mob.level().getHeight(Heightmap.Types.MOTION_BLOCKING, blockX, blockZ);
                this.chosenDest = new Vec3((double)blockX + 0.5, (double)groundY, (double)blockZ + 0.5);
                this.hasPicked = true;
            }
            if (this.chosenDest != null) {
                Vec3 cur = this.mob.position();
                if (cur.distanceToSqr(this.chosenDest) > 2.25) {
                    this.mob.getNavigation().moveTo(this.chosenDest.x, this.chosenDest.y, this.chosenDest.z, this.moveSpeed);
                }
                if (this.mob.getNavigation().isDone()) {
                    this.hasPicked = false;
                    this.chosenDest = null;
                }
            }
            return;
        }
        if (this.blockBreakerGoal != null && this.mob.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).anyMatch(g -> g.getGoal() == this.blockBreakerGoal)) {
            List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
            if (relays != null) {
                for (MobGroupManager.SoundRelay relay : relays) {
                    double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                    if (!(relay.weight > this.currentTargetWeight * switchRatio)) continue;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[LeaderAttractionGoal] {} found better relay while breaking. Stopping block breaking.", (Object)this.mob.getName().getString());
                    }
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                    this.stop();
                    return;
                }
            }
            if (this.lastPos != null && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.lastPos)) >= 1.0) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
                this.stuckTicks = 0;
                this.lastPos = this.mob.blockPosition();
            }
            return;
        }
        List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
        if (relays != null && !relays.isEmpty()) {
            for (MobGroupManager.SoundRelay relay : relays) {
                double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                if (!(relay.weight > this.currentTargetWeight * switchRatio)) continue;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[LeaderAttractionGoal] {} switching to relayed sound at ({}, {}, {}) (w:{}, r:{})", new Object[]{this.mob.getName().getString(), relay.x, relay.y, relay.z, relay.weight, relay.range});
                }
                this.cachedSound = new SoundTracker.SoundRecord(null, relay.soundId, new BlockPos((int)relay.x, (int)relay.y, (int)relay.z), 200, this.mob.level().dimension().location().toString(), relay.range, relay.weight);
                this.targetSoundPos = this.cachedSound.pos;
                this.currentTargetWeight = this.cachedSound.weight;
                this.hasPicked = false;
                this.chosenDest = null;
            }
        }
        if (this.targetSoundPos == null) {
            return;
        }
        if (this.lastPos != null && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.lastPos)) < 1.0) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            if (this.blockBreakerGoal != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
            }
        }
        if (this.stuckTicks == 0) {
            this.lastPos = this.mob.blockPosition();
        }
        if (this.stuckTicks >= 40 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && this.stuckTicks == 40) {
                SoundAttractMod.LOGGER.info("[LeaderAttractionGoal DEBUG] {} truly stuck. isStuck(): {}", (Object)this.mob.getName().getString(), (Object)this.mob.getNavigation().isStuck());
            }
            if (this.blockBreakerGoal == null) {
                BlockPos destination = this.targetSoundPos;
                if (this.mob.getNavigation().isDone()) {
                    if (destination != null && this.mob.blockPosition().distSqr((Vec3i)destination) > 4.0) {
                        ++this.stuckTicks;
                        if (this.stuckTicks >= 20 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue() && this.blockBreakerGoal == null) {
                            double timeMultiplier = (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get();
                            boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get();
                            boolean properTool = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get();
                            boolean properReq = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get();
                            BlockBreakerPosGoal newGoal = new BlockBreakerPosGoal(this.mob, destination, timeMultiplier, toolOnly, properTool, properReq);
                            BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                            this.blockBreakerGoal = newGoal;
                        }
                    } else {
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                    if (this.blockBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                    }
                }
            }
        }
        if (!this.hasPicked) {
            double arrivalDist = this.getArrivalDistance();
            long seed = this.mob.getUUID().getMostSignificantBits() ^ this.mob.getUUID().getLeastSignificantBits() ^ (long)this.targetSoundPos.hashCode();
            Random rand = new Random(seed);
            double angle = rand.nextDouble() * (Math.PI * 2);
            double radius = arrivalDist * Math.sqrt(rand.nextDouble());
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            int blockX = this.targetSoundPos.getX() + (int)Math.floor(offsetX);
            int blockZ = this.targetSoundPos.getZ() + (int)Math.floor(offsetZ);
            int groundY = this.mob.level().getHeight(Heightmap.Types.MOTION_BLOCKING, blockX, blockZ);
            double finalX = (double)blockX + 0.5;
            double finalY = groundY;
            double finalZ = (double)blockZ + 0.5;
            this.chosenDest = new Vec3(finalX, finalY, finalZ);
            this.hasPicked = true;
        }
        if (this.chosenDest != null) {
            Vec3 cur = this.mob.position();
            if (cur.distanceToSqr(this.chosenDest) > 2.25) {
                this.mob.getNavigation().moveTo(this.chosenDest.x, this.chosenDest.y, this.chosenDest.z, this.moveSpeed);
            }
            if (this.mob.getNavigation().isDone()) {
                this.hasPicked = false;
                this.chosenDest = null;
            }
        }
        if (this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance() && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[LeaderAttractionGoal] {} arrived near {}.", (Object)this.mob.getName().getString(), (Object)this.targetSoundPos);
        }
    }
}

