/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;

public class MobGroupManager {
    private static final Map<String, DimensionGroupData> dimensionData = new ConcurrentHashMap<String, DimensionGroupData>();
    private static final int RELAY_SOUND_TTL = 40;
    private static final int RELAY_SOUND_RATE_LIMIT = 20;
    private static final double STICKY_RADIUS_MARGIN = 2.0;
    private static final Object cleanupLock = new Object();

    private static DimensionGroupData getData(String dimensionKey) {
        return dimensionData.computeIfAbsent(dimensionKey, k -> new DimensionGroupData());
    }

    private static DimensionGroupData getData(Mob mob) {
        return MobGroupManager.getData(mob.level().dimension().location().toString());
    }

    private static DimensionGroupData getData(ServerLevel level) {
        return MobGroupManager.getData(level.dimension().location().toString());
    }

    public static boolean isEdgeMob(Mob mob) {
        boolean isEdge;
        Mob leader;
        DimensionGroupData data = MobGroupManager.getData(mob);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[isEdgeMob] Checking mob {} (pos: {}, {})", new Object[]{mob.getName().getString(), mob.getX(), mob.getZ()});
        }
        if ((leader = MobGroupManager.getLeader(mob)) == mob) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[isEdgeMob] Mob {} is its own leader (not edge)", (Object)mob.getName().getString());
            }
            return false;
        }
        Set<Mob> edgeSet = data.lastEdgeMobMap.get(leader);
        boolean bl = isEdge = edgeSet != null && edgeSet.contains(mob);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[isEdgeMob] Mob {} is {}edge mob for leader {}", new Object[]{mob.getName().getString(), isEdge ? "" : "NOT ", leader.getName().getString()});
        }
        return isEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupStaleEntries(ServerLevel level) {
        DimensionGroupData data = MobGroupManager.getData(level);
        Object object = cleanupLock;
        synchronized (object) {
            Map<Mob, Object> map = data.leaders;
            synchronized (map) {
                data.leaders.removeIf(ref -> {
                    Mob mob = (Mob)ref.get();
                    return mob == null || mob.isRemoved();
                });
            }
            map = data.uuidToLeader;
            synchronized (map) {
                data.uuidToLeader.values().removeIf(mob -> mob == null || mob.isRemoved());
            }
            map = data.mobToRelayedSounds;
            synchronized (map) {
                data.mobToRelayedSounds.keySet().removeIf(mob -> mob == null || mob.isRemoved());
            }
            map = data.mobLastRelayTime;
            synchronized (map) {
                data.mobLastRelayTime.keySet().removeIf(mob -> mob == null || mob.isRemoved());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroups(ServerLevel level) {
        int scanCooldown;
        DimensionGroupData data = MobGroupManager.getData(level);
        long time = level.getGameTime();
        if (time - data.lastGroupUpdateTime < (long)((Integer)SoundAttractConfig.COMMON.groupUpdateInterval.get()).intValue()) {
            return;
        }
        data.lastGroupUpdateTime = time;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] Updating groups at time: " + time);
        }
        if ((scanCooldown = DynamicScanCooldownManager.currentScanCooldownTicks) > 0 && (data.lastCleanupTime == -1L || time - data.lastCleanupTime > 10L * (long)scanCooldown)) {
            MobGroupManager.cleanupStaleEntries(level);
            data.lastCleanupTime = time;
        }
        Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        int simDistChunks = level.getServer().getPlayerList().getViewDistance();
        int simDistBlocks = simDistChunks * 16;
        HashSet mobsSet = new HashSet();
        for (ServerPlayer player : level.players()) {
            AABB box = player.getBoundingBox().inflate((double)simDistBlocks);
            List nearbyMobs = level.getEntitiesOfClass(Mob.class, box);
            mobsSet.addAll(nearbyMobs);
        }
        ArrayList mobs = new ArrayList(mobsSet);
        StringBuilder allMobTypesLog = new StringBuilder();
        for (Object mob : mobs) {
            ResourceLocation id = mob.getType().builtInRegistryHolder().key().location();
            allMobTypesLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", id.toString(), mob.getX(), mob.getY(), mob.getZ()));
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] All mobs present ({}): {}", (Object)mobs.size(), (Object)allMobTypesLog.toString());
        }
        ArrayList<Object> attractedMobs = new ArrayList<Object>();
        for (Object mob : mobs) {
            if (!attractedEntityTypes.contains(mob.getType())) continue;
            attractedMobs.add(mob);
        }
        StringBuilder mobPosLog = new StringBuilder();
        for (Mob mob : attractedMobs) {
            mobPosLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", mob.getName().getString(), mob.getX(), mob.getY(), mob.getZ()));
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] Attracted mobs ({}): {}", (Object)attractedMobs.size(), (Object)mobPosLog.toString());
        }
        data.uuidToLeader.clear();
        data.leaders.clear();
        if (attractedMobs.isEmpty()) {
            return;
        }
        for (Mob mob : attractedMobs) {
            if (SoundAttractConfig.getMatchingProfile(mob) == null) continue;
            data.leaders.add(new WeakReference<Mob>(mob));
            data.uuidToLeader.put(mob.getUUID(), mob);
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            SoundAttractMod.LOGGER.info("[MobGroupManager] Profiled mob {} forced to leader", (Object)mob.getType().builtInRegistryHolder().key().location());
        }
        Collections.shuffle(attractedMobs, new Random(level.getGameTime()));
        double groupRadius = (Double)SoundAttractConfig.COMMON.leaderGroupRadius.get();
        int maxLeaders = (Integer)SoundAttractConfig.COMMON.maxLeaders.get();
        int maxGroupSize = (Integer)SoundAttractConfig.COMMON.maxGroupSize.get();
        double leaderSpacing = groupRadius * (Double)SoundAttractConfig.COMMON.leaderSpacingMultiplier.get();
        HashSet<Mob> assigned = new HashSet<Mob>();
        ArrayList<Mob> leaderList = new ArrayList<Mob>();
        List<WeakReference<Mob>> list = data.leaders;
        synchronized (list) {
            data.leaders.removeIf(ref -> ref.get() == null || ((Mob)ref.get()).isRemoved());
            attractedMobs.sort(Comparator.comparingDouble(m -> -m.getHealth()));
            for (Mob mob : attractedMobs) {
                if (data.leaders.size() >= (Integer)SoundAttractConfig.COMMON.maxLeaders.get()) break;
                if (data.leaders.stream().anyMatch(ref -> ref.get() == potentialLeader)) continue;
                boolean tooCloseToExistingLeader = false;
                for (WeakReference<Object> weakReference : data.leaders) {
                    Mob existingLeader = (Mob)weakReference.get();
                    if (existingLeader == null || !(mob.distanceToSqr((Entity)existingLeader) < (Double)SoundAttractConfig.COMMON.leaderGroupRadius.get() * (Double)SoundAttractConfig.COMMON.leaderSpacingMultiplier.get() * ((Double)SoundAttractConfig.COMMON.leaderGroupRadius.get() * (Double)SoundAttractConfig.COMMON.leaderSpacingMultiplier.get()))) continue;
                    tooCloseToExistingLeader = true;
                    break;
                }
                if (tooCloseToExistingLeader) continue;
                data.leaders.add(new WeakReference<Mob>(mob));
                data.uuidToLeader.put(mob.getUUID(), mob);
                leaderList.add(mob);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[MobGroupManager] Promoted {} to LEADER", (Object)mob.getName().getString());
            }
        }
        HashMap<Mob, List<Object>> leaderToGroup = new HashMap<Mob, List<Object>>();
        for (Mob mob : leaderList) {
            ArrayList<Mob> group = new ArrayList<Mob>();
            group.add(mob);
            for (Mob mob2 : attractedMobs) {
                if (mob2 == mob || assigned.contains(mob2) || !((double)mob2.distanceTo((Entity)mob) <= groupRadius) || group.size() >= maxGroupSize) continue;
                group.add(mob2);
                assigned.add(mob2);
            }
            for (Mob mob3 : group) {
                data.uuidToLeader.put(mob3.getUUID(), mob);
            }
            leaderToGroup.put(mob, group);
        }
        for (Mob mob : attractedMobs) {
            if (!assigned.contains(mob)) {
                data.deserterUuids.add(mob.getUUID());
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[MobGroupManager] Mob {} marked as DESERTER (not in any group)", (Object)mob.getName().getString());
                continue;
            }
            data.deserterUuids.remove(mob.getUUID());
        }
        data.lastEdgeMobMap.clear();
        for (Mob mob : leaderList) {
            Object m322;
            List group;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                List g = leaderToGroup.getOrDefault(mob, Collections.emptyList());
                SoundAttractMod.LOGGER.info("[MobGroupManager] Group for leader {} has {} members (radius {}).", new Object[]{mob.getName().getString(), g.size(), groupRadius});
            }
            if ((group = (List)leaderToGroup.get(mob)) == null) continue;
            int sectors = (Integer)SoundAttractConfig.COMMON.numEdgeSectors.get();
            int n = (Integer)SoundAttractConfig.COMMON.edgeMobsPerSector.get();
            HashMap<Integer, List> sectorToFarthestList = new HashMap<Integer, List>();
            double leaderX = mob.getX();
            double leaderZ = mob.getZ();
            for (Object m322 : group) {
                if (m322 == mob) continue;
                double dx = m322.getX() - leaderX;
                double dz = m322.getZ() - leaderZ;
                double angle = Math.atan2(dz, dx);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorToFarthestList.computeIfAbsent(sector, k -> new ArrayList()).add(m322);
            }
            HashSet<Mob> edgeMobs = new HashSet<Mob>();
            m322 = sectorToFarthestList.entrySet().iterator();
            while (m322.hasNext()) {
                Map.Entry entry = (Map.Entry)m322.next();
                int sector = (Integer)entry.getKey();
                List mobsInSector = (List)entry.getValue();
                mobsInSector.sort((a, b) -> Double.compare(b.distanceTo((Entity)leader), a.distanceTo((Entity)leader)));
                int edgeCount = Math.min(n, mobsInSector.size());
                if (edgeCount == 0 && !mobsInSector.isEmpty()) {
                    edgeCount = 1;
                }
                for (int i = 0; i < edgeCount; ++i) {
                    edgeMobs.add((Mob)mobsInSector.get(i));
                }
            }
            if (edgeMobs.isEmpty() && group.size() > 1) {
                Mob farthest = null;
                double maxDist = -1.0;
                for (Mob m4 : group) {
                    double dist;
                    if (m4 == mob || !((dist = (double)m4.distanceTo((Entity)mob)) > maxDist)) continue;
                    maxDist = dist;
                    farthest = m4;
                }
                if (farthest != null) {
                    edgeMobs.add(farthest);
                }
            }
            data.lastEdgeMobMap.put(mob, edgeMobs);
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            StringBuilder sb = new StringBuilder();
            for (Mob edge : edgeMobs) {
                sb.append(edge.getName().getString()).append(", ");
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] Edge mobs for leader {}: {}", (Object)mob.getName().getString(), (Object)sb.toString());
        }
        data.mobToRelayedSounds.entrySet().removeIf(e -> ((Mob)e.getKey()).isRemoved());
        for (List list2 : data.mobToRelayedSounds.values()) {
            list2.removeIf(r -> time - r.timestamp > 40L);
        }
        data.mobLastRelayTime.entrySet().removeIf(e -> ((Mob)e.getKey()).isRemoved());
        ArrayList<Mob> allAttractedMobs = new ArrayList<Mob>();
        for (Mob mob : level.getEntitiesOfClass(Mob.class, level.getWorldBorder().getCollisionShape().bounds())) {
            String mobId = mob.getType().builtInRegistryHolder().key().location().toString();
            if (!((List)SoundAttractConfig.COMMON.attractedEntities.get()).contains(mobId)) continue;
            allAttractedMobs.add(mob);
        }
        Set<UUID> set = data.deserterUuids;
        synchronized (set) {
            for (Mob mob : allAttractedMobs) {
                boolean isGrouped;
                Mob mob4 = data.uuidToLeader.get(mob.getUUID());
                boolean bl = isGrouped = mob4 != null && mob4 != mob;
                if (!isGrouped) {
                    data.deserterUuids.add(mob.getUUID());
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                    SoundAttractMod.LOGGER.info("[MobGroupManager] Mob {} marked as DESERTER", (Object)mob.getName().getString());
                    continue;
                }
                data.deserterUuids.remove(mob.getUUID());
            }
        }
    }

    public static void relaySoundToLeader(Mob mob, String soundId, double x, double y, double z, double range, double weight, long timestamp) {
        DimensionGroupData data = MobGroupManager.getData(mob);
        Mob leader = MobGroupManager.getLeader(mob);
        if (leader == mob) {
            return;
        }
        Long lastRelay = data.mobLastRelayTime.get(mob);
        if (lastRelay != null && timestamp - lastRelay < 20L) {
            return;
        }
        data.mobLastRelayTime.put(mob, timestamp);
        SoundRelay relay = new SoundRelay(soundId, x, y, z, range, weight, timestamp);
        List relays = data.mobToRelayedSounds.computeIfAbsent(leader, k -> new ArrayList());
        if (!relays.contains(relay)) {
            relays.add(relay);
        }
    }

    public static List<SoundRelay> consumeRelayedSounds(Mob leader) {
        DimensionGroupData data = MobGroupManager.getData(leader);
        List<SoundRelay> relays = data.mobToRelayedSounds.remove(leader);
        if (relays == null) {
            return Collections.emptyList();
        }
        long now = leader.level().getGameTime();
        HashSet<SoundRelay> deduped = new HashSet<SoundRelay>();
        for (SoundRelay r : relays) {
            if (now - r.timestamp > 40L) continue;
            deduped.add(r);
        }
        return new ArrayList<SoundRelay>(deduped);
    }

    public static Mob getLeader(Mob mob) {
        DimensionGroupData data = MobGroupManager.getData(mob);
        return data.uuidToLeader.getOrDefault(mob.getUUID(), mob);
    }

    public static void promoteToDeserter(Mob mob) {
        DimensionGroupData data = MobGroupManager.getData(mob);
        data.deserterUuids.add(mob.getUUID());
    }

    public static boolean isDeserter(Mob mob) {
        DimensionGroupData data = MobGroupManager.getData(mob);
        return data.deserterUuids.contains(mob.getUUID());
    }

    private static class DimensionGroupData {
        final Map<UUID, Mob> uuidToLeader = Collections.synchronizedMap(new HashMap());
        final List<WeakReference<Mob>> leaders = Collections.synchronizedList(new ArrayList());
        final Map<Mob, List<SoundRelay>> mobToRelayedSounds = Collections.synchronizedMap(new WeakHashMap());
        final Map<Mob, Long> mobLastRelayTime = Collections.synchronizedMap(new WeakHashMap());
        final Set<UUID> deserterUuids = Collections.synchronizedSet(new HashSet());
        long lastGroupUpdateTime = -1L;
        final Map<Mob, Set<Mob>> lastEdgeMobMap = new HashMap<Mob, Set<Mob>>();
        long lastCleanupTime = -1L;

        private DimensionGroupData() {
        }
    }

    public static class SoundRelay {
        public final String soundId;
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final double weight;
        public final long timestamp;
        public final int hash;

        public SoundRelay(String soundId, double x, double y, double z, double range, double weight, long timestamp) {
            this.soundId = soundId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.weight = weight;
            this.timestamp = timestamp;
            this.hash = Objects.hash(soundId, (int)x, (int)y, (int)z, (int)range, (int)(weight * 100.0));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoundRelay)) {
                return false;
            }
            SoundRelay other = (SoundRelay)o;
            return this.hash == other.hash && Objects.equals(this.soundId, other.soundId) && Math.abs(this.x - other.x) < 0.1 && Math.abs(this.y - other.y) < 0.1 && Math.abs(this.z - other.z) < 0.1 && Math.abs(this.range - other.range) < 0.1 && Math.abs(this.weight - other.weight) < 0.01 && Math.abs(this.timestamp - other.timestamp) < 40L;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

