/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.SoundAttractConfig;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class VoiceChatIntegrationClient {
    public static void handleClientSound(ClientSoundEvent event) {
        if (!((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
            return;
        }
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        ClientLevel clientWorld = Minecraft.getInstance().level;
        if (clientPlayer == null || clientWorld == null) {
            return;
        }
        short[] rawAudio = event.getRawAudio();
        if (rawAudio == null || rawAudio.length == 0) {
            return;
        }
        double db = VoiceChatIntegrationClient.computePeakDb(rawAudio);
        double normDb = db - -127.0;
        double factor = 0.0;
        List rawMap = (List)SoundAttractConfig.COMMON.voiceChatDbThresholdMap.get();
        if (rawMap != null && !rawMap.isEmpty()) {
            ArrayList<double[]> pairs = new ArrayList<double[]>();
            for (String entry : rawMap) {
                String[] parts;
                if (entry == null || entry.isEmpty() || (parts = entry.split(":", 2)).length != 2) continue;
                try {
                    double th = Double.parseDouble(parts[0].trim());
                    double mul = Double.parseDouble(parts[1].trim());
                    pairs.add(new double[]{th, mul});
                }
                catch (Exception exception) {}
            }
            Collections.sort(pairs, new Comparator<double[]>(){

                @Override
                public int compare(double[] a, double[] b) {
                    return Double.compare(b[0], a[0]);
                }
            });
            for (double[] p : pairs) {
                if (!(normDb >= p[0])) continue;
                factor = p[1];
                break;
            }
        } else {
            factor = normDb >= 50.0 ? 1.0 : (normDb >= 30.0 ? 0.7 : (normDb >= 10.0 ? 0.3 : 0.0));
        }
        boolean isWhispering = event.isWhispering();
        int baseRange = isWhispering ? (Integer)SoundAttractConfig.COMMON.voiceChatWhisperRange.get() : (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
        int effectiveRange = (int)Math.round((double)baseRange * factor);
        if (effectiveRange <= 0) {
            return;
        }
        double weight = (Double)SoundAttractConfig.COMMON.voiceChatWeight.get();
        Vec3 pos = clientPlayer.position();
        ResourceLocation dim = clientWorld.dimension().location();
        Optional<UUID> sourcePlayerUUID = Optional.of(clientPlayer.getUUID());
        String animatorClass = "voice_chat";
        SoundMessage msg = new SoundMessage(SoundMessage.VOICE_CHAT_SOUND_ID, pos, dim, sourcePlayerUUID, effectiveRange, weight, Optional.of(animatorClass), Optional.empty());
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static double computePeakDb(short[] samples) {
        int highest = 0;
        for (short s : samples) {
            int a = Math.abs(s);
            if (a <= highest) continue;
            highest = (short)a;
        }
        if (highest == 0) {
            return -127.0;
        }
        double norm = (double)Math.abs(highest) / 32768.0;
        double db = 20.0 * Math.log10(norm);
        if (!Double.isFinite(db)) {
            return -127.0;
        }
        if (db > 0.0) {
            db = 0.0;
        }
        if (db < -127.0) {
            db = -127.0;
        }
        return db;
    }
}

