/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.PointBlankIntegration;
import com.vicmatskiv.pointblank.item.FireModeInstance;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com.vicmatskiv.pointblank.item.GunItem"}, priority=1100, remap=false)
public abstract class PointBlankGunItemMixin {
    @Inject(method={"hitScanTarget(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;IILnet/minecraft/world/phys/HitResult;DLjava/util/List;)V"}, at={@At(value="HEAD")}, remap=false)
    private void soundattract$onFire(Player player, ItemStack itemStack, int slotIndex, int correlationId, HitResult hitResult, double maxHitScanDistance, List<?> blockPosToDestroy, CallbackInfo ci) {
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enablePointBlankIntegration.get()).booleanValue()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PBMixin] hitScanTarget hooked for {} with item {}", (Object)player, (Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PointBlankIntegration.onGunShoot(serverPlayer, itemStack);
        }
    }

    @Inject(method={"handleClientReloadRequest(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Ljava/util/UUID;ILcom/vicmatskiv/pointblank/item/FireModeInstance;)V"}, at={@At(value="HEAD")}, remap=false)
    private void soundattract$onReloadRequest(ServerPlayer player, ItemStack itemStack, UUID clientStateId, int slotIndex, FireModeInstance fireModeInstance, CallbackInfo ci) {
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enablePointBlankIntegration.get()).booleanValue()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PBMixin] handleClientReloadRequest hooked for {} with item {}", (Object)player, (Object)itemStack);
        }
        PointBlankIntegration.onGunReload(player, itemStack);
    }
}

