/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2354;
import net.minecraft.class_2386;
import net.minecraft.class_2389;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;

public class FovEvents {
    private static final double BACKSTAB_DAMAGE_MULTIPLIER = 1.2;
    private static final FovData DEFAULT_FOV = new FovData(200.0, 135.0);
    private static final Set<class_1299<?>> DEVELOPER_EXCLUSIONS = Set.of(class_1299.field_38095, class_1299.field_6116, class_1299.field_6119);
    private static Map<class_2960, FovData> CONFIG_FOV_CACHE = null;
    private static Set<class_2960> USER_EXCLUSION_CACHE = null;
    private static Set<class_2960> NON_BLOCKING_VISION_ALLOW = null;

    public static void buildCaches() {
        if (SoundAttractMod.CONFIG == null) {
            SoundAttractMod.LOGGER.warn("[FovEvents] Attempted to build caches before config was loaded!");
            return;
        }
        USER_EXCLUSION_CACHE = new HashSet<class_2960>();
        List<String> exclusionList = SoundAttractMod.CONFIG.fovExclusionList;
        for (String string : exclusionList) {
            try {
                class_2960 class_29602 = class_2960.method_12829((String)string.trim());
                if (class_29602 != null) {
                    USER_EXCLUSION_CACHE.add(class_29602);
                    continue;
                }
                SoundAttractMod.LOGGER.warn("[FOV Config] Failed to parse exclusion entry: " + string);
            }
            catch (Exception exception) {
                SoundAttractMod.LOGGER.error("[FOV Config] Error processing exclusion entry: " + string, (Throwable)exception);
            }
        }
        SoundAttractMod.LOGGER.info("[FOV Config] Loaded {} user-defined exclusions.", (Object)USER_EXCLUSION_CACHE.size());
        CONFIG_FOV_CACHE = new HashMap<class_2960, FovData>();
        List<Object> overrideList = SoundAttractMod.CONFIG.fovOverrides != null ? SoundAttractMod.CONFIG.fovOverrides : Collections.emptyList();
        for (String string : overrideList) {
            try {
                String[] stringArray = string.split(",");
                if (stringArray.length != 3) {
                    SoundAttractMod.LOGGER.warn("[FOV Config] Malformed FOV override, skipping: " + string);
                    continue;
                }
                class_2960 mobId = class_2960.method_12829((String)stringArray[0].trim());
                double h = Double.parseDouble(stringArray[1].trim());
                double v = Double.parseDouble(stringArray[2].trim());
                if (mobId != null) {
                    CONFIG_FOV_CACHE.put(mobId, new FovData(h, v));
                    continue;
                }
                SoundAttractMod.LOGGER.warn("[FOV Config] Malformed mob identifier in override, skipping: " + string);
            }
            catch (Exception exception) {
                SoundAttractMod.LOGGER.error("[FOV Config] Failed to parse FOV override entry: " + string, (Throwable)exception);
            }
        }
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[FOV Config] Loaded {} custom FOV overrides.", (Object)CONFIG_FOV_CACHE.size());
        }
        NON_BLOCKING_VISION_ALLOW = new HashSet<class_2960>();
        List<Object> list = SoundAttractMod.CONFIG.nonBlockingVisionAllowList != null ? SoundAttractMod.CONFIG.nonBlockingVisionAllowList : Collections.emptyList();
        for (String string : list) {
            try {
                class_2960 id = class_2960.method_12829((String)string.trim());
                if (id != null) {
                    NON_BLOCKING_VISION_ALLOW.add(id);
                    continue;
                }
                SoundAttractMod.LOGGER.warn("[FOV Config] Malformed nonBlockingVisionAllowList entry: {}", (Object)string);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.error("[FOV Config] Error processing nonBlockingVisionAllowList entry: {}", (Object)string, (Object)e);
            }
        }
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[FOV Config] Loaded {} non-blocking vision allowlist entries.", (Object)NON_BLOCKING_VISION_ALLOW.size());
        }
    }

    public static float getModifiedDamage(class_1309 target, class_1282 source, float amount) {
        if (!(target instanceof class_1308)) {
            return amount;
        }
        class_1308 mob = (class_1308)target;
        class_1297 attacker = source.method_5529();
        if (attacker == null || attacker == mob) {
            return amount;
        }
        if (!FovEvents.isTargetInFov(mob, attacker, true)) {
            float newDamage = (float)((double)amount * 1.2);
            if (attacker instanceof class_1657) {
                mob.method_37908().method_43128(null, mob.method_23317(), mob.method_23318(), mob.method_23321(), class_3417.field_15016, mob.method_5634(), 1.0f, 1.2f);
            }
            return newDamage;
        }
        return amount;
    }

    public static boolean isTargetInFov(class_1308 looker, class_1297 target, boolean checkObstructions) {
        if (USER_EXCLUSION_CACHE == null || CONFIG_FOV_CACHE == null) {
            SoundAttractMod.LOGGER.warn("[FovEvents] Caches not built, using default behavior. This should only happen if config fails to load.");
            return true;
        }
        class_2960 lookerId = class_7923.field_41177.method_10221((Object)looker.method_5864());
        if (DEVELOPER_EXCLUSIONS.contains(looker.method_5864())) {
            return true;
        }
        if (USER_EXCLUSION_CACHE.contains(lookerId)) {
            return true;
        }
        FovData fov = CONFIG_FOV_CACHE.getOrDefault(lookerId, DEFAULT_FOV);
        if (fov.horizontal() >= 360.0) {
            return true;
        }
        if (checkObstructions && !FovEvents.hasSmartLineOfSight(looker, target)) {
            return false;
        }
        return FovEvents.isWithinFieldOfView(looker, target, fov.horizontal(), fov.vertical());
    }

    private static boolean isWithinFieldOfView(class_1308 looker, class_1297 target, double horizontalFovDegrees, double verticalFovDegrees) {
        class_243 targetHorizontal;
        class_243 lookVector = looker.method_5720();
        class_243 toTargetVector = target.method_19538().method_1031(0.0, (double)target.method_18381(target.method_18376()) / 2.0, 0.0).method_1020(looker.method_33571()).method_1029();
        class_243 lookHorizontal = new class_243(lookVector.field_1352, 0.0, lookVector.field_1350).method_1029();
        double dotHorizontal = lookHorizontal.method_1026(targetHorizontal = new class_243(toTargetVector.field_1352, 0.0, toTargetVector.field_1350).method_1029());
        double angleHorizontal = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotHorizontal))));
        if (angleHorizontal > horizontalFovDegrees / 2.0) {
            return false;
        }
        double pitchLook = Math.toDegrees(Math.asin(lookVector.field_1351));
        double pitchTarget = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.field_1351))));
        double angleVertical = Math.abs(pitchTarget - pitchLook);
        return angleVertical <= verticalFovDegrees / 2.0;
    }

    public static boolean hasSmartLineOfSight(class_1308 looker, class_1297 target) {
        class_1937 world = looker.method_37908();
        class_243 eyeToEye = target.method_33571();
        class_243 center = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 feet = target.method_19538().method_1031(0.0, Math.max(0.1, (double)target.method_17682() * 0.15), 0.0);
        class_243 start = looker.method_33571();
        return FovEvents.raycastIgnoringNonBlocking(world, start, eyeToEye, looker) || FovEvents.raycastIgnoringNonBlocking(world, start, center, looker) || FovEvents.raycastIgnoringNonBlocking(world, start, feet, looker);
    }

    private static boolean raycastIgnoringNonBlocking(class_1937 world, class_243 start, class_243 end, class_1308 looker) {
        int maxPassThroughs = 24;
        class_243 currStart = start;
        class_243 dir = end.method_1020(start);
        double totalDist = dir.method_1033();
        if (totalDist < 1.0E-4) {
            return true;
        }
        dir = dir.method_1029();
        for (int i = 0; i < 24; ++i) {
            class_3959 ctx = new class_3959(currStart, end, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)looker);
            class_3965 hit = world.method_17742(ctx);
            if (hit.method_17783() == class_239.class_240.field_1333) {
                return true;
            }
            if (hit instanceof class_3965) {
                class_3965 bhr = hit;
                class_2338 pos = bhr.method_17777();
                class_2680 state = world.method_8320(pos);
                if (FovEvents.isNonBlockingVision(state, world, pos)) {
                    class_243 step = dir.method_1021(0.6);
                    currStart = bhr.method_17784().method_1019(step);
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) continue;
                    try {
                        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                        SoundAttractMod.LOGGER.debug("[SmartLOS] Passing through {} at {}", (Object)id, (Object)pos);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    try {
                        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                        SoundAttractMod.LOGGER.debug("[SmartLOS] Blocked by {} at {}", (Object)id, (Object)pos);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean isNonBlockingVision(class_2680 state, class_1937 world, class_2338 pos) {
        Boolean open;
        if (state == null || world == null || pos == null) {
            return false;
        }
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26204() instanceof class_2323 && (open = (Boolean)state.method_11654((class_2769)class_2323.field_10945)) != null && open.booleanValue()) {
            return true;
        }
        if (state.method_26204() instanceof class_2533 && (open = (Boolean)state.method_11654((class_2769)class_2533.field_11631)) != null && open.booleanValue()) {
            return true;
        }
        try {
            class_2960 bid = class_7923.field_41175.method_10221((Object)state.method_26204());
            if (bid != null && NON_BLOCKING_VISION_ALLOW.contains(bid)) {
                return true;
            }
        }
        catch (Throwable bid) {
            // empty catch block
        }
        try {
            String path;
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            String string = path = id != null ? id.method_12832() : "";
            if (path.contains("glass") && !path.contains("tinted")) {
                return true;
            }
        }
        catch (Throwable id) {
            // empty catch block
        }
        if (state.method_26204() instanceof class_2386 || state.method_27852(class_2246.field_10225) || state.method_27852(class_2246.field_10384)) {
            return true;
        }
        if (state.method_26204() instanceof class_2354 || state.method_26204() instanceof class_2544 || state.method_26204() instanceof class_2389) {
            return true;
        }
        class_265 shape = state.method_26194((class_1922)world, pos, class_3726.method_16194());
        if (shape.method_1110()) {
            return true;
        }
        try {
            if (!state.method_26230((class_1922)world, pos)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private record FovData(double horizontal, double vertical) {
    }
}

