/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.EdgeRelayManager;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.mixin.MobEntityAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class SoundAttractionEvents {
    private static final double IDLE_THRESHOLD_SQ = 1.0E-6;
    private static final double CRAWLING_THRESHOLD_SQ = 9.0E-4;
    private static final double SNEAKING_SPEED_SQ = 0.0043560000000000005;
    private static final double WALKING_SPEED_SQ = 0.046655999999999996;

    public static void onServerTick(MinecraftServer server) {
        for (class_3218 serverWorld : server.method_3738()) {
            SoundAttractionEvents.onWorldTick(serverWorld);
        }
    }

    private static void processWorldTick(class_3218 serverWorld) {
        MobGroupManager.scheduleNearbyCellsForPlayers(serverWorld, serverWorld.method_8510());
        DynamicScanCooldownManager.tickScheduler(serverWorld, serverWorld.method_8510());
        if (SoundAttractMod.CONFIG == null) {
            SoundAttractMod.LOGGER.error("[SoundAttractionEvents] CONFIG is null in onServerTick! Skipping tick.");
            return;
        }
        if (!DynamicScanCooldownManager.shouldScanThisTick(0L, serverWorld.method_8510())) {
            return;
        }
        try {
            HashSet<String> attractedTypes = new HashSet<String>();
            for (String o : SoundAttractMod.CONFIG.attractedEntities) {
                attractedTypes.add(o.toString());
            }
            ArrayList<class_1308> mobEntities = new ArrayList<class_1308>();
            for (class_1297 entity : serverWorld.method_27909()) {
                class_1308 mob2;
                String mobTypeId;
                if (!(entity instanceof class_1308) || !attractedTypes.contains(mobTypeId = class_7923.field_41177.method_10221((Object)(mob2 = (class_1308)entity).method_5864()).toString())) continue;
                mobEntities.add(mob2);
            }
            for (SoundTracker.SoundRecord sound : SoundTracker.getRecentSounds((class_1937)serverWorld)) {
                MobGroupManager.scheduleCellsForSound(sound.pos, sound.range, serverWorld, serverWorld.method_8510());
                List<class_1308> mobs = SoundTracker.getMobsForSound(mobEntities, sound, mob -> MobGroupManager.isEdgeMobEntity(mob) || MobGroupManager.getLeader(mob) == mob || MobGroupManager.isDeserter(mob));
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Processing sound at {} (range={}) found {} eligible mobs", new Object[]{sound.pos, sound.range, mobs.size()});
                }
                for (class_1308 mob3 : mobs) {
                    boolean isLeader = MobGroupManager.getLeader(mob3) == mob3;
                    boolean isEdge = MobGroupManager.isEdgeMobEntity(mob3);
                    boolean isDeserter = MobGroupManager.isDeserter(mob3);
                    if (isDeserter) {
                        AttractionGoal.handleSoundAttraction(mob3, sound);
                        if (!SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Deserter {} acts on sound {}", (Object)mob3.method_5667(), (Object)sound.pos);
                        continue;
                    }
                    if (isEdge) {
                        class_1308 leader;
                        if (!SoundAttractMod.CONFIG.edgeMobSmartBehavior) {
                            class_1308 leader2 = MobGroupManager.getLeader(mob3);
                            if (leader2 == null || leader2 == mob3 || !(leader2.method_5858((class_1297)mob3) <= sound.range * sound.range)) continue;
                            AttractionGoal.handleRelayToLeader(leader2, sound, mob3);
                            if (!SoundAttractMod.CONFIG.debugLogging) continue;
                            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Edge {} relays sound {} to leader {} immediately", new Object[]{mob3.method_5667(), sound.pos, leader2.method_5667()});
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        EdgeRelayManager.RelayState state = EdgeRelayManager.getRelayState(mob3);
                        if (state == null) {
                            EdgeRelayManager.startRelay(mob3, sound.pos, 120000L, now);
                            AttractionGoal.handleEdgeInvestigate(mob3, sound);
                            if (!SoundAttractMod.CONFIG.debugLogging) continue;
                            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Edge {} starts delayed relay for sound {}", (Object)mob3.method_5667(), (Object)sound.pos);
                            continue;
                        }
                        if (state.cancelled || state.completed || now - state.startTime <= state.delayMillis || (leader = MobGroupManager.getLeader(mob3)) == null || leader == mob3) continue;
                        AttractionGoal.handleRelayToLeader(leader, sound, mob3);
                        EdgeRelayManager.completeRelay(mob3);
                        if (!SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Edge {} delayed relay expired, relaying sound {} to leader {}", new Object[]{mob3.method_5667(), sound.pos, leader.method_5667()});
                        continue;
                    }
                    if (!isLeader) continue;
                    AttractionGoal.handleLeaderObjective(mob3, sound);
                    if (!SoundAttractMod.CONFIG.debugLogging) continue;
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Leader {} ready to update group objective for sound {}", (Object)mob3.method_5667(), (Object)sound.pos);
                }
            }
            DynamicScanCooldownManager.update(serverWorld.method_8510(), mobEntities.size());
            SoundTracker.tick((class_1937)serverWorld);
            BlockBreakerManager.processPendingActions();
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Exception in onServerTick", (Throwable)e);
        }
    }

    public static void onWorldTick(class_3218 serverWorld) {
        SoundTracker.pruneIrrelevantSounds((class_1937)serverWorld);
        DynamicScanCooldownManager.update(serverWorld.method_8510(), 0);
        if (!DynamicScanCooldownManager.shouldScanThisTick(0L, serverWorld.method_8510())) {
            return;
        }
        MobGroupManager.updateGroups(serverWorld);
        SoundAttractionEvents.processWorldTick(serverWorld);
        BlockBreakerManager.processPendingActions();
    }

    public static void onEntityJoinWorld(class_1308 mob) {
        boolean followLeaderGoalExists;
        class_2960 entityId = class_7923.field_41177.method_10221((Object)mob.method_5864());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        if (!SoundAttractMod.CONFIG.attractedEntities.contains(entityIdStr)) {
            return;
        }
        double moveSpeed = SoundAttractMod.CONFIG.mobMoveSpeed;
        boolean attractionGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof AttractionGoal);
        if (!attractionGoalExists) {
            ((MobEntityAccessor)mob).getGoalSelector().method_6277(3, (class_1352)new AttractionGoal(mob, moveSpeed));
        }
        if (!(followLeaderGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof FollowLeaderGoal))) {
            ((MobEntityAccessor)mob).getGoalSelector().method_6277(3, (class_1352)new FollowLeaderGoal(mob, moveSpeed));
        }
    }

    public static void onEntityJoinWorld(class_1308 mob, class_3218 level) {
        if (level.method_8608()) {
            return;
        }
        HashSet<String> attractedTypes = new HashSet<String>();
        for (String o : SoundAttractMod.CONFIG.attractedEntities) {
            attractedTypes.add(o.toString());
        }
        String mobTypeId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        if (attractedTypes.contains(mobTypeId)) {
            MobGroupManager.updateGroups(level);
        }
    }

    public static class SoundMapping {
        public final class_2960 soundEvent;
        public final int range;
        public final double weight;

        public SoundMapping(class_2960 soundEvent, int range, double weight) {
            this.soundEvent = soundEvent;
            this.range = range;
            this.weight = weight;
        }

        public static SoundMapping forAnimator(Class<?> animatorClass) {
            return null;
        }
    }

    private static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

