/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.mixin.MobEntityAccessor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4135;

public class AttractionGoal
extends class_1352 {
    private final class_1308 mob;
    private final double moveSpeed;
    private class_2338 targetSoundPos;
    private double currentTargetWeight = -1.0;
    private SoundTracker.SoundRecord cachedSound = null;
    private int scanTickCounter = 0;
    private boolean isPursuingSound = false;
    private int pursuingSoundTicksRemaining = 0;
    private class_2338 lastNavigationTarget;
    private int edgeTickCounter = 0;
    private int deserterTickCounter = 0;
    private class_243 chosenDest = null;
    private boolean hasPicked = false;
    private int stuckTicks = 0;
    private class_243 lastPosVec = null;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private EdgeMobState edgeMobState = null;
    private boolean foundPlayerOrHit = false;
    private boolean relayedToLeader = false;
    private int edgeArrivalTicks = 0;
    private SoundTracker.SoundRecord cachedBestSound;
    private int bestSoundCacheTicks;
    private static final Map<class_1308, DelayedRelay> pendingDelayedRelays = new HashMap<class_1308, DelayedRelay>();

    public AttractionGoal(class_1308 mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.scanTickCounter = 0;
    }

    private double getArrivalDistance() {
        return SoundAttractMod.CONFIG.arrivalDistance;
    }

    private int getWaitTicks() {
        return SoundAttractMod.CONFIG.scanCooldownTicks;
    }

    public class_2338 getTargetSoundPos() {
        return this.targetSoundPos;
    }

    public void method_6269() {
        if (MobGroupManager.getLeader(this.mob) == this.mob) {
            List<MobGroupManager.SoundRelay> consumed = MobGroupManager.consumeRelayedSounds(this.mob);
            if (SoundAttractMod.CONFIG.debugLogging && !consumed.isEmpty()) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Leader {} has consumed {} relayed sounds upon starting goal.", (Object)this.mob.method_5477().getString(), (Object)consumed.size());
            }
        }
    }

    public boolean method_6264() {
        if (this.isPursuingSound && this.targetSoundPos != null) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] canStart() is TRUE for {} because it was given an external target: {}", (Object)this.mob.method_5477().getString(), (Object)this.targetSoundPos);
            }
            return true;
        }
        if (this.mob.method_5765() || this.mob.method_6113() || this.mob.method_5968() != null) {
            return false;
        }
        if (this.scanTickCounter > 0) {
            --this.scanTickCounter;
            return false;
        }
        SoundTracker.SoundRecord newSound = this.findInterestingSoundRecord();
        this.scanTickCounter = SoundAttractMod.CONFIG.scanCooldownTicks;
        if (newSound == null) {
            return false;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] canStart() is TRUE for {} because it found a sound on its own: pos={}, range={}, weight={}", new Object[]{this.mob.method_5477().getString(), newSound.pos, String.format("%.2f", newSound.range), String.format("%.2f", newSound.weight)});
        }
        this.cachedSound = newSound;
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.isPursuingSound = true;
        this.pursuingSoundTicksRemaining = newSound.ticksRemaining;
        return true;
    }

    public boolean method_6266() {
        if (this.mob.method_5765() || this.mob.method_6113() || this.mob.method_5968() != null) {
            return false;
        }
        boolean pursuing = this.isPursuingSound && this.targetSoundPos != null;
        return pursuing || this.blockBreakerGoal != null;
    }

    public void method_6270() {
        boolean navIdle = this.mob.method_5942().method_6357();
        if (this.blockBreakerGoal != null) {
            BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
            this.blockBreakerGoal = null;
        }
        this.mob.method_5942().method_6340();
        this.lastNavigationTarget = null;
        this.stuckTicks = 0;
        this.lastPosVec = null;
        this.chosenDest = null;
        this.hasPicked = false;
        this.edgeMobState = null;
        this.foundPlayerOrHit = false;
        this.relayedToLeader = false;
        this.edgeArrivalTicks = 0;
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] Goal stopped for {}. pursuingSound={}, target={}, breakerActive(beforeStop)=false, navIdle={}", new Object[]{this.mob.method_5477().getString(), this.isPursuingSound, this.targetSoundPos, navIdle});
        }
    }

    public void method_6268() {
        boolean hasArrived;
        boolean isLeader;
        class_1308 leader = MobGroupManager.getLeader(this.mob);
        boolean bl = isLeader = leader == this.mob;
        if (isLeader && SoundAttractMod.CONFIG.debugLogging && this.isPursuingSound) {
            SoundAttractMod.LOGGER.info("[AttractionGoal Tick] Leader {} is ticking. Target: {}. Is navigation idle? {}", new Object[]{this.mob.method_5477().getString(), this.targetSoundPos, this.mob.method_5942().method_6357()});
        }
        boolean isFollower = !isLeader;
        boolean smartEdgeEnabled = SoundAttractMod.CONFIG.edgeMobSmartBehavior;
        if (this.bestSoundCacheTicks > 0) {
            --this.bestSoundCacheTicks;
        }
        if (!this.isPursuingSound || this.targetSoundPos == null) {
            return;
        }
        if (this.blockBreakerGoal != null) {
            boolean running = false;
            try {
                running = ((MobEntityAccessor)this.mob).getGoalSelector().method_35115().stream().anyMatch(w -> w.method_19058() == this.blockBreakerGoal && w.method_19056());
            }
            catch (ClassCastException e) {
                SoundAttractMod.LOGGER.error("[AttractionGoal] Failed to access goal selector for running goals.", (Throwable)e);
            }
            if (running) {
                SoundTracker.SoundRecord bestPossible = SoundTracker.findNearestSound(this.mob.method_37908(), this.mob, this.mob.method_24515(), this.mob.method_33571());
                if (bestPossible != null && this.cachedSound != null) {
                    boolean sameId = Objects.equals(bestPossible.soundId, this.cachedSound.soundId);
                    boolean samePos = bestPossible.pos.equals((Object)this.cachedSound.pos);
                    double switchRatio = SoundAttractMod.CONFIG.soundSwitchRatio;
                    if (!(sameId && samePos || !(bestPossible.weight > this.cachedSound.weight * switchRatio))) {
                        if (SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[AttractionGoal] Mining mob {} found a better sound ({} > {}). Stopping block breaking.", new Object[]{this.mob.method_5477().getString(), bestPossible.weight, this.cachedSound.weight});
                        }
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                        this.method_6270();
                        return;
                    }
                }
                class_243 cp = this.mob.method_19538();
                if (this.lastPosVec != null && cp.method_1025(this.lastPosVec) >= 1.0) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                    this.stuckTicks = 0;
                    this.lastPosVec = cp;
                }
                return;
            }
            this.blockBreakerGoal = null;
        }
        if (this.pursuingSoundTicksRemaining > 0) {
            --this.pursuingSoundTicksRemaining;
        } else {
            this.isPursuingSound = false;
            return;
        }
        SoundTracker.SoundRecord freshSound = this.findInterestingSoundRecord();
        if (freshSound != null && !freshSound.pos.equals((Object)this.targetSoundPos)) {
            double switchRatio = SoundAttractMod.CONFIG.soundSwitchRatio;
            boolean isBetterByWeight = freshSound.weight > this.currentTargetWeight * switchRatio;
            boolean isTieButCloser = false;
            if (!isBetterByWeight && Math.abs(freshSound.weight - this.currentTargetWeight) < 0.001) {
                double currentDistSq;
                double freshDistSq = freshSound.pos.method_10262((class_2382)this.mob.method_24515());
                boolean bl2 = isTieButCloser = freshDistSq < (currentDistSq = this.targetSoundPos.method_10262((class_2382)this.mob.method_24515()));
            }
            if (isBetterByWeight || isTieButCloser) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] {} stopping pursuit: better or closer sound appeared (betterByWeight={}, tieButCloser={}).", new Object[]{this.mob.method_5477().getString(), isBetterByWeight, isTieButCloser});
                }
                this.isPursuingSound = false;
                return;
            }
        }
        class_243 currentPos = this.mob.method_19538();
        if (this.lastPosVec != null && currentPos.method_1025(this.lastPosVec) < 0.01) {
            ++this.stuckTicks;
            if (SoundAttractMod.CONFIG.debugLogging && this.stuckTicks % 10 == 0) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] {} appears stuck for {} ticks at {}", new Object[]{this.mob.method_5477().getString(), this.stuckTicks, this.mob.method_24515()});
            }
            if (this.stuckTicks >= 10) {
                this.mob.method_5942().method_6340();
                if (SoundAttractMod.CONFIG.enableBlockBreaking && this.targetSoundPos != null && this.blockBreakerGoal == null) {
                    BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
                    BlockBreakerManager.scheduleAdd(this.mob, breaker, 0);
                    this.blockBreakerGoal = breaker;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] Scheduling BlockBreakerPosGoal for {} toward {}", (Object)this.mob.method_5477().getString(), (Object)this.targetSoundPos);
                    }
                } else if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Stuck detected but not scheduling breaker. enableBlockBreaking={} targetSoundPos={}", (Object)SoundAttractMod.CONFIG.enableBlockBreaking, (Object)this.targetSoundPos);
                }
                this.stuckTicks = 0;
            }
        } else {
            this.stuckTicks = 0;
            this.lastPosVec = currentPos;
        }
        double arrivalDistSq = this.getArrivalDistance() * this.getArrivalDistance();
        double distSqToTarget = this.mob.method_19538().method_1025(class_243.method_24953((class_2382)this.targetSoundPos));
        boolean bl3 = hasArrived = distSqToTarget < arrivalDistSq;
        if (isLeader) {
            List<MobGroupManager.SoundRelay> relays = MobGroupManager.peekRelayedSounds(this.mob);
            if (relays != null && !relays.isEmpty() && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("Leader {} received {} sound relays.", (Object)this.mob.method_5477().getString(), (Object)relays.size());
            }
            if (this.blockBreakerGoal == null && SoundAttractMod.CONFIG.enableBlockBreaking && this.targetSoundPos != null && this.mob.method_5942().method_6357() && distSqToTarget > 4.0) {
                BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
                BlockBreakerManager.scheduleAdd(this.mob, breaker, 0);
                this.blockBreakerGoal = breaker;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Nav idle fallback: scheduling BlockBreakerPosGoal for {} toward {}", (Object)this.mob.method_5477().getString(), (Object)this.targetSoundPos);
                }
            }
            if (hasArrived) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] {} arrived at target {}, stopping pursuit.", (Object)this.mob.method_5477().getString(), (Object)this.targetSoundPos);
                }
                this.isPursuingSound = false;
                return;
            }
            if (this.chosenDest != null) {
                this.navigateTo(class_2338.method_49638((class_2374)this.chosenDest), this.moveSpeed);
            }
        } else if (isFollower && smartEdgeEnabled) {
            if (this.edgeMobState == null) {
                this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
            }
            if (this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
                this.navigateTo(this.targetSoundPos, this.moveSpeed);
                if (hasArrived) {
                    ++this.edgeArrivalTicks;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("Follower {} arrived at sound, waiting... (ticks={})", (Object)this.mob.method_5477().getString(), (Object)this.edgeArrivalTicks);
                    }
                    if (this.edgeArrivalTicks >= 40) {
                        this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                    }
                } else if (SoundAttractMod.CONFIG.enableBlockBreaking && this.mob.method_37908().method_8510() % 20L == 0L) {
                    double maxRange = SoundAttractMod.CONFIG.standingDetectionRange * 2.0;
                    class_238 searchBox = new class_238(this.mob.method_24515()).method_1014(maxRange);
                    List playersNearby = this.mob.method_37908().method_8390(class_1657.class, searchBox, class_1309::method_5805);
                    for (class_1657 p : playersNearby) {
                        boolean trulyStuck;
                        if (!FovEvents.hasSmartLineOfSight(this.mob, (class_1297)p)) continue;
                        double detectRange = StealthDetectionEvents.computeFullDetectionRange(this.mob, p, this.mob.method_37908());
                        if ((double)p.method_5739((class_1297)this.mob) > detectRange) continue;
                        class_2338 playerPos = p.method_24515();
                        boolean pathStarted = this.mob.method_5942().method_6335((class_1297)p, this.moveSpeed);
                        boolean navIdle = this.mob.method_5942().method_6357();
                        boolean bl4 = trulyStuck = this.stuckTicks >= 10;
                        if (pathStarted && !navIdle && !trulyStuck) continue;
                        if (!this.mob.method_5942().method_6357()) {
                            this.mob.method_5942().method_6340();
                        }
                        if (this.blockBreakerGoal != null) {
                            BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                            this.blockBreakerGoal = null;
                        }
                        BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, playerPos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, false, false, false);
                        BlockBreakerManager.scheduleAdd(this.mob, breaker, 0);
                        this.blockBreakerGoal = breaker;
                        if (SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[AttractionGoal] Pre-arrival FORCE Scheduling BlockBreakerPosGoal for {} toward detected player {} at {} (pathStarted={}, navIdle={}, stuckTicks={})", new Object[]{this.mob.method_5477().getString(), p.method_5477().getString(), playerPos, pathStarted, navIdle, this.stuckTicks});
                        }
                        this.stuckTicks = 0;
                        break;
                    }
                }
            } else if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
                if (leader != null && !leader.method_31481()) {
                    this.navigateTo(leader.method_24515(), this.moveSpeed * 0.8);
                    if (this.mob.method_19538().method_1025(leader.method_19538()) < arrivalDistSq) {
                        if (SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("Follower {} has returned to leader {}.", (Object)this.mob.method_5477().getString(), (Object)leader.method_5477().getString());
                        }
                        this.isPursuingSound = false;
                    }
                } else {
                    this.isPursuingSound = false;
                }
            }
        } else {
            if (hasArrived) {
                this.isPursuingSound = false;
                return;
            }
            this.navigateTo(this.targetSoundPos, this.moveSpeed);
        }
    }

    private void handleSmartEdgeDeserterLogic(boolean isEdge, boolean isDeserter) {
        class_1308 leader = MobGroupManager.getLeader(this.mob);
        if (this.edgeMobState == null) {
            SoundTracker.SoundRecord soundToInvestigate = this.findInterestingSoundRecord();
            if (soundToInvestigate != null) {
                this.cachedSound = soundToInvestigate;
                this.targetSoundPos = this.cachedSound.pos;
                this.currentTargetWeight = this.cachedSound.weight;
                this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
                this.foundPlayerOrHit = false;
                this.relayedToLeader = false;
                this.edgeArrivalTicks = 0;
                this.mob.method_5942().method_6340();
                if (leader != null && leader != this.mob && this.targetSoundPos != null) {
                    long triggerTime = this.mob.method_37908().method_8510() + (long)SoundAttractMod.CONFIG.delayedRelayTicks;
                    DelayedRelay relay = new DelayedRelay(leader, this.targetSoundPos, triggerTime);
                    pendingDelayedRelays.put(this.mob, relay);
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] Smart {} {} scheduled delayed relay to {} for sound at {} (trigger @ {})", new Object[]{isEdge ? "Edge" : "Deserter", this.mob.method_5477().getString(), leader.method_5477().getString(), this.targetSoundPos, triggerTime});
                    }
                }
            } else {
                this.cachedSound = null;
                this.targetSoundPos = null;
                this.currentTargetWeight = -1.0;
                if (leader != null && leader != this.mob && (double)this.mob.method_5739((class_1297)leader) > 16.0) {
                    this.mob.method_5942().method_6335((class_1297)leader, this.moveSpeed * 0.8);
                }
                return;
            }
        }
        if (this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            if (this.targetSoundPos == null) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.warn("[AttractionGoal] Smart {} {} lost targetSoundPos in GOING_TO_SOUND", (Object)(isEdge ? "Edge" : "Deserter"), (Object)this.mob.method_5477().getString());
                }
                this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                this.mob.method_5942().method_6340();
                return;
            }
            this.mob.method_5942().method_6337((double)this.targetSoundPos.method_10263() + 0.5, (double)this.targetSoundPos.method_10264() + 0.5, (double)this.targetSoundPos.method_10260() + 0.5, this.moveSpeed);
            if (this.mob.method_19538().method_1022(class_243.method_24953((class_2382)this.targetSoundPos)) < this.getArrivalDistance()) {
                ++this.edgeArrivalTicks;
                this.mob.method_5942().method_6340();
                double maxRange = SoundAttractMod.CONFIG.standingDetectionRange * 2.0;
                class_238 searchBox = new class_238(this.targetSoundPos).method_1014(maxRange);
                List playersAtSound = this.mob.method_37908().method_8390(class_1657.class, searchBox, class_1309::method_5805);
                class_1657 detectedPlayer = null;
                for (class_1657 player : playersAtSound) {
                    double actualDetectionRange = StealthDetectionEvents.computeFullDetectionRange(this.mob, player, this.mob.method_37908());
                    if (!((double)player.method_5739((class_1297)this.mob) <= actualDetectionRange)) continue;
                    detectedPlayer = player;
                    break;
                }
                if (detectedPlayer != null) {
                    this.foundPlayerOrHit = true;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] Smart {} {} detected player {} near sound at {} (ticks at spot={})", new Object[]{isEdge ? "Edge" : "Deserter", this.mob.method_5477().getString(), detectedPlayer.method_5477().getString(), this.targetSoundPos, this.edgeArrivalTicks});
                    }
                    if (SoundAttractMod.CONFIG.enableBlockBreaking) {
                        class_2338 playerPos = detectedPlayer.method_24515();
                        if (!this.mob.method_5942().method_6357()) {
                            this.mob.method_5942().method_6340();
                        }
                        if (this.blockBreakerGoal != null) {
                            BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                            this.blockBreakerGoal = null;
                        }
                        BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, playerPos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, false, false, false);
                        BlockBreakerManager.scheduleAdd(this.mob, breaker, 0);
                        this.blockBreakerGoal = breaker;
                        if (SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[AttractionGoal] FORCE Scheduling BlockBreakerPosGoal for {} toward detected player {} at {}", new Object[]{this.mob.method_5477().getString(), detectedPlayer.method_5477().getString(), playerPos});
                        }
                        this.stuckTicks = 0;
                    }
                }
            }
        } else if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            if (leader == null || leader == this.mob || !leader.method_5805()) {
                this.edgeMobState = null;
                this.mob.method_5942().method_6340();
                if (pendingDelayedRelays.containsKey(this.mob)) {
                    AttractionGoal.pendingDelayedRelays.get((Object)this.mob).cancelled = true;
                }
                return;
            }
            this.mob.method_5942().method_6335((class_1297)leader, this.moveSpeed);
            if ((double)this.mob.method_5739((class_1297)leader) < this.getArrivalDistance() + 2.0) {
                if (this.foundPlayerOrHit && !this.relayedToLeader && this.targetSoundPos != null && this.cachedSound != null) {
                    MobGroupManager.relaySoundToLeader(this.mob, this.targetSoundPos.method_10263(), this.targetSoundPos.method_10264(), this.targetSoundPos.method_10260(), this.cachedSound.range, this.cachedSound.weight, this.mob.method_37908().method_8510());
                    this.relayedToLeader = true;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] Smart {} {} relayed sound (player found) at {} to leader {}.", new Object[]{isEdge ? "Edge" : "Deserter", this.mob.method_5477().getString(), this.targetSoundPos, leader.method_5477().getString()});
                    }
                } else if (!this.foundPlayerOrHit && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Smart {} {} returned to leader {}, found nothing at sound.", new Object[]{isEdge ? "Edge" : "Deserter", this.mob.method_5477().getString(), leader.method_5477().getString()});
                }
                if (pendingDelayedRelays.containsKey(this.mob)) {
                    AttractionGoal.pendingDelayedRelays.get((Object)this.mob).cancelled = true;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] Delayed relay for {} cancelled (returned to leader).", (Object)this.mob.method_5477().getString());
                    }
                }
                this.edgeMobState = null;
                this.foundPlayerOrHit = false;
                this.relayedToLeader = false;
                this.edgeArrivalTicks = 0;
                this.cachedSound = null;
                this.targetSoundPos = null;
                this.currentTargetWeight = -1.0;
                this.mob.method_5942().method_6340();
            }
        }
    }

    private void navigateTo(class_2338 targetPos, double speed) {
        if (targetPos == null) {
            if (!this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6340();
            }
            return;
        }
        if (targetPos.equals((Object)this.lastNavigationTarget) && !this.mob.method_5942().method_6357()) {
            return;
        }
        this.mob.method_5942().method_6337((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() + 0.5, speed);
        this.lastNavigationTarget = targetPos;
    }

    private SoundTracker.SoundRecord findInterestingSoundRecord() {
        SoundTracker.SoundRecord finalDecisionSound;
        SoundTracker.SoundRecord bestNewSoundEvent;
        if (this.bestSoundCacheTicks > 0) {
            if (this.cachedBestSound != null && SoundTracker.getRecentSounds(this.mob.method_37908()).contains(this.cachedBestSound)) {
                this.cachedBestSound = null;
            }
            return this.cachedBestSound;
        }
        this.bestSoundCacheTicks = 10;
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            this.cachedBestSound = null;
            return null;
        }
        class_2338 mobPos = this.mob.method_24515();
        class_1308 leader = MobGroupManager.getLeader(this.mob);
        if (leader == this.mob) {
            SoundTracker.SoundRecord directSound = SoundTracker.findNearestSound(world, this.mob, mobPos, this.mob.method_33571());
            List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
            bestNewSoundEvent = directSound;
            if (relays != null) {
                for (MobGroupManager.SoundRelay relay : relays) {
                    SoundTracker.SoundRecord relayedSoundAsRecord = new SoundTracker.SoundRecord(null, "relayed_sound_" + relay.hashCode(), new class_2338((int)Math.round(relay.x), (int)Math.round(relay.y), (int)Math.round(relay.z)), world.method_27983().method_29177().toString(), relay.range, relay.weight);
                    if (bestNewSoundEvent != null && !(relayedSoundAsRecord.weight > bestNewSoundEvent.weight) && (!(Math.abs(relayedSoundAsRecord.weight - bestNewSoundEvent.weight) < 0.001) || !(relayedSoundAsRecord.range > bestNewSoundEvent.range))) continue;
                    bestNewSoundEvent = relayedSoundAsRecord;
                }
            }
        } else {
            bestNewSoundEvent = SoundTracker.findNearestSound(world, this.mob, mobPos, this.mob.method_33571());
        }
        if (this.cachedSound == null) {
            finalDecisionSound = bestNewSoundEvent;
        } else if (bestNewSoundEvent == null) {
            finalDecisionSound = null;
        } else {
            boolean similarWeight;
            boolean sameSoundId = Objects.equals(this.cachedSound.soundId, bestNewSoundEvent.soundId);
            boolean samePosition = this.cachedSound.pos.equals((Object)bestNewSoundEvent.pos);
            double effectiveValueToleranceRange = Math.max(1.0, this.cachedSound.range * 0.1);
            double effectiveValueToleranceWeight = Math.max(0.1, this.cachedSound.weight * 0.1);
            boolean similarRange = Math.abs(this.cachedSound.range - bestNewSoundEvent.range) < effectiveValueToleranceRange;
            boolean bl = similarWeight = Math.abs(this.cachedSound.weight - bestNewSoundEvent.weight) < effectiveValueToleranceWeight;
            if (sameSoundId && samePosition && similarRange && similarWeight) {
                finalDecisionSound = bestNewSoundEvent;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] {} REFRESHED target: soundId={}, pos={}, newWeight={}, newRange={}, newTicks={}", new Object[]{this.mob.method_5477().getString(), bestNewSoundEvent.soundId, bestNewSoundEvent.pos, String.format("%.2f", bestNewSoundEvent.weight), String.format("%.2f", bestNewSoundEvent.range), bestNewSoundEvent.ticksRemaining});
                }
            } else {
                boolean shouldSwitch;
                double switchRatio = SoundAttractMod.CONFIG.soundSwitchRatio;
                boolean bl2 = shouldSwitch = bestNewSoundEvent.weight > this.cachedSound.weight * switchRatio;
                if (SoundAttractMod.CONFIG.useRangeInSoundSwitch && !shouldSwitch) {
                    boolean bl3 = shouldSwitch = Math.abs(bestNewSoundEvent.weight - this.cachedSound.weight * switchRatio) < 0.001 && bestNewSoundEvent.range > this.cachedSound.range * switchRatio;
                }
                if (shouldSwitch) {
                    finalDecisionSound = bestNewSoundEvent;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal] {} SWITCHED target from {} (w:{}, r:{}) to {} (w:{}, r:{})", new Object[]{this.mob.method_5477().getString(), this.cachedSound.soundId, String.format("%.2f", this.cachedSound.weight), String.format("%.2f", this.cachedSound.range), bestNewSoundEvent.soundId, String.format("%.2f", bestNewSoundEvent.weight), String.format("%.2f", bestNewSoundEvent.range)});
                    }
                } else {
                    finalDecisionSound = this.cachedSound;
                }
            }
        }
        this.cachedBestSound = finalDecisionSound;
        return this.cachedBestSound;
    }

    public boolean isPursuingSound() {
        return this.isPursuingSound;
    }

    public void setSoundTarget(SoundTracker.SoundRecord sound) {
        boolean isBetter;
        if (sound == null) {
            return;
        }
        double switchRatio = SoundAttractMod.CONFIG.soundSwitchRatio;
        boolean bl = isBetter = this.cachedSound == null || sound.weight > this.cachedSound.weight * switchRatio;
        if (isBetter) {
            this.cachedSound = sound;
            this.targetSoundPos = sound.pos;
            this.currentTargetWeight = sound.weight;
            this.isPursuingSound = true;
            int n = this.pursuingSoundTicksRemaining = sound.ticksRemaining > 0 ? sound.ticksRemaining : SoundAttractMod.CONFIG.scanCooldownTicks;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Externally set new sound target for {}: pos={}, weight={}", new Object[]{this.mob.method_5477().getString(), sound.pos, String.format("%.2f", sound.weight)});
            }
        }
    }

    public static void handleSoundAttraction(class_1308 mob, SoundTracker.SoundRecord sound) {
        AttractionGoal goal = AttractionGoal.getAttractionGoal(mob);
        if (goal != null && sound != null) {
            goal.setSoundTarget(sound);
            goal.cachedSound = sound;
            goal.targetSoundPos = sound.pos;
            goal.currentTargetWeight = sound.weight;
            goal.isPursuingSound = true;
            goal.pursuingSoundTicksRemaining = SoundAttractMod.CONFIG.soundLifetimeTicks;
            goal.edgeMobState = null;
            goal.foundPlayerOrHit = false;
            goal.relayedToLeader = false;
            if (goal.mob.method_5942().method_6357() || goal.mob.method_5942().method_6355() != null && !goal.mob.method_5942().method_6355().equals((Object)sound.pos)) {
                goal.mob.method_5942().method_6337((double)sound.pos.method_10263() + 0.5, (double)sound.pos.method_10264() + 0.5, (double)sound.pos.method_10260() + 0.5, goal.moveSpeed);
            }
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] {} commanded to attract to sound: {}", (Object)mob.method_5477().getString(), (Object)sound.soundId);
            }
        }
    }

    public static void handleRelayToLeader(class_1308 leader, SoundTracker.SoundRecord soundFromRelay, class_1308 edgeMob) {
        AttractionGoal goal = AttractionGoal.getAttractionGoal(leader);
        if (goal != null && soundFromRelay != null) {
            boolean takeNewSound;
            SoundTracker.SoundRecord leaderEvaluatedRelay = soundFromRelay;
            boolean bl = takeNewSound = goal.cachedSound == null || leaderEvaluatedRelay.weight > goal.cachedSound.weight * SoundAttractMod.CONFIG.soundSwitchRatio || edgeMob != null && MobGroupManager.isEdgeMobEntity(edgeMob);
            if (takeNewSound) {
                goal.cachedSound = leaderEvaluatedRelay;
                goal.targetSoundPos = leaderEvaluatedRelay.pos;
                goal.currentTargetWeight = leaderEvaluatedRelay.weight;
                goal.isPursuingSound = true;
                goal.pursuingSoundTicksRemaining = SoundAttractMod.CONFIG.scanCooldownTicks * 2;
                goal.edgeMobState = null;
                goal.relayedToLeader = true;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Leader {} taking relayed sound {} from {}", new Object[]{leader.method_5477().getString(), leaderEvaluatedRelay.pos, edgeMob != null ? edgeMob.method_5477().getString() : "unknown source"});
                }
                if (goal.mob.method_5942().method_6357() || goal.mob.method_5942().method_6355() != null && !goal.mob.method_5942().method_6355().equals((Object)leaderEvaluatedRelay.pos)) {
                    goal.mob.method_5942().method_6337((double)leaderEvaluatedRelay.pos.method_10263() + 0.5, (double)leaderEvaluatedRelay.pos.method_10264() + 0.5, (double)leaderEvaluatedRelay.pos.method_10260() + 0.5, goal.moveSpeed);
                }
            }
        }
    }

    public static void handleLeaderObjective(class_1308 leader, SoundTracker.SoundRecord sound) {
        AttractionGoal goal = AttractionGoal.getAttractionGoal(leader);
        if (goal != null && sound != null) {
            goal.cachedSound = sound;
            goal.targetSoundPos = sound.pos;
            goal.currentTargetWeight = sound.weight;
            goal.isPursuingSound = true;
            goal.pursuingSoundTicksRemaining = SoundAttractMod.CONFIG.scanCooldownTicks * 2;
            goal.edgeMobState = null;
            goal.relayedToLeader = false;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Leader {} received direct objective sound {}", (Object)leader.method_5477().getString(), (Object)sound.soundId);
            }
            if (goal.mob.method_5942().method_6357() || goal.mob.method_5942().method_6355() != null && !goal.mob.method_5942().method_6355().equals((Object)sound.pos)) {
                goal.mob.method_5942().method_6337((double)sound.pos.method_10263() + 0.5, (double)sound.pos.method_10264() + 0.5, (double)sound.pos.method_10260() + 0.5, goal.moveSpeed);
            }
        }
    }

    public static void handleEdgeInvestigate(class_1308 edge, SoundTracker.SoundRecord sound) {
        AttractionGoal goal = AttractionGoal.getAttractionGoal(edge);
        if (goal != null && sound != null && SoundAttractMod.CONFIG.edgeMobSmartBehavior) {
            goal.cachedSound = sound;
            goal.targetSoundPos = sound.pos;
            goal.currentTargetWeight = sound.weight;
            goal.isPursuingSound = true;
            goal.pursuingSoundTicksRemaining = SoundAttractMod.CONFIG.scanCooldownTicks * 2;
            goal.edgeMobState = EdgeMobState.GOING_TO_SOUND;
            goal.foundPlayerOrHit = false;
            goal.relayedToLeader = false;
            goal.edgeArrivalTicks = 0;
            goal.mob.method_5942().method_6340();
            class_1308 leader = MobGroupManager.getLeader(edge);
            if (leader != null && leader != edge && goal.targetSoundPos != null) {
                if (pendingDelayedRelays.containsKey(edge)) {
                    AttractionGoal.pendingDelayedRelays.get((Object)edge).cancelled = true;
                }
                long triggerTime = edge.method_37908().method_8510() + (long)SoundAttractMod.CONFIG.delayedRelayTicks;
                DelayedRelay relay = new DelayedRelay(leader, goal.targetSoundPos, triggerTime);
                pendingDelayedRelays.put(edge, relay);
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Smart Edge {} commanded to investigate {}, scheduling delayed relay.", (Object)edge.method_5477().getString(), (Object)sound.pos);
                }
            }
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Edge mob {} instructed to investigate sound at {}", (Object)edge.method_5477().getString(), (Object)sound.soundId);
            }
        }
    }

    public static AttractionGoal getAttractionGoal(class_1308 mob) {
        if (mob == null) {
            return null;
        }
        try {
            class_1355 goalSelector = ((MobEntityAccessor)mob).getGoalSelector();
            for (class_4135 prioritizedGoal : goalSelector.method_35115()) {
                class_1352 task = prioritizedGoal.method_19058();
                if (!(task instanceof AttractionGoal)) continue;
                AttractionGoal ag = (AttractionGoal)task;
                return ag;
            }
        }
        catch (ClassCastException e) {
            SoundAttractMod.LOGGER.error("Failed to cast MobEntity to MobEntityAccessor for getAttractionGoal. Ensure mixin is applied correctly.", (Throwable)e);
        }
        return null;
    }

    private static enum EdgeMobState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }

    private static class DelayedRelay {
        public final class_1308 leader;
        public final class_2338 soundPos;
        public final long triggerTime;
        public boolean cancelled = false;

        public DelayedRelay(class_1308 leader, class_2338 soundPos, long triggerTime) {
            this.leader = leader;
            this.soundPos = soundPos;
            this.triggerTime = triggerTime;
        }
    }
}

